/*
 * Decompiled with CFR 0.152.
 */
package com.ur.g5.installation.action;

import com.ur.g5.MenuImageResource;
import com.ur.g5.TextResource;
import com.ur.g5.installation.action.AbstractInstallationAction;
import com.ur.polyscope.installation.services.RobotInstallationSite;
import com.ur.swing.ActionDefinition;
import com.ur.swing.dialog.ConfirmationMessage;
import com.ur.view.polyscope.persistence.installation.InstallationFilePersistence;
import gui.polyscope.setup.NewInstallationCreator;
import gui.polyscope.setup.UseInstallationInCurrentProgramDialogCreator;
import gui.tools.ConfirmationMessageProvider;
import gui.tools.DialogCreator;
import gui.tools.LanguagePack;
import java.awt.event.ActionEvent;
import javax.inject.Inject;

class NewInstallationAction
extends AbstractInstallationAction
implements UseInstallationInCurrentProgramDialogCreator {
    private final NewInstallationCreator newInstallationCreator;

    @Inject
    public NewInstallationAction(RobotInstallationSite site, TextResource textResource, NewInstallationCreator newInstallationCreator, DialogCreator dialogCreator) {
        super(site, dialogCreator);
        this.newInstallationCreator = newInstallationCreator;
        this.putValue("Name", textResource.FileInstallation());
        this.putValue("SmallIcon", MenuImageResource.installationSmall());
        this.putValue("SelectedSmallIcon", MenuImageResource.installationSmallHover());
        this.putValue("Function", ActionDefinition.Function.POPUP_MENU_ITEM);
        this.putValue("InternalName", InstallationFilePersistence.NEW_INSTALLATION);
    }

    public void doActionPerformed(ActionEvent e) {
        ConfirmationMessageProvider confirmationMessage = LanguagePack.getConfirmationMessages();
        ConfirmationMessage message = confirmationMessage.confirmUnsavedInstallationChangesOnCreate();
        if (this.askUserToSaveUnsavedChanges(message)) {
            this.newInstallationCreator.showKeepSafetyDialog((UseInstallationInCurrentProgramDialogCreator)this);
        }
    }
}

