/*
 * Decompiled with CFR 0.152.
 */
package com.ur.g5.installation.action;

import com.ur.g5.MenuImageResource;
import com.ur.g5.TextResource;
import com.ur.g5.installation.action.AbstractInstallationAction;
import com.ur.polyscope.filemanager.FileContainer;
import com.ur.polyscope.filemanager.FileManagerConfiguration;
import com.ur.polyscope.filemanager.FileTypePersistence;
import com.ur.polyscope.filemanager.PerformingFileContainer;
import com.ur.polyscope.installation.MetaData;
import com.ur.polyscope.installation.PersistanceMetaData;
import com.ur.polyscope.installation.services.RobotInstallationSite;
import com.ur.polyscope.viewfacade.safety.RobotInstallationPersistenceService;
import com.ur.swing.ActionDefinition;
import com.ur.swing.ViewContext;
import com.ur.swing.dialog.ErrorMessage;
import com.ur.util.logging.Log;
import com.ur.view.installation.filemanager.RobotInstallationFileManagerConfiguration;
import com.ur.view.polyscope.persistence.installation.InstallationFilePersistence;
import gui.tools.DialogCreator;
import java.awt.event.ActionEvent;
import javax.inject.Inject;

class SaveAsInstallationAction
extends AbstractInstallationAction {
    private final FileTypePersistence filePersistence;
    private final RobotInstallationSite lookupService;
    private final RobotInstallationPersistenceService persistenceService;
    private final com.ur.i18n.TextResource textResource;

    @Inject
    public SaveAsInstallationAction(FileTypePersistence filePersistence, RobotInstallationSite lookupService, DialogCreator dialogCreator, RobotInstallationPersistenceService persistenceService, ViewContext viewContext) {
        super(lookupService, dialogCreator);
        this.filePersistence = filePersistence;
        this.lookupService = lookupService;
        this.persistenceService = persistenceService;
        this.textResource = (com.ur.i18n.TextResource)viewContext.getTextResource(com.ur.i18n.TextResource.class);
        TextResource oldTextResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.putValue("Name", oldTextResource.FileSaveInstallationAs());
        this.putValue("SmallIcon", MenuImageResource.installationSmall());
        this.putValue("SelectedSmallIcon", MenuImageResource.installationSmallHover());
        this.putValue("Function", ActionDefinition.Function.POPUP_MENU_ITEM);
        this.putValue("InternalName", InstallationFilePersistence.SAVE_INSTALLATION);
    }

    public void doActionPerformed(ActionEvent e) {
        SaveAsFileContainer saveInstallationFileContainer = new SaveAsFileContainer();
        saveInstallationFileContainer.setFile(this.lookupService == null || this.lookupService.getInstallation() == null ? null : ((PersistanceMetaData)this.lookupService.getInstallation().getMetaData(PersistanceMetaData.class)).file());
        this.filePersistence.saveFile((FileContainer)saveInstallationFileContainer, (FileManagerConfiguration)new RobotInstallationFileManagerConfiguration(this.textResource.saveRobotInstallationTitle()), ".installation");
        this.setupVetosOfScreenStacks();
    }

    private class SaveAsFileContainer
    extends PerformingFileContainer {
        private SaveAsFileContainer() {
        }

        public boolean perform() {
            try {
                if (this.hasFileSelected()) {
                    Log.debug((String)("file = " + this.getFile()));
                    SaveAsInstallationAction.this.lookupService.getInstallation().setMetaData((MetaData)new PersistanceMetaData(this.getFile()));
                    this.saveRobotInstallation();
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.setFile(null);
            }
        }

        public ErrorMessage fatalUnknownException(String title) {
            return new ErrorMessage(title, SaveAsInstallationAction.this.textResource.anUnexpectedErrorOccurredExplanation(), SaveAsInstallationAction.this.textResource.anUnexpectedErrorOccurredSuggestion());
        }

        private void saveRobotInstallation() {
            try {
                SaveAsInstallationAction.this.persistenceService.save(SaveAsInstallationAction.this.lookupService.getInstallation());
            }
            catch (Exception e) {
                SaveAsInstallationAction.this.dialogCreator.showErrorDialog(this.fatalUnknownException(SaveAsInstallationAction.this.textResource.failedToSaveInstallation()), null);
            }
            SaveAsInstallationAction.this.askToUseInstallationInCurrentProgram();
        }
    }
}

