/*
 * Decompiled with CFR 0.152.
 */
package com.ur.g5.installation.menu;

import com.ur.g5.installation.InstallationTab;
import com.ur.g5.installation.menu.InstallationMenuHeaders;
import com.ur.g5.installation.menu.InstallationMenuItems;
import com.ur.i18n.TextResource;
import com.ur.lang.StringUtils;
import com.ur.polyscope.installation.menu.InstallationMenuCategory;
import com.ur.polyscope.installation.menu.InstallationMenuContribution;
import com.ur.swing.AbstractActionDefinition;
import com.ur.swing.baseview.AccordionMenuBuilder;
import com.ur.swing.baseview.AccordionMenuHeader;
import com.ur.swing.baseview.AccordionMenuItem;
import com.ur.swing.baseview.AccordionView;
import com.ur.swing.extensible.MenuExtension;
import com.ur.swing.flippable.FlippablePanel;
import com.ur.urcap.contribution.installation.InstallationContribution;
import com.ur.urcap.contribution.installation.URCapInstallation;
import com.ur.view.polyscope.module.UIInstallationNode;
import com.ur.view.polyscope.module.installation.InstallationContributionsProvider;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.swing.AbstractButton;
import javax.swing.Action;

public class InstallationMenuBuilder
extends AccordionMenuBuilder<InstallationMenuCategory> {
    private static final int PRIORITY = 3500;
    private final InstallationMenuItems items;
    private final InstallationContributionsProvider contributionsProvider;
    private final EnumMap<InstallationMenuCategory, AbstractButton> categoryMap = new EnumMap(InstallationMenuCategory.class);
    private final TextResource textResource;
    private AccordionView accordionView;
    private AbstractButton urCapsSectionHeader;

    @Inject
    public InstallationMenuBuilder(TextResource textResource, InstallationMenuHeaders headers, InstallationMenuItems items, InstallationContributionsProvider contributionsProvider) {
        super((AccordionMenuHeader)headers, (AccordionMenuItem)items, (Enum)InstallationMenuCategory.GENERAL);
        this.textResource = textResource;
        this.items = items;
        this.contributionsProvider = contributionsProvider;
    }

    public void setNavigationMenu(AccordionView accordionView) {
        super.setNavigationMenu(accordionView);
        this.accordionView = accordionView;
    }

    public AbstractButton getNavigationButton(InstallationMenuCategory category) {
        if (category == InstallationMenuCategory.URCAPS) {
            return this.urCapsSectionHeader;
        }
        return this.categoryMap.get(category);
    }

    protected AbstractButton rebuildContributionMenu(List<MenuExtension.EnumMenuContribution<InstallationMenuCategory>> enumMenuContributions, Action sectionAction) {
        AbstractButton button = super.rebuildContributionMenu(enumMenuContributions, sectionAction);
        if (button == null) {
            return null;
        }
        InstallationMenuCategory category = (InstallationMenuCategory)enumMenuContributions.get(0).getMenuCategory();
        this.categoryMap.put(category, button);
        switch (category) {
            case GENERAL: {
                button.setName("generalTab.G5InstallationTab");
                break;
            }
            case MOTION: {
                button.setName("generalTab.G5MotionTab");
                break;
            }
            case SAFETY: {
                button.setName("safetyTab.G5InstallationTab");
                break;
            }
            case FEATURES: {
                button.setName("featuresTab.G5InstallationTab");
                break;
            }
            case FIELDBUS: {
                button.setName("fieldbusTab.G5InstallationTab");
                break;
            }
        }
        return button;
    }

    public void setMenuContributions(Map<InstallationMenuCategory, List<Action>> menuContributions) {
        int[] runner = new int[]{1};
        menuContributions.forEach((installationMenuCategory, actions) -> actions.forEach(action -> {
            this.items.addMenuItem(MenuExtension.MenuContribution.locateAfter((int)(3500 + 10 * runner[0]), (MenuExtension.MenuContribution)new InstallationMenuContribution(action, installationMenuCategory)));
            runner[0] = runner[0] + 1;
        }));
    }

    public void addSpecialContributions(InstallationMenuCategory category, FlippablePanel flippablePanel, Runnable runnable, String ... names) {
        this.contributionsProvider.getUIInstallationNodes().stream().filter(uiInstallationNode -> StringUtils.equalsAny((String)uiInstallationNode.getId(), (String[])names)).forEachOrdered(uiInstallationNode -> this.items.addMenuItem(MenuExtension.MenuContribution.locateAfter((int)3000, (MenuExtension.MenuContribution)new InstallationMenuContribution((Action)((Object)this.getContributedNodeAction(flippablePanel, (UIInstallationNode)uiInstallationNode, runnable)), category))));
    }

    public boolean updateURCapContributions(FlippablePanel flippablePanel, InstallationTab.InstallationTabErrorInfo errorInfo, Runnable runnable, String ... excludes) {
        this.accordionView.removeSection(this.urCapsSectionHeader);
        this.urCapsSectionHeader = null;
        ArrayList<Action> urCapActions = new ArrayList<Action>();
        this.contributionsProvider.getUIInstallationNodes().stream().filter(uiInstallationNode -> !StringUtils.equalsAny((String)uiInstallationNode.getId(), (String[])excludes)).filter(uiInstallationNode -> {
            if (!(uiInstallationNode.getInstallation() instanceof URCapInstallation)) {
                return true;
            }
            InstallationContribution installationContribution = ((URCapInstallation)uiInstallationNode.getInstallation()).getInstallationContribution();
            return installationContribution != null && !(installationContribution.getUserContribution() instanceof com.ur.polyscope.urcaps.extensions.installationnodecontribution.menu.InstallationMenuCategory);
        }).forEach(uiInstallationNode -> {
            InstallationTab.ContributedNodeAction action = this.getContributedNodeActionAndRegisterErrorInfo(flippablePanel, errorInfo, (UIInstallationNode)uiInstallationNode, runnable);
            urCapActions.add((Action)((Object)action));
        });
        if (!urCapActions.isEmpty()) {
            this.urCapsSectionHeader = this.accordionView.addSection((Action)((Object)new URCapSectionHeaderAction(this.textResource, urCapActions)), urCapActions.toArray(new Action[0]));
        }
        return this.urCapsSectionHeader != null;
    }

    private InstallationTab.ContributedNodeAction getContributedNodeAction(FlippablePanel flippablePanel, UIInstallationNode treeNode, Runnable runnable) {
        return new InstallationTab.ContributedNodeAction(flippablePanel, this.contributionsProvider, treeNode, runnable);
    }

    private InstallationTab.ContributedNodeAction getContributedNodeActionAndRegisterErrorInfo(FlippablePanel flippablePanel, InstallationTab.InstallationTabErrorInfo errorInfo, UIInstallationNode treeNode, Runnable runnable) {
        return errorInfo.registerNode(this.getContributedNodeAction(flippablePanel, treeNode, runnable));
    }

    public static class URCapSectionHeaderAction
    extends AbstractActionDefinition {
        private ArrayList<Action> urCapActions;

        public URCapSectionHeaderAction(TextResource textResource, List<Action> urCapActions) {
            this.urCapActions = (ArrayList)urCapActions;
            this.putValue("Name", textResource.urcapsInstallationTabTitle());
            this.putValue("HelpId", "gui:urcapssettingsbutton.urcapsetupmodule");
            this.putValue("InternalName", "urCapsTab.G5URCapInstallationHeaderMenuExtension");
        }

        public void actionPerformed(ActionEvent e) {
            this.urCapActions.get(0).actionPerformed(null);
            this.urCapActions.get(0).putValue("SwingSelectedKey", true);
        }
    }
}

