/*
 * Decompiled with CFR 0.152.
 */
package com.ur.g5.mainpanel;

import com.ur.g5.TextResource;
import com.ur.monitor.RobotState;
import com.ur.monitor.RobotStateListener;
import com.ur.monitor.model.JointPositionVector;
import com.ur.move.AcceptOrCancelJ3DRenderer;
import com.ur.move.AcceptOrCancelRenderer;
import com.ur.move.AcceptOrCancelSwingRenderer;
import com.ur.move.JointPaintStrategy;
import com.ur.move.JointPositionIndicator;
import com.ur.move.JointPositionVectorPanel;
import com.ur.move.MoveTabRobotModel;
import com.ur.move.MoveTabRobotView;
import com.ur.move.OKCancelConfirmationListener;
import com.ur.polyscope.controllerinterface.ControllerInterface;
import com.ur.polyscope.initializerobot.veto.VetoListener;
import com.ur.polyscope.robot.configuration.joint.JointConfigurationSettings;
import com.ur.polyscope.robot.configuration.joint.JointPositionRangeProvider;
import com.ur.polyscope.viewfacade.footercontrols.ControlsSite;
import com.ur.polyscope.visualizer.canvas.RobotCanvas3D;
import com.ur.polyscope.visualizer.canvas.RobotCanvas3DFactory;
import com.ur.polyscope.visualizer.canvasbehavior.ViewBehaviorHolder;
import com.ur.polyscope.visualizer.canvasbehavior.ZoomRenderer;
import com.ur.polyscope.visualizer.geomfeature.ViewableGeomFeature;
import com.ur.polyscope.visualizer.j3dcomponents.J3DComponent;
import com.ur.polyscope.visualizer.panel.ElementsVisualizerAggregator;
import com.ur.swing.CardPanel;
import com.ur.swing.ViewContext;
import com.ur.swing.dialog.ConfirmationDialogListener;
import com.ur.swing.dialog.ConfirmationMessage;
import com.ur.swing.g5.CardBorder;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.swing.help.HelpIdAssigner;
import com.ur.util.event.EventManager;
import com.ur.util.event.EventNotificationService;
import com.ur.util.event.Subscription;
import com.ur.view.constants.dev.SafetyMode;
import gui.installation.RobotInstallationLookupService;
import gui.polyscope.setup.treenodes.geom.SetupFeatureContainerNode;
import gui.tools.DialogCreator;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.inject.Inject;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;

public class JointsVerificationPanel
extends CardPanel
implements OKCancelConfirmationListener {
    public static final String SAVE_JOINT_IDS_CMD = "save joint ids";
    private final MoveTabRobotModel robotModel;
    private final MoveTabRobotView robotView;
    private final JointPositionVectorPanel positionPanel;
    private final JointPaintStrategy jointPaintStrategy;
    private final EventManager eventManager;
    private final RobotInstallationLookupService installationLookup;
    private final TextResource textResource;
    private final ControlsSite controlsSite;
    private final AcceptOrCancelRenderer acceptOrCancelRenderer;
    private final HelpIdAssigner helpIdAssigner;
    private final DialogCreator dialogCreator;
    private Subscription robotStateSubscription = Subscription.NULL;
    private ControllerInterface controllerInterface;

    @Inject
    public JointsVerificationPanel(MoveTabRobotModel robotModel, EventManager eventManager, RobotInstallationLookupService installationLookup, JointPositionRangeProvider rangeProvider, ElementsVisualizerAggregator elementsVisualizerAggregator, JointConfigurationSettings configurationSettings, ViewContext viewContext, ControlsSite controlsSite, RobotCanvas3DFactory robotCanvas3DFactory, ControllerInterface controllerInterface, DialogCreator dialogCreator) {
        this.robotModel = robotModel;
        this.eventManager = eventManager;
        this.installationLookup = installationLookup;
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.controlsSite = controlsSite;
        this.controllerInterface = controllerInterface;
        this.helpIdAssigner = viewContext.getHelpIdAssigner();
        this.dialogCreator = dialogCreator;
        JPanel warningMessagePanel = viewContext.createWidgetFactory().createWarningMessagePanel(this.textResource.moveAndVerifyTheJoints());
        this.robotView = new MoveTabRobotView(elementsVisualizerAggregator, robotModel, robotCanvas3DFactory, false, controllerInterface, "Joint Verification 3D Canvas");
        this.positionPanel = new JointPositionVectorPanel(viewContext, robotModel);
        RobotCanvas3D robotCanvas3D = this.robotView.getRobotCanvas3D();
        this.acceptOrCancelRenderer = robotCanvas3D.isActualCanvas() ? new AcceptOrCancelJ3DRenderer((OKCancelConfirmationListener)this, this.textResource.jointsOk(), this.textResource.jointsFailed(), robotCanvas3D.getComponent()) : new AcceptOrCancelSwingRenderer((OKCancelConfirmationListener)this, this.textResource.jointsOk(), this.textResource.jointsFailed());
        robotCanvas3D.addJ3DComponent((J3DComponent)this.acceptOrCancelRenderer);
        robotCanvas3D.addJ3DComponent((J3DComponent)new ZoomRenderer(robotCanvas3D.getComponent(), (ViewBehaviorHolder)robotModel));
        this.robotView.setBorder((Border)new CardBorder(((com.ur.i18n.TextResource)viewContext.getTextResource(com.ur.i18n.TextResource.class)).Robot()));
        this.jointPaintStrategy = new JointPaintStrategy(rangeProvider, this.positionPanel.getJointPositionIndicators().toArray(new JointPositionIndicator[this.positionPanel.getJointPositionIndicators().size()]), this.positionPanel.getJointPositionFields().toArray(new JTextField[this.positionPanel.getJointPositionFields().size()]), new JTextField[0], this.positionPanel.getJointRevolutionLabels().toArray(new JLabel[this.positionPanel.getJointRevolutionLabels().size()]));
        this.jointPaintStrategy.setConfigurationSettings(configurationSettings);
        this.setLayout(new BorderLayout(5, 5));
        this.setBackground(G5LookAndFeel.BETWEEN_CARD_COLOR);
        this.setBorder(new MatteBorder(5, 5, 5, 5, G5LookAndFeel.BETWEEN_CARD_COLOR));
        this.add(warningMessagePanel, "North");
        this.add((Component)this.robotView, "Center");
        this.add((Component)this.positionPanel, "East");
        this.initHelpIds();
    }

    private void initHelpIds() {
        this.helpIdAssigner.assignHelpId((JComponent)this.positionPanel, "gui:movetab_jointcontrol");
        this.helpIdAssigner.assignHelpId((JComponent)this.robotView, "gui:movetab_3drobot");
    }

    public void enter(Object o) {
        this.controlsSite.requestControls(new ControlsSite.DashboardOptions[]{ControlsSite.DashboardOptions.SPEED_SLIDER});
        this.acceptOrCancelRenderer.setEnabled(true, true);
        this.jointPaintStrategy.setEnabledOnAllTextFields(true);
        this.jointPaintStrategy.paintJointLimits(RobotState.getLatestRobotState().reducedModeActive, true);
        this.jointPaintStrategy.hideTargetPositions();
        this.robotView.updateRobotState(RobotState.getLatestRobotState());
        this.robotModel.setJoggableGeomFeature((ViewableGeomFeature)((SetupFeatureContainerNode)this.installationLookup.getInstallation().getComponent(SetupFeatureContainerNode.class)).getCameraView());
        this.robotView.enter();
        this.robotStateSubscription = this.eventManager.addStrongListener(RobotStateListener.class, (Object)new MoveTabRobotStateListener());
        EventNotificationService.notify(VetoListener.class, listener -> listener.veto(JointsVerificationPanel.class, VetoListener.VetoType.ROBOTMODE_CHANGE_MESSAGES));
    }

    public Object exit() {
        this.controlsSite.requestControls(new ControlsSite.DashboardOptions[0]);
        this.robotStateSubscription.dispose();
        this.robotView.exit();
        EventNotificationService.notify(VetoListener.class, listener -> listener.cancelVeto(JointsVerificationPanel.class, VetoListener.VetoType.ROBOTMODE_CHANGE_MESSAGES));
        return super.exit();
    }

    public void okAction() {
        ConfirmationDialogListener listener = new ConfirmationDialogListener(){

            public void onOkClicked() {
                JointsVerificationPanel.this.controllerInterface.runScript(JointsVerificationPanel.SAVE_JOINT_IDS_CMD);
                JointsVerificationPanel.this.navigateBack();
            }
        };
        this.confirmJoints(listener);
    }

    public void cancelAction() {
        this.powerOffRobot();
        this.navigateBack();
    }

    protected void powerOffRobot() {
        this.controllerInterface.runScript("power off");
    }

    protected void confirmJoints(ConfirmationDialogListener confirmationDialogListener) {
        ConfirmationMessage message = new ConfirmationMessage(this.textResource.jointsVerified(), this.textResource.jointsVerifiedMessage(), this.textResource.Yes(), this.textResource.No());
        this.dialogCreator.showConfirmationDialog(message, confirmationDialogListener);
    }

    private class MoveTabRobotStateListener
    implements RobotStateListener {
        private boolean performUpdateOfTextField = true;

        private MoveTabRobotStateListener() {
        }

        public void updateRobotState(RobotState rs) {
            this.performUpdateOfTextField = !this.performUpdateOfTextField;
            JointPositionVector jointPositionVector = rs.jointPosition;
            JointsVerificationPanel.this.robotView.updateRobotState(rs);
            JointsVerificationPanel.this.jointPaintStrategy.setEnabledOnAllTextFields(rs.masterSafetyState != SafetyMode.RECOVERY);
            JointsVerificationPanel.this.jointPaintStrategy.paintJointLimits(rs.reducedModeActive, false);
            JointsVerificationPanel.this.jointPaintStrategy.setPositionsValues(jointPositionVector);
            if (this.performUpdateOfTextField) {
                JointsVerificationPanel.this.jointPaintStrategy.paintJointText(jointPositionVector, rs.reducedModeActive);
            }
        }
    }
}

