/*
 * Decompiled with CFR 0.152.
 */
package com.ur.g5.mainpanel;

import com.ur.g5.TextResource;
import com.ur.lang.react.Recipe;
import com.ur.monitor.Source;
import com.ur.move.MoveTab;
import com.ur.polyscope.security.SafetyType;
import com.ur.polyscope.security.UserAccessState;
import com.ur.polyscope.security.accessmode.AccessMode;
import com.ur.polyscope.security.accessmode.AccessModeService;
import com.ur.swing.FlipManagerProvider;
import com.ur.swing.dialog.AggregateDialogCreator;
import com.ur.swing.dialog.ErrorMessage;
import com.ur.swing.extensible.Extension;
import com.ur.swing.extensible.MenuExtension;
import com.ur.view.constants.dev.OperationalMode;
import com.ur.view.constants.dev.SafetyMode;
import java.awt.event.ActionEvent;
import javax.inject.Inject;
import javax.swing.AbstractAction;
import javax.swing.Action;

@Extension(value="InitializeRobot")
public class MoveTabRobotRecovery
extends AbstractAction
implements MenuExtension {
    private final AccessModeService accessModeService;
    private final FlipManagerProvider provider;
    private final AggregateDialogCreator dialogCreator;
    private final TextResource textResource;
    private UserAccessState userAccessState = UserAccessState.DEFAULT;

    @Inject
    MoveTabRobotRecovery(AccessModeService accessModeService, FlipManagerProvider provider, @Source(value=UserAccessState.class) Recipe<UserAccessState> recipe, AggregateDialogCreator dialogCreator, TextResource textResource) {
        this.accessModeService = accessModeService;
        this.provider = provider;
        this.dialogCreator = dialogCreator;
        this.textResource = textResource;
        recipe.distinctUntilChanged().subscribe(o -> {
            this.userAccessState = o;
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.canSwitchToMoveTab()) {
            this.provider.get().stackCurrentCardAndSwitchTo(MoveTab.class, (Object)SafetyMode.RECOVERY);
        } else {
            this.dialogCreator.showErrorDialog(new ErrorMessage(this.textResource.switchToLocalControl(), this.textResource.localControlRequiredToRecover()), null);
        }
    }

    private boolean canSwitchToMoveTab() {
        return AccessMode.isLocal((AccessMode)this.accessModeService.getAccessMode()) && (this.userAccessState.getOperationalMode() != OperationalMode.AUTOMATIC || this.userAccessState.getSafetyType() != SafetyType.STRICT);
    }

    public MenuExtension.MenuContribution create() {
        return new MenuExtension.MenuContribution((Action)this, "RECOVERY");
    }
}

