/*
 * Decompiled with CFR 0.152.
 */
package com.ur.g5.polyscope;

import com.ur.g5.polyscope.HeaderActionFactory;
import com.ur.polyscope.program.ProgramModeHolder;
import com.ur.swing.extensible.ApplicationStateVisualization;
import com.ur.swing.extensible.Extension;
import com.ur.swing.extensible.MenuExtension;
import com.ur.swing.extensible.ViewLayout;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.util.event.EventManager;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.Action;

@Extension(value="HeaderMenu")
@Singleton
public class CalibrationModeHandler
implements MenuExtension,
ApplicationStateVisualization {
    private final HeaderActionFactory factory;
    private Action programCorrection;
    private ViewLayout headerMenu;

    @Inject
    public CalibrationModeHandler(HeaderActionFactory factory, EventManager manager) {
        this.factory = factory;
        manager.addStrongListener(ProgramModeHolder.ProgramModeListener.class, programMode -> {
            boolean isCalibrationMode;
            boolean bl = isCalibrationMode = programMode == ProgramModeHolder.ProgramMode.Calibration;
            if (isCalibrationMode) {
                this.programCorrection.putValue("SwingSelectedKey", true);
                this.headerMenu.setBackground(G5LookAndFeel.SELECTED_HEADER_BACKGROUND);
                this.headerMenu.setSelectedColor(G5LookAndFeel.HEADER_BACKGROUND);
            }
            this.programCorrection.putValue("visible", isCalibrationMode);
        });
    }

    public MenuExtension.MenuContribution create() {
        this.programCorrection = this.factory.createProgramCorrectionHeaderMenuAction();
        this.programCorrection.putValue("visible", false);
        return MenuExtension.MenuContribution.locateBefore((int)-3000, (MenuExtension.MenuContribution)new MenuExtension.MenuContribution(this.programCorrection, "navigation"));
    }

    public void setHeader(ViewLayout headerMenu) {
        this.headerMenu = headerMenu;
    }
}

