/*
 * Decompiled with CFR 0.152.
 */
package com.ur.g5.polyscope;

import com.ur.g5.polyscope.ProgramControlsPanelBuilder;
import com.ur.g5.runscreen.ControlButtonsPanel;
import com.ur.polyscope.program.ProgramStateListener;
import com.ur.polyscope.program.control.ShowingToolTipListener;
import com.ur.polyscope.program.monitor.ProgramState;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.polyscope.viewfacade.program.ProgramEventListener;
import com.ur.polyscope.viewfacade.program.ProgramEventType;
import com.ur.util.event.EventNotificationService;
import com.ur.view.program.PlayProgramListener;
import com.ur.view.program.linenumbers.BreakPointHitListener;
import gui.program.ProgramRootNode;
import java.io.File;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.JComponent;
import javax.swing.SwingWorker;

@Singleton
class ControlButtonsEnablementService
implements PlayProgramListener,
ProgramStateListener,
ProgramEventListener,
BreakPointHitListener,
ShowingToolTipListener {
    private final ControlButtonsPanel controlButtonsPanel;
    private final ProgramControlsPanelBuilder programControlsPanelBuilder;
    private ProgramState currentProgramState = ProgramState.STOPPED;
    private boolean blockEnablement;
    private boolean requestedEnableStopOnly;
    private boolean requestedDisablePlayPause;
    private SwingWorker<String, String> restoreStateIfNotingHappenedWithinMinUpdateRate;

    @Inject
    ControlButtonsEnablementService(ControlButtonsPanel controlButtonsPanel, ProgramControlsPanelBuilder programControlsPanelBuilder) {
        this.controlButtonsPanel = controlButtonsPanel;
        this.programControlsPanelBuilder = programControlsPanelBuilder;
        EventNotificationService.register((Object)this, ProgramStateListener.class, (Object)this);
        EventNotificationService.register((Object)this, ProgramEventListener.class, (Object)this);
        EventNotificationService.register((Object)this, PlayProgramListener.class, (Object)this);
        EventNotificationService.register((Object)this, BreakPointHitListener.class, (Object)this);
        EventNotificationService.register((Object)this, ShowingToolTipListener.class, (Object)this);
    }

    public void preparingPlay(ProgramRootNode program) {
        this.disablePlayPauseButton();
    }

    public void playing(ProgramRootNode program, ScriptWriter scriptWriter) {
    }

    public void programStateChanged(ProgramState oldState, ProgramState newState) {
        this.currentProgramState = newState;
        this.updateButtonsState();
    }

    private void updateButtonsState() {
        this.beforeStateChange();
        try {
            if (this.blockEnablement) {
                this.programControlsPanelBuilder.setStateBlocked();
                this.controlButtonsPanel.setStateBlocked();
            } else if (this.requestedEnableStopOnly) {
                this.programControlsPanelBuilder.setStateStopOnly();
                this.controlButtonsPanel.setStateStopOnly();
            } else if (this.requestedDisablePlayPause) {
                this.programControlsPanelBuilder.setStatePrePlay();
                this.controlButtonsPanel.setStatePrePlay();
            } else {
                switch (this.currentProgramState) {
                    case STOPPED: {
                        this.programControlsPanelBuilder.setStateStopped();
                        this.controlButtonsPanel.setStateStopped();
                        break;
                    }
                    case PLAYING: 
                    case PAUSED: {
                        this.programControlsPanelBuilder.setStatePausePlaying();
                        this.controlButtonsPanel.setStatePausePlaying();
                        break;
                    }
                    default: {
                        this.programControlsPanelBuilder.setStatePrePlay();
                        this.controlButtonsPanel.setStatePrePlay();
                    }
                }
            }
            this.updateButtonIcons();
        }
        finally {
            this.afterStateChanged();
        }
    }

    private void updateButtonIcons() {
        switch (this.currentProgramState) {
            case STOPPED: {
                this.programControlsPanelBuilder.setViewStopped();
                this.controlButtonsPanel.setViewStopped();
                break;
            }
            case PLAYING: {
                this.programControlsPanelBuilder.setViewPlaying();
                this.controlButtonsPanel.setViewPlaying();
                break;
            }
            case PAUSED: {
                this.programControlsPanelBuilder.setViewPaused();
                this.controlButtonsPanel.setViewPaused();
                break;
            }
        }
    }

    private void beforeStateChange() {
        if (this.restoreStateIfNotingHappenedWithinMinUpdateRate != null) {
            this.restoreStateIfNotingHappenedWithinMinUpdateRate.cancel(true);
            this.restoreStateIfNotingHappenedWithinMinUpdateRate = null;
        }
    }

    private void afterStateChanged() {
        if (this.requestedDisablePlayPause) {
            this.restoreStateIfNotingHappenedWithinMinUpdateRate = new SwingWorker<String, String>(){

                @Override
                protected String doInBackground() throws Exception {
                    TimeUnit.SECONDS.sleep(3L);
                    return "OK";
                }

                @Override
                protected void done() {
                    if (!this.isCancelled()) {
                        ControlButtonsEnablementService.this.updateButtonsState();
                    }
                }
            };
            this.restoreStateIfNotingHappenedWithinMinUpdateRate.execute();
        }
        this.requestedDisablePlayPause = false;
        this.requestedEnableStopOnly = false;
    }

    public void enableButtons(boolean enableButtons) {
        this.blockEnablement = !enableButtons;
        this.updateButtonsState();
    }

    public void enableStopButtonOnly() {
        this.requestedEnableStopOnly = true;
        this.updateButtonsState();
    }

    private void disablePlayPauseButton() {
        this.requestedDisablePlayPause = true;
        this.updateButtonsState();
    }

    public void handleProgramEvent(ProgramEventType programEventType) {
        if (ProgramEventType.POST_NEW_PROGRAM.equals((Object)programEventType)) {
            this.updateButtonsState();
        }
    }

    public void handleProgramEvent(ProgramEventType event, com.ur.polyscope.program.ProgramRootNode programRootNode) {
        this.handleProgramEvent(event);
    }

    public void handleProgramEvent(ProgramEventType event, File programFile) {
        this.handleProgramEvent(event);
    }

    public void breakPointHit(int labelID) {
        this.currentProgramState = ProgramState.PAUSED;
        this.updateButtonsState();
    }

    public JComponent getFooterToolTipAnchorPoint() {
        return this.controlButtonsPanel.getToolTipAnchorPoint();
    }

    public void setFooterVisible(boolean visible) {
        this.programControlsPanelBuilder.setVisible(visible);
    }

    public void toolTipShown() {
        this.enableButtons(false);
    }

    public void toolTipClosed() {
        this.enableButtons(true);
    }

    public void toolTipSkipped() {
    }
}

