/*
 * Decompiled with CFR 0.152.
 */
package com.ur.g5.polyscope;

import com.ur.g5.polyscope.AutomaticEnablementController;
import com.ur.g5.polyscope.EnablementController;
import com.ur.g5.polyscope.ManualEnablementController;
import com.ur.lang.react.Consumer;
import com.ur.lang.react.Recipe;
import com.ur.monitor.Source;
import com.ur.monitor.model.RobotMode;
import com.ur.polyscope.core.api.annotation.NoControlButtonVisibilityChange;
import com.ur.polyscope.security.AccessControlStateListener;
import com.ur.polyscope.security.UserAccessControl;
import com.ur.polyscope.security.accessmode.AccessMode;
import com.ur.polyscope.security.accessmode.AccessModeChangedListener;
import com.ur.polyscope.security.accessmode.AccessModeService;
import com.ur.polyscope.viewfacade.footercontrols.ControlsSite;
import com.ur.safety.security.SafetyLock;
import com.ur.safety.security.SafetyLockListener;
import com.ur.safety.urcapcontribution.URCapSafetyLock;
import com.ur.swing.CardChangedListener;
import com.ur.swing.CardPanel;
import com.ur.util.event.EventManager;
import com.ur.view.constants.dev.OperationalMode;
import com.ur.view.constants.runtime.ControlMode;
import gui.main.MainPanel;
import gui.polyscope.RunTab;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;

public class FooterComponentsEnablementController
implements CardChangedListener {
    private static final String INITIALIZATION_PANEL = "InitializationPanel";
    private final MainPanel mainPanel;
    private final UserAccessControl userAccessControl;
    private final AccessModeService accessModeService;
    private final ControlsSite controlsSite;
    private final ButtonEnablementInFreedrive buttonEnablement;
    private final Map<OperationalMode, EnablementController> operationalModeEnablementControllerMap = new EnumMap<OperationalMode, EnablementController>(OperationalMode.class);
    private Class<? extends CardPanel> lastHandledPanel;

    @Inject
    protected FooterComponentsEnablementController(MainPanel mainPanel, EventManager eventManager, SafetyLock safetyLock, UserAccessControl userAccessControl, AccessModeService accessModeService, ControlsSite controlsSite, AutomaticEnablementController automaticEnablementController, ManualEnablementController manualEnablementController, @Source(value=RobotMode.class) Recipe<RobotMode> robotModeRecipe, URCapSafetyLock urCapSafetyLock) {
        this.mainPanel = mainPanel;
        this.userAccessControl = userAccessControl;
        this.accessModeService = accessModeService;
        this.controlsSite = controlsSite;
        this.operationalModeEnablementControllerMap.put(OperationalMode.AUTOMATIC, automaticEnablementController);
        this.operationalModeEnablementControllerMap.put(OperationalMode.MANUAL, manualEnablementController);
        mainPanel.addCardChangedListener((CardChangedListener)this);
        this.buttonEnablement = new ButtonEnablementInFreedrive();
        robotModeRecipe.executeOnUIThread().forEach((Consumer)this.buttonEnablement);
        eventManager.addStrongListener(AccessControlStateListener.class, (oldState, currentState) -> this.cardSelected(this.lastHandledPanel));
        eventManager.addStrongListener(AccessModeChangedListener.class, accessMode -> this.cardSelected(this.lastHandledPanel));
        this.registerSafetyLockListener(safetyLock, urCapSafetyLock);
        CardPanel panel = mainPanel.getCurrentCard();
        if (panel != null) {
            this.cardSelected(panel.getClass());
        }
    }

    private void registerSafetyLockListener(SafetyLock safetyLock, URCapSafetyLock urCapSafetyLock) {
        SafetyLockListener safetyLockListener = new SafetyLockListener(){

            public void doUnlock() {
                FooterComponentsEnablementController.this.controlsSite.requestControls(new ControlsSite.DashboardOptions[0]);
            }

            public void doLock() {
                FooterComponentsEnablementController.this.controlsSite.requestControls(new ControlsSite.DashboardOptions[]{ControlsSite.DashboardOptions.PLAY_STOP_BUTTONS, ControlsSite.DashboardOptions.SIMULATION_MODE_SWITCH, ControlsSite.DashboardOptions.SPEED_SLIDER});
                FooterComponentsEnablementController.this.cardSelected(FooterComponentsEnablementController.this.lastHandledPanel);
            }
        };
        safetyLock.addSafetyLockListener(safetyLockListener);
        urCapSafetyLock.addSafetyLockListener(safetyLockListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cardSelected(Class<? extends CardPanel> panel) {
        if (this.controlButtonVisibilityChangeAllowed()) {
            this.controlsSite.setPlayControlButtonsVisible(true);
        }
        try {
            if (panel == null) {
                this.controlsSite.requestControls(new ControlsSite.DashboardOptions[0]);
                return;
            }
            this.hidePlayControlButtons();
            if (this.buttonEnablement.getCurrentControlMode() == ControlMode.TEACH && !this.buttonEnablement.isProgramRunning()) {
                this.controlsSite.requestControls(new ControlsSite.DashboardOptions[0]);
                return;
            }
            if (panel.isAnnotationPresent(Named.class) && Objects.equals(panel.getAnnotation(Named.class).value(), INITIALIZATION_PANEL)) {
                this.controlsSite.requestControls(new ControlsSite.DashboardOptions[0]);
                return;
            }
            if (AccessMode.isRemote((AccessMode)this.accessModeService.getAccessMode())) {
                this.controlsSite.requestControls(new ControlsSite.DashboardOptions[0]);
                return;
            }
            OperationalMode operationalMode = this.userAccessControl.getCurrentOperationalMode();
            boolean allCardStacksEmpty = this.mainPanel.getSwitchSupport().isAllCardStacksEmpty();
            this.operationalModeEnablementControllerMap.get(operationalMode).cardSelected(panel, allCardStacksEmpty);
        }
        finally {
            this.lastHandledPanel = panel;
        }
    }

    private boolean controlButtonVisibilityChangeAllowed() {
        CardPanel currentCardPanel = this.mainPanel.getCurrentCard();
        return currentCardPanel != null && !currentCardPanel.getClass().isAnnotationPresent(NoControlButtonVisibilityChange.class);
    }

    private void hidePlayControlButtons() {
        CardPanel currentCardPanel = this.mainPanel.getCurrentCard();
        if (currentCardPanel instanceof RunTab) {
            this.controlsSite.setPlayControlButtonsVisible(false);
        }
    }

    private class ButtonEnablementInFreedrive
    implements Consumer<RobotMode> {
        private ControlMode currentControlMode;
        private boolean isProgramRunning;

        private ButtonEnablementInFreedrive() {
        }

        public void accept(RobotMode robotMode) {
            ControlMode oldControlMode = this.currentControlMode;
            this.currentControlMode = robotMode.getControlMode();
            this.isProgramRunning = robotMode.isProgramRunning();
            if (oldControlMode != this.currentControlMode) {
                this.handleNewControlMode(this.currentControlMode, robotMode.isProgramRunning());
            }
        }

        private void handleNewControlMode(ControlMode currentControlMode, Boolean isProgramRunning) {
            if (currentControlMode == ControlMode.TEACH && Boolean.TRUE.equals(isProgramRunning == false)) {
                FooterComponentsEnablementController.this.controlsSite.requestControls(new ControlsSite.DashboardOptions[0]);
            } else {
                FooterComponentsEnablementController.this.cardSelected(FooterComponentsEnablementController.this.lastHandledPanel);
            }
        }

        public ControlMode getCurrentControlMode() {
            return this.currentControlMode;
        }

        public boolean isProgramRunning() {
            return this.isProgramRunning;
        }
    }
}

