/*
 * Decompiled with CFR 0.152.
 */
package com.ur.g5.polyscope;

import com.ur.g5.TextResource;
import com.ur.g5.polyscope.ControlButtonsEnablementService;
import com.ur.g5.polyscope.SpeedPanel;
import com.ur.polyscope.simulation.RobotDeviceService;
import com.ur.polyscope.viewfacade.footercontrols.ControlsSite;
import com.ur.swing.DisplayMessageFactory;
import com.ur.util.swing.HTML;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.JComponent;

@Singleton
public class FooterControlsHandler
implements ControlsSite {
    private final SpeedPanel speedPanel;
    private final RobotDeviceService robotDeviceService;
    private final TextResource textResource;
    private final ControlButtonsEnablementService controlButtonsEnablementService;

    @Inject
    public FooterControlsHandler(SpeedPanel speedPanel, RobotDeviceService robotDeviceService, TextResource textResource, ControlButtonsEnablementService controlButtonsEnablementService) {
        this.speedPanel = speedPanel;
        this.robotDeviceService = robotDeviceService;
        this.textResource = textResource;
        this.controlButtonsEnablementService = controlButtonsEnablementService;
    }

    public void requestControls(ControlsSite.DashboardOptions ... options) {
        boolean isUsingStopButtonOnly;
        this.speedPanel.enableSpeedSlider(ControlsSite.DashboardOptions.containsSpeedSlider((ControlsSite.DashboardOptions[])options));
        if (ControlsSite.DashboardOptions.containsFullSpeed((ControlsSite.DashboardOptions[])options)) {
            if (this.speedPanel.isVisible()) {
                this.speedPanel.setFullSpeed();
                this.speedPanel.setVisible(false);
                ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);
                executor.schedule(() -> DisplayMessageFactory.attentionWithoutTimeout((JComponent)this.controlButtonsEnablementService.getFooterToolTipAnchorPoint(), (String)HTML.html((String)this.textResource.runningAtFullSpeed())), 250L, TimeUnit.MILLISECONDS);
            }
        } else if (!this.speedPanel.isVisible() && ControlsSite.DashboardOptions.containsPlayStop((ControlsSite.DashboardOptions[])options)) {
            this.speedPanel.setVisible(true);
        }
        if (isUsingStopButtonOnly = ControlsSite.DashboardOptions.containsStopButtonOnly((ControlsSite.DashboardOptions[])options)) {
            this.controlButtonsEnablementService.enableStopButtonOnly();
        } else {
            this.controlButtonsEnablementService.enableButtons(ControlsSite.DashboardOptions.containsPlayStop((ControlsSite.DashboardOptions[])options));
        }
        if (ControlsSite.DashboardOptions.containsSimulationModeSwitch((ControlsSite.DashboardOptions[])options)) {
            this.robotDeviceService.removeViewLock(FooterControlsHandler.class);
        } else {
            this.robotDeviceService.addViewLock(FooterControlsHandler.class);
        }
    }

    public void setPlayControlButtonsVisible(boolean visible) {
        this.controlButtonsEnablementService.setFooterVisible(visible);
    }
}

