/*
 * Decompiled with CFR 0.152.
 */
package com.ur.g5.polyscope;

import com.ur.g5.util.MenuContributionActionDecorator;
import com.ur.polyscope.security.PrivilegeRestriction;
import com.ur.swing.ViewContext;
import com.ur.swing.extensible.ApplicationStateVisualization;
import com.ur.swing.extensible.Extension;
import com.ur.swing.extensible.ExtensionPoint;
import com.ur.swing.extensible.FooterExtension;
import com.ur.swing.extensible.Menu;
import com.ur.swing.extensible.MenuExtension;
import com.ur.swing.extensible.ViewLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;

@Extension(value="PolyScope")
@ExtensionPoint(value="Footer")
@Singleton
public class FooterPanel
extends JPanel
implements FooterExtension,
Menu,
ViewLayout {
    public static final String FOOTER_PANEL = "footerPanel." + FooterPanel.class.getSimpleName();
    protected final List<MenuExtension.MenuContribution> leftMenuContributions = new ArrayList<MenuExtension.MenuContribution>();
    protected final List<MenuExtension.MenuContribution> rightMenuContributions = new ArrayList<MenuExtension.MenuContribution>();
    protected final Box leftMenuBox = Box.createHorizontalBox();
    protected final Box rightMenuBox = Box.createHorizontalBox();
    private final MenuContributionActionDecorator menuContributionActionDecorator;

    @Inject
    public FooterPanel(ViewContext viewContext, Set<ApplicationStateVisualization> visualizationSet, MenuContributionActionDecorator menuContributionActionDecorator) {
        this.menuContributionActionDecorator = menuContributionActionDecorator;
        this.setName(FOOTER_PANEL);
        this.setLayout(new BoxLayout(this, 0));
        this.setBorder(BorderFactory.createEmptyBorder());
        Dimension panelSize = new Dimension(1280, 65);
        this.setMinimumSize(panelSize);
        this.setPreferredSize(panelSize);
        this.setMaximumSize(panelSize);
        this.initLeftMenuBox();
        this.initRightMenuBox();
        visualizationSet.forEach(o -> o.setHeader((ViewLayout)this));
        viewContext.getHelpIdAssigner().assignHelpId((JComponent)this, "gui:footer_buttons");
    }

    private void initLeftMenuBox() {
        this.leftMenuBox.setMaximumSize(new Dimension(Integer.MAX_VALUE, 65));
        this.add(this.leftMenuBox);
    }

    private void initRightMenuBox() {
        this.rightMenuBox.setMaximumSize(new Dimension(Integer.MAX_VALUE, 65));
        this.add(this.rightMenuBox);
    }

    protected void styleComponents(Component[] components) {
        for (Component component : components) {
            this.styleComponent(component);
        }
    }

    private void styleComponent(Component component) {
        component.setBackground(UIManager.getColor("Footer.background"));
        component.setForeground(UIManager.getColor("Footer.foreground"));
    }

    public void addMenuItem(MenuExtension.MenuContribution menuItemContribution) {
        switch (menuItemContribution.getCategory().toUpperCase()) {
            case "LEFT": {
                this.addLeftContribution(menuItemContribution);
                break;
            }
            case "MIDDLE": {
                throw new UnsupportedOperationException("Footer menu does not have a middle section");
            }
            default: {
                this.addRightContribution(menuItemContribution);
            }
        }
    }

    private void addLeftContribution(MenuExtension.MenuContribution menuContribution) {
        this.addContributionToList(this.leftMenuContributions, menuContribution);
        this.rebuildLeftMenu();
    }

    private void rebuildLeftMenu() {
        this.leftMenuBox.removeAll();
        this.rebuildMenu(this.leftMenuContributions, this.leftMenuBox);
        this.leftMenuBox.add(Box.createHorizontalGlue());
        this.styleComponents(this.leftMenuBox.getComponents());
    }

    private void addRightContribution(MenuExtension.MenuContribution menuContribution) {
        this.addContributionToList(this.rightMenuContributions, menuContribution);
        this.rebuildRightMenu();
    }

    private void rebuildRightMenu() {
        this.rightMenuBox.removeAll();
        this.rightMenuBox.add(Box.createHorizontalGlue());
        this.rebuildMenu(this.rightMenuContributions, this.rightMenuBox);
        this.styleComponents(this.rightMenuBox.getComponents());
    }

    private void rebuildMenu(List<MenuExtension.MenuContribution> menuContributions, Box menuBox) {
        for (MenuExtension.MenuContribution menuContribution : menuContributions) {
            PrivilegeRestriction restriction = this.getPrivilegeRestriction(menuContribution);
            JComponent menuComponent = this.menuContributionActionDecorator.createMenuComponent(menuContribution, restriction);
            menuBox.add(menuComponent);
        }
    }

    private void addContributionToList(List<MenuExtension.MenuContribution> menuContributions, MenuExtension.MenuContribution menuContribution) {
        menuContributions.add(menuContribution);
        menuContributions.sort(Comparator.comparingInt(MenuExtension.MenuContribution::getPriority));
    }

    private PrivilegeRestriction getPrivilegeRestriction(MenuExtension.MenuContribution menuContribution) {
        if (menuContribution.getDefaultRestriction() == MenuExtension.MenuContribution.Restrictions.NO_RESTRICTION) {
            return PrivilegeRestriction.NO_RESTRICTION;
        }
        return PrivilegeRestriction.RESTRICT_FOR_AUTOMATIC;
    }

    public JComponent createFooter() {
        return this;
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        Arrays.asList(this.getComponents()).forEach(o -> this.setBackgroundForChild((JComponent)o, color));
    }

    private void setBackgroundForChild(JComponent component, Color color) {
        component.setBackground(color);
        Arrays.asList(component.getComponents()).forEach(o -> this.setBackgroundForChild((JComponent)o, color));
    }

    public void setSelectedColor(Color color) {
    }
}

