/*
 * Decompiled with CFR 0.152.
 */
package com.ur.g5.polyscope;

import com.ur.g5.TextResource;
import com.ur.g5.polyscope.HeaderMenu;
import com.ur.lang.react.Recipe;
import com.ur.monitor.Source;
import com.ur.polyscope.controllerinterface.AdditionalInfo;
import com.ur.swing.BindingRegistrationWasClosed;
import com.ur.swing.DisplayMessageFactory;
import com.ur.util.event.Subscription;
import com.ur.util.swing.HTML;
import com.ur.view.constants.dev.TPButtonState;
import com.ur.view.constants.dev.TPType;
import gui.polyscope.DoNotShowAgainToolTipSettings;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.swing.JComponent;
import javax.swing.JLabel;
import net.java.balloontip.BalloonTip;

public class FreedriveToolTip {
    public static final String FREEDRIVE_TOOL_TIP_LABEL = FreedriveToolTip.class.getName() + "tooltipLabel";
    private final Provider<HeaderMenu> headerMenuProvider;
    private final DoNotShowAgainToolTipSettings settings;
    private final TextResource textResource;
    private BindingRegistrationWasClosed freedriveToolTipRegistration;
    private final Subscription tooltipShowSubscription;
    private final Subscription tooltipHideSubscription;
    private static boolean testing;

    @Inject
    public FreedriveToolTip(Provider<HeaderMenu> headerMenuProvider, DoNotShowAgainToolTipSettings settings, TextResource textResource, @Source(value=AdditionalInfo.class) Recipe<AdditionalInfo> additionalInfoRecipe) {
        this.headerMenuProvider = headerMenuProvider;
        this.settings = settings;
        this.textResource = textResource;
        this.tooltipShowSubscription = additionalInfoRecipe.map(additionalInfo -> additionalInfo.getTeachPendantType().equals((Object)TPType.THREE_POSITION_ENABLING) && additionalInfo.getTPButtonState().equals((Object)TPButtonState.PRESSED)).distinctUntilChanged().executeOnUIThread().subscribe(pressed -> {
            if (Boolean.TRUE.equals(pressed)) {
                this.showFreedriveToolTip();
            }
        });
        this.tooltipHideSubscription = additionalInfoRecipe.map(additionalInfo -> additionalInfo.getTeachPendantType().equals((Object)TPType.THREE_POSITION_ENABLING) && additionalInfo.getTPButtonState().equals((Object)TPButtonState.CLICKED_AND_PRESSED)).distinctUntilChanged().executeOnUIThread().subscribe(clickedAndPressed -> {
            if (Boolean.TRUE.equals(clickedAndPressed)) {
                this.silenceTooltip();
            }
        });
    }

    private void silenceTooltip() {
        this.settings.setFreedriveInfo(Boolean.valueOf(false));
        if (!testing) {
            this.tooltipShowSubscription.dispose();
            this.tooltipHideSubscription.dispose();
        }
        if (this.freedriveToolTipRegistration != null) {
            this.freedriveToolTipRegistration.removeRegistration();
        }
    }

    public static void setTesting(boolean value) {
        testing = value;
    }

    private void showFreedriveToolTip() {
        if (this.settings.showFreedriveInfo() && (this.freedriveToolTipRegistration == null || this.freedriveToolTipRegistration.wasClosed())) {
            JLabel label = new JLabel(HTML.html((String)this.textResource.doNotShowAgain()));
            label.setName(FREEDRIVE_TOOL_TIP_LABEL);
            label.setForeground(Color.BLUE);
            label.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    FreedriveToolTip.this.silenceTooltip();
                }
            });
            this.freedriveToolTipRegistration = DisplayMessageFactory.attentionWithoutTimeout((JComponent)((JComponent)this.headerMenuProvider.get()), (String)HTML.html((String)this.textResource.freedriveButtonHasChanged()), (BalloonTip.AttachLocation)BalloonTip.AttachLocation.NORTH, (Dimension)new Dimension(), (JComponent)label);
        }
    }
}

