/*
 * Decompiled with CFR 0.152.
 */
package com.ur.g5.polyscope;

import com.ur.g5.util.MenuContributionActionDecorator;
import com.ur.polyscope.calibration.programcorrection.ProgramCorrectionAccessListener;
import com.ur.polyscope.program.ProgramModeHolder;
import com.ur.polyscope.security.AccessControlStateListener;
import com.ur.polyscope.security.UserAccessControl;
import com.ur.resources.ViewImageResource;
import com.ur.swing.ActionDefinition;
import com.ur.swing.WidgetFactory;
import com.ur.swing.extensible.AddLayer;
import com.ur.swing.extensible.Extension;
import com.ur.swing.extensible.ExtensionPoint;
import com.ur.swing.extensible.Layer;
import com.ur.swing.extensible.Menu;
import com.ur.swing.extensible.MenuExtension;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.util.event.EventManager;
import com.ur.util.swing.LayeredIcon;
import com.ur.view.ActionFactory;
import com.ur.view.about.ShowAboutDialogAction;
import com.ur.view.constants.dev.OperationalMode;
import com.ur.view.serialnumber.SerialNumberScreenImpl;
import gui.installation.services.LookupServiceFacade;
import gui.main.MainView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

@Singleton
@Extension(value="HeaderMenu")
@ExtensionPoint(value="HamburgerMenu")
public class HamburgerMenuButtonFactory
implements ProgramCorrectionAccessListener,
Menu,
MenuExtension,
AddLayer {
    public static final String HAMBURGER_MENU = "HamburgerMenuButton.HeaderMenu";
    public static final String HELP_MENU = "helpMenuButton.HeaderMenu";
    private static final String DO_NOT_CANCEL_POPUP_PROPERTY = "doNotCancelPopup";
    private final MainView mainView;
    private final WidgetFactory widgetFactory;
    private final ActionFactory actionFactory;
    private final EventManager eventManager;
    private final UserAccessControl userAccessControl;
    private final ProgramModeHolder programModeHolder;
    private final MenuContributionActionDecorator menuContributionActionDecorator;
    private HamburgerMenuAction hamburgerMenuAction;
    private Icon decoratedIcon = new LayeredIcon(ViewImageResource.hamburgerMenu(), new Icon[0]);
    private List<MenuExtension.MenuContribution> menuContributionList = new ArrayList<MenuExtension.MenuContribution>();

    @Inject
    public HamburgerMenuButtonFactory(MainView mainView, WidgetFactory widgetFactory, ActionFactory actionFactory, EventManager eventManager, UserAccessControl userAccessControl, ProgramModeHolder programModeHolder, MenuContributionActionDecorator menuContributionActionDecorator) {
        this.mainView = mainView;
        this.widgetFactory = widgetFactory;
        this.actionFactory = actionFactory;
        this.eventManager = eventManager;
        this.userAccessControl = userAccessControl;
        this.programModeHolder = programModeHolder;
        this.menuContributionActionDecorator = menuContributionActionDecorator;
    }

    public void programCorrectionEnabled(boolean enabled) {
        this.hamburgerMenuAction.programCorrectionEnabled(enabled);
    }

    public MenuExtension.MenuContribution create() {
        this.hamburgerMenuAction = new HamburgerMenuAction(this.widgetFactory, this.actionFactory, this.eventManager, this.userAccessControl, this.mainView, this.programModeHolder);
        this.menuContributionActionDecorator.addFamilyMember((MenuExtension.OverlayAction)this.hamburgerMenuAction);
        return MenuExtension.MenuContribution.locateLast((MenuExtension.MenuContribution)new MenuExtension.MenuContribution((MenuExtension.OverlayAction)this.hamburgerMenuAction){

            public JComponent createComponent(Action action) {
                JButton result = HamburgerMenuButtonFactory.this.widgetFactory.createButton(action);
                HamburgerMenuButtonFactory.this.hamburgerMenuAction.setPopupMenuComponent(result);
                Dimension size = new Dimension(64, 64);
                result.setPreferredSize(size);
                JComboBox box = new JComboBox();
                Object preventCancelingPopup = box.getClientProperty(HamburgerMenuButtonFactory.DO_NOT_CANCEL_POPUP_PROPERTY);
                result.putClientProperty(HamburgerMenuButtonFactory.DO_NOT_CANCEL_POPUP_PROPERTY, preventCancelingPopup);
                return result;
            }
        });
    }

    public void addLayer(Layer layer) {
        layer.decorate((JComponent)new JLabel(this.decoratedIcon));
    }

    public void addMenuItem(MenuExtension.MenuContribution menuContribution) {
        this.menuContributionList.add(menuContribution);
        if (this.hamburgerMenuAction != null) {
            this.hamburgerMenuAction.initPopupMenu();
        }
    }

    private class MenuContributionSorter
    implements Comparator<MenuExtension.MenuContribution> {
        private MenuContributionSorter() {
        }

        @Override
        public int compare(MenuExtension.MenuContribution o1, MenuExtension.MenuContribution o2) {
            return o1.getPriority() - o2.getPriority();
        }
    }

    private class HamburgerMenuAction
    extends MenuExtension.AbstractOverlayAction
    implements ProgramCorrectionAccessListener {
        private final WidgetFactory widgetFactory;
        private final ActionFactory actionFactory;
        private final MainView mainPanel;
        private final ProgramModeHolder programModeHolder;
        private final JComponent programCorrectionSeparator;
        private final JMenuItem programCorrectionAction;
        private JPopupMenu popupMenu;

        HamburgerMenuAction(WidgetFactory widgetFactory, ActionFactory actionFactory, EventManager eventManager, UserAccessControl userAccessControl, MainView mainPanel, ProgramModeHolder programModeHolder) {
            this.widgetFactory = widgetFactory;
            this.actionFactory = actionFactory;
            this.mainPanel = mainPanel;
            this.programModeHolder = programModeHolder;
            HamburgerMenuButtonFactory.this.menuContributionList.add(new MenuExtension.MenuContribution((Action)LookupServiceFacade.get(ShowAboutDialogAction.class)));
            HamburgerMenuButtonFactory.this.menuContributionList.add(MenuExtension.MenuContribution.locateMiddle((MenuExtension.MenuContribution)new MenuExtension.MenuContribution(actionFactory.createShowSettingsScreenAction())));
            this.initPopupMenu();
            this.programCorrectionSeparator = widgetFactory.createSeparator(Color.WHITE);
            this.programCorrectionAction = this.createProgramCorrectionAction(widgetFactory, actionFactory, eventManager, userAccessControl, mainPanel);
            this.putValue("Function", ActionDefinition.Function.APPLICATION_HEADER);
            this.putValue("SmallIcon", ViewImageResource.hamburgerMenu());
            this.putValue("InternalName", HamburgerMenuButtonFactory.HAMBURGER_MENU);
            this.putValue("HelpId", "gui:hamburger_menu");
            eventManager.addStrongListener(ProgramModeHolder.ProgramModeListener.class, (Object)new ProgramModeHolder.ProgramModeListener(){

                public void changedMode(ProgramModeHolder.ProgramMode newMode) {
                    if (newMode == ProgramModeHolder.ProgramMode.Calibration) {
                        this.setColor(G5LookAndFeel.HEADER_BACKGROUND);
                    } else {
                        this.setColor(G5LookAndFeel.SELECTED_HEADER_BACKGROUND);
                    }
                }

                private void setColor(Color color) {
                    for (Component component : HamburgerMenuAction.this.popupMenu.getComponents()) {
                        if (!(component instanceof JMenuItem)) continue;
                        component.setBackground(color);
                    }
                    HamburgerMenuAction.this.popupMenu.setBorder(BorderFactory.createLineBorder(color, 2));
                }
            });
        }

        public void putValue(String key, Object newValue) {
            if ("SmallIcon".equals(key) && ViewImageResource.hamburgerMenu().equals(newValue)) {
                newValue = HamburgerMenuButtonFactory.this.decoratedIcon;
            }
            super.putValue(key, newValue);
        }

        public void programCorrectionEnabled(boolean enabled) {
            this.initPopupMenu();
            if (enabled) {
                this.addProgramCorrectionToPopupMenu();
            }
        }

        private void initPopupMenu() {
            this.popupMenu = new JPopupMenu();
            this.popupMenu.setName("HamburgerMenuButton.HeaderMenu.popup");
            JMenuItem helpButton = this.widgetFactory.createMenuButton(this.actionFactory.createHelpAction());
            helpButton.setName(HamburgerMenuButtonFactory.HELP_MENU);
            this.popupMenu.add((Component)helpButton);
            HamburgerMenuButtonFactory.this.menuContributionList.sort(new MenuContributionSorter());
            for (MenuExtension.MenuContribution each : HamburgerMenuButtonFactory.this.menuContributionList) {
                this.popupMenu.add(this.widgetFactory.createMenuButton(each.contribution));
            }
            this.popupMenu.addPopupMenuListener(new HamburgerMenuIconUpdater());
            this.popupMenu.addPopupMenuListener((PopupMenuListener)((Object)this));
            this.popupMenu.pack();
        }

        private void addProgramCorrectionToPopupMenu() {
            this.popupMenu.add(this.programCorrectionSeparator);
            this.popupMenu.add(this.programCorrectionAction);
            this.popupMenu.pack();
        }

        private JMenuItem createProgramCorrectionAction(WidgetFactory widgetFactory, ActionFactory actionFactory, EventManager eventManager, UserAccessControl userAccessControl, MainView mainPanel) {
            JMenuItem correctAction = widgetFactory.createMenuButton(actionFactory.createProgramCorrectionPopupAction());
            boolean isCalibration = this.programModeHolder.getMode() == ProgramModeHolder.ProgramMode.Calibration;
            eventManager.addStrongListener(AccessControlStateListener.class, (oldState, currentState) -> {
                boolean show = currentState.getOperationalMode() == OperationalMode.MANUAL && mainPanel.getSwitchSupport().isAllCardStacksEmpty() || isCalibration;
                correctAction.getAction().setEnabled(show);
            });
            mainPanel.addCardChangedListener(panel -> {
                boolean show = userAccessControl.getCurrentOperationalMode() == OperationalMode.MANUAL && mainPanel.getSwitchSupport().isAllCardStacksEmpty() || isCalibration;
                correctAction.getAction().setEnabled(show);
            });
            correctAction.getAction().setEnabled(userAccessControl.getCurrentOperationalMode() == OperationalMode.MANUAL);
            return correctAction;
        }

        void setPopupMenuComponent(Component component) {
            component.addMouseListener(new ShowHideMenuMouseListener(component));
        }

        public void actionPerformed(ActionEvent e) {
        }

        private class ShowHideMenuMouseListener
        extends MouseAdapter {
            private final Component component;

            ShowHideMenuMouseListener(Component component) {
                this.component = component;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (HamburgerMenuAction.this.isEnabled()) {
                    if (HamburgerMenuAction.this.popupMenu.isVisible()) {
                        HamburgerMenuAction.this.popupMenu.setVisible(false);
                    } else {
                        HamburgerMenuAction.this.popupMenu.show(this.component, this.component.getWidth() - ((HamburgerMenuAction)HamburgerMenuAction.this).popupMenu.getPreferredSize().width, this.component.getHeight());
                    }
                }
            }
        }

        private class HamburgerMenuIconUpdater
        implements PopupMenuListener {
            private HamburgerMenuIconUpdater() {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                HamburgerMenuAction.this.putValue("SmallIcon", ViewImageResource.hamburgerMenuClose());
                Class<?> currentCard = HamburgerMenuAction.this.mainPanel.getSwitchSupport().getCurrentCard().getClass();
                if (currentCard.equals(SerialNumberScreenImpl.class)) {
                    HamburgerMenuAction.this.programCorrectionAction.getAction().setEnabled(false);
                }
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                HamburgerMenuAction.this.putValue("SmallIcon", ViewImageResource.hamburgerMenu());
                Class<?> currentCard = HamburgerMenuAction.this.mainPanel.getSwitchSupport().getCurrentCard().getClass();
                if (currentCard.equals(SerialNumberScreenImpl.class)) {
                    HamburgerMenuAction.this.programCorrectionAction.getAction().setEnabled(true);
                }
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                HamburgerMenuAction.this.putValue("SmallIcon", ViewImageResource.hamburgerMenu());
            }
        }
    }
}

