/*
 * Decompiled with CFR 0.152.
 */
package com.ur.g5.polyscope;

import com.ur.g5.polyscope.WelcomeScreen;
import com.ur.i18n.TextResource;
import com.ur.injection.Builder;
import com.ur.move.MoveTab;
import com.ur.polyscope.oldio.IOTab;
import com.ur.polyscope.security.LockActionCreator;
import com.ur.polyscope.security.LockableRestrictedPoint;
import com.ur.polyscope.security.Privileges;
import com.ur.polyscope.security.RestrictedPoint;
import com.ur.polyscope.settings.SetupPanel;
import com.ur.resources.ViewImageResource;
import com.ur.swing.ActionDefinition;
import com.ur.swing.FlipManager;
import com.ur.swing.InterceptableAction;
import com.ur.swing.ShowScreenActionImpl;
import com.ur.view.action.ShowExpertScreenAction;
import com.ur.view.action.ShowProgramCorrectionScreenAction;
import com.ur.view.serialnumber.SerialNumberScreenImpl;
import gui.main.MainPanel;
import gui.polyscope.ProgramTab;
import gui.polyscope.RunTab;
import javax.inject.Inject;
import javax.swing.Action;

public class HeaderActionFactory {
    private static final String RUN_SCREEN = "runScreen.HeaderMenu";
    private static final String SETTINGS_SCREEN = "settingsScreen.HeaderMenu";
    private static final String PROGRAM_CORRECTION_SCREEN = "programCorrectionScreen.HeaderMenu";
    private static final String PROGRAM_SCREEN = "programScreen.HeaderMenu";
    private static final String MOVE_SCREEN = "moveScreen.HeaderMenu";
    private static final String IO_SCREEN = "ioScreen.HeaderMenu";
    private final Builder builder;
    private final LockActionCreator actionForPrivilegeDecorator;
    private final Privileges privilegeSite;
    private final TextResource textResource;

    @Inject
    public HeaderActionFactory(Builder builder, Privileges privilegeSite, LockActionCreator actionForPrivilegeDecorator, TextResource textResource) {
        this.builder = builder;
        this.privilegeSite = privilegeSite;
        this.actionForPrivilegeDecorator = actionForPrivilegeDecorator;
        this.textResource = textResource;
    }

    public Action createShowRunScreenAction() {
        ShowScreenActionImpl result = new ShowScreenActionImpl(RunTab.class, (FlipManager)this.builder.get(MainPanel.class));
        result.putValue("Name", (Object)this.textResource.tabRun());
        result.putValue("SmallIcon", (Object)ViewImageResource.logoWhite());
        result.putValue("Function", (Object)ActionDefinition.Function.APPLICATION_HEADER);
        result.putValue("InternalName", (Object)RUN_SCREEN);
        result.putValue("HelpId", (Object)"gui:runtab");
        return result;
    }

    public Action createShowMoveScreenAction() {
        ShowScreenActionImpl result = new ShowScreenActionImpl(MoveTab.class, (FlipManager)this.builder.get(MainPanel.class));
        result.putValue("Name", (Object)this.textResource.tabMove());
        result.putValue("SmallIcon", (Object)ViewImageResource.moveWhite());
        result.putValue("Function", (Object)ActionDefinition.Function.APPLICATION_HEADER);
        result.putValue("InternalName", (Object)MOVE_SCREEN);
        result.putValue("HelpId", (Object)"gui:movetab");
        return this.actionForPrivilegeDecorator.lockWithPrivilege((InterceptableAction)result, this.privilegeSite.getPrivilege((RestrictedPoint)LockableRestrictedPoint.MOVE));
    }

    public Action createShowIOScreenAction() {
        ShowScreenActionImpl result = new ShowScreenActionImpl(IOTab.class, (FlipManager)this.builder.get(MainPanel.class));
        result.putValue("Name", (Object)this.textResource.tabIo());
        result.putValue("SmallIcon", (Object)ViewImageResource.ioWhite());
        result.putValue("Function", (Object)ActionDefinition.Function.APPLICATION_HEADER);
        result.putValue("InternalName", (Object)IO_SCREEN);
        result.putValue("HelpId", (Object)"sec:iotab");
        return result;
    }

    public Action createShowProgramScreenAction() {
        ShowScreenActionImpl result = new ShowScreenActionImpl(ProgramTab.class, (FlipManager)this.builder.get(MainPanel.class));
        result.putValue("Name", (Object)this.textResource.tabProgram());
        result.putValue("SmallIcon", (Object)ViewImageResource.programWhite());
        result.putValue("Function", (Object)ActionDefinition.Function.APPLICATION_HEADER);
        result.putValue("InternalName", (Object)PROGRAM_SCREEN);
        result.putValue("HelpId", (Object)"gui:program");
        return this.actionForPrivilegeDecorator.lockWithPrivilege((InterceptableAction)result, this.privilegeSite.getPrivilege((RestrictedPoint)LockableRestrictedPoint.EDIT_PROGRAM));
    }

    public Action createShowSettingsScreenAction() {
        ShowScreenActionImpl result = new ShowScreenActionImpl(SetupPanel.class, (FlipManager)this.builder.get(MainPanel.class), true);
        result.putValue("Name", (Object)this.textResource.tabSetup());
        result.putValue("SmallIcon", (Object)ViewImageResource.settingsWhite());
        result.putValue("SelectedSmallIcon", (Object)ViewImageResource.settingsBlack());
        result.putValue("Function", (Object)ActionDefinition.Function.POPUP_MENU_ITEM);
        result.putValue("InternalName", (Object)SETTINGS_SCREEN);
        return result;
    }

    public Action createProgramCorrectionHeaderMenuAction() {
        ShowProgramCorrectionScreenAction result = (ShowProgramCorrectionScreenAction)this.builder.get(ShowProgramCorrectionScreenAction.class);
        result.setPopupMenuAction(false);
        result.putValue("Name", (Object)this.textResource.tabProgramCorrection());
        result.putValue("SmallIcon", (Object)ViewImageResource.programCorrectionHeaderMenu());
        result.putValue("Function", (Object)ActionDefinition.Function.APPLICATION_HEADER);
        result.putValue("InternalName", (Object)PROGRAM_CORRECTION_SCREEN);
        result.putValue("HelpId", (Object)"chap:program_correction");
        return result;
    }

    public Action createShowSerialScreenAction() {
        return new ShowScreenActionImpl(SerialNumberScreenImpl.class, (FlipManager)this.builder.get(MainPanel.class), true);
    }

    public Action createShowExpertScreen() {
        return (Action)this.builder.get(ShowExpertScreenAction.class);
    }

    public Action createShowWelcomeScreen() {
        return new ShowScreenActionImpl(WelcomeScreen.class, (FlipManager)this.builder.get(MainPanel.class), false);
    }
}

