/*
 * Decompiled with CFR 0.152.
 */
package com.ur.g5.polyscope;

import com.ur.g5.polyscope.HeaderActionFactory;
import com.ur.g5.polyscope.programandinstallation.infrastructure.ActiveProgramAndInstallationDisplay;
import com.ur.g5.util.MenuContributionActionDecorator;
import com.ur.lang.react.Consumer;
import com.ur.lang.react.Recipe;
import com.ur.monitor.Source;
import com.ur.monitor.model.RobotMode;
import com.ur.polyscope.security.KickToScreen;
import com.ur.polyscope.security.PrivilegeRestriction;
import com.ur.polyscope.security.UserAccessState;
import com.ur.polyscope.viewfacade.security.PrivilegeChangeNotifier;
import com.ur.swing.CardChangedListener;
import com.ur.swing.CardPanel;
import com.ur.swing.FlipManager;
import com.ur.swing.ShowScreenActionImpl;
import com.ur.swing.SwingWidgetFactory;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.extensible.AddLayer;
import com.ur.swing.extensible.ApplicationStateVisualization;
import com.ur.swing.extensible.Extension;
import com.ur.swing.extensible.ExtensionPoint;
import com.ur.swing.extensible.HeaderExtension;
import com.ur.swing.extensible.Layer;
import com.ur.swing.extensible.Menu;
import com.ur.swing.extensible.MenuExtension;
import com.ur.swing.extensible.ViewLayout;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.util.ArrayUtils;
import com.ur.util.IterableEnumerationWrapper;
import com.ur.view.constants.dev.SafetyMode;
import gui.main.MainView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

@Singleton
@Extension(value="PolyScope")
@ExtensionPoint(value="HeaderMenu")
public class HeaderMenu
extends JPanel
implements HeaderExtension,
Menu,
PrivilegeRestriction,
AddLayer,
ViewLayout {
    public static final String INIT_ROBOT_SCREEN = "initRobotScreen.HeaderMenu";
    public static final String RUN_SCREEN = "runScreen.HeaderMenu";
    public static final String SETTINGS_SCREEN = "settingsScreen.HeaderMenu";
    public static final String INSTALLATION_SCREEN = "installationScreen.HeaderMenu";
    public static final String PROGRAM_SCREEN = "programScreen.HeaderMenu";
    public static final String MOVE_SCREEN = "moveScreen.HeaderMenu";
    public static final String IO_SCREEN = "ioScreen.HeaderMenu";
    public static final String USER_PROFILE = "operationalMode.HeaderMenu";
    public static final String SET_OPERATIONAL_MODE_MANUAL = "setUserProgrammer.HeaderMenu.OperationalMode";
    public static final String SET_OPERATIONAL_MODE_AUTOMATIC = "setUserOperator.HeaderMenu.OperationalMode";
    public static final String HAMBURGER_MENU = "HamburgerMenuButton.HeaderMenu";
    public static final String HEADER_MENU = "headerMenu." + HeaderMenu.class.getSimpleName();
    public static final String SET_REMOTE_CONTROL = "setRemoteControl.HeaderMenu.SystemProfile";
    public static final String SET_LOCAL_CONTROL = "setLocalControl.HeaderMenu.SystemProfile";
    public static final String NAVIGATION = "navigation";
    public static final String VISIBLE = "visible";
    private final MainView mainView;
    private final ActiveProgramAndInstallationDisplay activeProgramAndInstallation;
    private final MenuContributionActionDecorator menuContributionActionDecorator;
    private final List<MenuExtension.MenuContribution> navigationMenuContributions = new ArrayList<MenuExtension.MenuContribution>();
    private final List<MenuExtension.MenuContribution> statusMenuContributions = new ArrayList<MenuExtension.MenuContribution>();
    private final List<AbstractButton> toBeCleared = new ArrayList<AbstractButton>();
    private final ButtonGroup buttonGroup = new ButtonGroup();
    private final WidgetFactory widgetFactory;
    private final HeaderActionFactory actions;
    private int gbcIndex = 0;

    @Inject
    public HeaderMenu(MainView mainView, Set<ApplicationStateVisualization> modes, ViewContext view, ActiveProgramAndInstallationDisplay activeProgramAndInstallation, HeaderActionFactory actions, final KickToScreen kickService, @Source(value=RobotMode.class) Recipe<RobotMode> robotModeRecipe, MenuContributionActionDecorator menuContributionActionDecorator, CardChangeNotifier cardChangeNotifier) {
        super(new GridBagLayout());
        this.mainView = mainView;
        this.activeProgramAndInstallation = activeProgramAndInstallation;
        this.actions = actions;
        this.menuContributionActionDecorator = menuContributionActionDecorator;
        this.widgetFactory = view.createWidgetFactory();
        this.setBackground(G5LookAndFeel.HEADER_BACKGROUND);
        this.navigationMenuContributions.add(MenuExtension.MenuContribution.locateBefore((int)1000, (MenuExtension.MenuContribution)new MenuExtension.MenuContribution(actions.createShowProgramScreenAction(), NAVIGATION)));
        this.navigationMenuContributions.add(MenuExtension.MenuContribution.locateBefore((int)2000, (MenuExtension.MenuContribution)new MenuExtension.MenuContribution(actions.createShowMoveScreenAction(), NAVIGATION)));
        this.navigationMenuContributions.add(MenuExtension.MenuContribution.locateAfter((int)2000, (MenuExtension.MenuContribution)new MenuExtension.MenuContribution(actions.createShowIOScreenAction(), NAVIGATION)));
        this.addInvisibleGroupedButton(this.toggleButton(this.widgetFactory, actions.createShowSettingsScreenAction()));
        this.add((Component)Box.createHorizontalBox(), this.nextGap());
        this.add((Component)activeProgramAndInstallation, this.nextItem());
        this.add((Component)Box.createHorizontalBox(), this.nextGap());
        this.setLowerBorder(G5LookAndFeel.SELECTED_HEADER_BACKGROUND);
        mainView.addCardChangedListener((CardChangedListener)cardChangeNotifier);
        robotModeRecipe.subscribe((Consumer)new Consumer<RobotMode>(){

            public void accept(RobotMode robotMode) {
                if (this.isJointValidationMode(robotMode)) {
                    this.kickToInitScreenIfCardStackEmpty();
                }
            }

            private boolean isJointValidationMode(RobotMode robotMode) {
                return robotMode.getSafetyMode() == SafetyMode.VALIDATE_JOINT_ID && robotMode.getRobotMode() == com.ur.view.constants.dev.RobotMode.RUNNING;
            }

            private void kickToInitScreenIfCardStackEmpty() {
                if (HeaderMenu.this.mainView.getSwitchSupport().isCardStackEmpty()) {
                    kickService.kickToInitScreen();
                }
            }
        });
        this.setName(HEADER_MENU);
        modes.stream().forEach(o -> o.setHeader((ViewLayout)this));
    }

    public JComponent createHeader() {
        return this;
    }

    public void addMenuItem(MenuExtension.MenuContribution menuItemContribution) {
        if (menuItemContribution.contribution instanceof ShowScreenActionImpl) {
            ((ShowScreenActionImpl)menuItemContribution.contribution).setFlipManager((FlipManager)this.mainView);
        }
        if (NAVIGATION.equalsIgnoreCase(menuItemContribution.getCategory())) {
            this.navigationMenuContributions.add(menuItemContribution);
        } else {
            this.statusMenuContributions.add(menuItemContribution);
        }
        this.navigationMenuContributions.sort(Comparator.comparingInt(MenuExtension.MenuContribution::getPriority));
        this.statusMenuContributions.sort(Comparator.comparingInt(MenuExtension.MenuContribution::getPriority));
        for (AbstractButton abstractButton : new IterableEnumerationWrapper(this.buttonGroup.getElements())) {
            this.buttonGroup.remove(abstractButton);
        }
        this.toBeCleared.listIterator().forEachRemaining(button -> button.setAction(null));
        this.toBeCleared.clear();
        this.removeAll();
        this.gbcIndex = 0;
        for (MenuExtension.MenuContribution menuContribution : this.navigationMenuContributions) {
            Object selectOnStartup;
            AbstractButton abstractButton = this.toggleButton(this.widgetFactory, menuContribution.contribution);
            this.toBeCleared.add(abstractButton);
            this.addGroupedButton(abstractButton);
            Object hiddenAction = menuContribution.contribution.getValue("hiddenAction");
            if (hiddenAction instanceof Action) {
                this.widgetFactory.createHiddenPress(abstractButton, (Action)hiddenAction);
            }
            if (!((selectOnStartup = menuContribution.contribution.getValue("selectOnStartup")) instanceof Class)) continue;
            abstractButton.setSelected(selectOnStartup == this.mainView.getCurrentCard().getClass());
        }
        this.addInvisibleGroupedButton(this.toggleButton(this.widgetFactory, this.actions.createShowSettingsScreenAction()));
        this.add((Component)Box.createHorizontalBox(), this.nextGap());
        this.add((Component)this.activeProgramAndInstallation, this.nextItem());
        this.add((Component)Box.createHorizontalBox(), this.nextGap());
        this.menuContributionActionDecorator.addToGrid(this, this.statusMenuContributions);
    }

    public boolean isRestrictedIn(UserAccessState userAccessState) {
        return !this.mainView.getSwitchSupport().isAllCardStacksEmpty();
    }

    public void addLayer(Layer layer) {
        layer.decorate((JComponent)this);
    }

    public void setSelectedColor(Color selected) {
        this.setLowerBorder(selected);
        for (JToggleButton component : ArrayUtils.filter((Object[])this.getComponents(), JToggleButton.class)) {
            ((SwingWidgetFactory.ToggleButtonLookAndFeelUI)component.getUI()).setApplicationHeaderColor(selected);
        }
        this.revalidate();
    }

    @Override
    public void setBackground(Color background) {
        super.setBackground(background);
        for (Component each : this.getComponents()) {
            this.setBackgroundForChild((JComponent)each, background);
        }
        this.revalidate();
    }

    private void setBackgroundForChild(JComponent component, Color bg) {
        component.setBackground(bg);
        Arrays.asList(component.getComponents()).forEach(o -> this.setBackgroundForChild((JComponent)o, bg));
    }

    private AbstractButton toggleButton(WidgetFactory widgetFactory, Action action) {
        JToggleButton result = widgetFactory.createToggleButton(this.menuContributionActionDecorator.applyRestrictions(action, this));
        if (action.getValue(VISIBLE) != null) {
            result.setVisible((Boolean)action.getValue(VISIBLE));
        }
        action.addPropertyChangeListener(evt -> {
            if (evt.getPropertyName().equalsIgnoreCase(VISIBLE)) {
                boolean isVisible = (Boolean)evt.getNewValue();
                result.setVisible(isVisible);
            }
        });
        return result;
    }

    private void setLowerBorder(Color color) {
        this.setBorder(BorderFactory.createMatteBorder(0, 0, 5, 0, color));
    }

    private AbstractButton addGroupedButton(AbstractButton button) {
        this.buttonGroup.add(button);
        this.addComponent(button);
        return button;
    }

    private AbstractButton addInvisibleGroupedButton(AbstractButton button) {
        this.buttonGroup.add(button);
        return button;
    }

    private void addComponent(JComponent component) {
        Dimension size = new Dimension(64, 64);
        component.setPreferredSize(size);
        this.add((Component)component, this.nextItem());
    }

    private GridBagConstraints nextItem() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints(this.gbcIndex, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0);
        ++this.gbcIndex;
        return gridBagConstraints;
    }

    private GridBagConstraints nextGap() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints(this.gbcIndex, 0, 1, 1, 0.1, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0);
        ++this.gbcIndex;
        return gridBagConstraints;
    }

    private static class CardChangeNotifier
    implements CardChangedListener {
        private final PrivilegeChangeNotifier privilegeChangeNotifier;

        @Inject
        CardChangeNotifier(PrivilegeChangeNotifier privilegeChangeNotifier) {
            this.privilegeChangeNotifier = privilegeChangeNotifier;
        }

        public void cardSelected(Class<? extends CardPanel> aClass) {
            this.privilegeChangeNotifier.notifyPrivilegeChanged();
        }
    }
}

