/*
 * Decompiled with CFR 0.152.
 */
package com.ur.g5.polyscope;

import com.ur.polyscope.security.KickToScreen;
import com.ur.swing.CardPanel;
import gui.main.MainPanel;
import gui.polyscope.RunTab;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;

@Singleton
public class KickToScreenImpl
implements KickToScreen {
    private boolean kicking = false;
    private Provider<MainPanel> mainPanelProvider;
    private final CardPanel initializationPanel;

    @Inject
    public KickToScreenImpl(Provider<MainPanel> mainPanelProvider, @Named(value="InitializationPanel") CardPanel initializationPanel) {
        this.mainPanelProvider = mainPanelProvider;
        this.initializationPanel = initializationPanel;
    }

    public void kickToRunScreen() {
        this.kick(RunTab.class);
    }

    public void kickToInitScreen() {
        this.kick(this.initializationPanel.getClass());
    }

    private void kick(Class screen) {
        if (!this.kicking) {
            try {
                this.kicking = true;
                ((MainPanel)this.mainPanelProvider.get()).resetAll();
                ((MainPanel)this.mainPanelProvider.get()).switchTo(screen);
            }
            finally {
                this.kicking = false;
            }
        }
    }
}

