/*
 * Decompiled with CFR 0.152.
 */
package com.ur.g5.polyscope;

import com.ur.g5.ControlsImageResource;
import com.ur.g5.TextResource;
import com.ur.g5.polyscope.ManualHighspeedWarningPanel;
import com.ur.log.logentry.robotmessage.SafetyModes;
import com.ur.monitor.RobotState;
import com.ur.monitor.RobotStateListener;
import com.ur.polyscope.safety.checksum.ActiveSafetyChecksumEvent;
import com.ur.polyscope.safety.checksum.ActiveSafetyChecksumListener;
import com.ur.polyscope.safety.operationalmode.SafetyOperationalMode;
import com.ur.polyscope.security.UserAccessControl;
import com.ur.polyscope.viewfacade.safety.SafetyLimitsProvider;
import com.ur.polyscope.viewfacade.safety.SafetyOperationalModeService;
import com.ur.swing.ViewContext;
import com.ur.swing.dialog.ConfirmationDialogListener;
import com.ur.swing.dialog.ConfirmationMessage;
import com.ur.swing.extensible.Extension;
import com.ur.swing.extensible.MenuExtension;
import com.ur.swing.units.Units;
import com.ur.swing.units.UnitsConverter;
import com.ur.util.event.EventNotificationService;
import com.ur.view.constants.dev.OperationalMode;
import com.ur.view.constants.dev.SafetyMode;
import com.ur.view.constants.runtime.SpeedMode;
import com.ur.view.hmc.ControllerSocketSender;
import gui.polyscope.DragValueChangeHook;
import gui.polyscope.SpeedParams;
import gui.tools.DialogCreator;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;

@Extension(value="Footer")
@Singleton
public class ManualHighSpeedPanel
extends JPanel
implements MenuExtension,
RobotStateListener,
SafetyOperationalModeService.OperationalModeListener {
    public static final String MANUAL_HIGHSPEED_PANEL = "MANUAL_HIGHSPEED_PANEL";
    public static final String MANUAL_HIGHSPEED_BUTTON = "manualHighSpeed.SpeedPanel";
    private static final Dimension PANEL_SIZE = new Dimension(100, 65);
    private final com.ur.i18n.TextResource oldTextResource;
    private final TextResource textResource;
    private final UserAccessControl userAccessControl;
    protected DragValueChangeHook manualHighspeedDragger;
    protected JButton manualHighspeedButton;
    protected boolean manualHighSpeedApproved;
    private SpeedParams speedParams = new SpeedParams();
    protected boolean isShowingManualHighSpeedConfirmationDialog;
    private final DialogCreator dialogCreator;
    private UnitsConverter speedDraggerUnitsConverter = Units.getMmPerSecondConverter();
    private final SafetyLimitsProvider safetyLimitsProvider;

    @Inject
    public ManualHighSpeedPanel(ViewContext viewContext, SafetyLimitsProvider safetyLimitsProvider, DialogCreator dialogCreator, UserAccessControl userAccessControl) {
        this.oldTextResource = (com.ur.i18n.TextResource)viewContext.getTextResource(com.ur.i18n.TextResource.class);
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.safetyLimitsProvider = safetyLimitsProvider;
        this.dialogCreator = dialogCreator;
        this.userAccessControl = userAccessControl;
        this.initComponents();
        this.setName(MANUAL_HIGHSPEED_PANEL);
        EventNotificationService.register((Object)this, RobotStateListener.class, (Object)new ManualHighSpeedIso10218Compliance());
        EventNotificationService.register((Object)this, RobotStateListener.class, (Object)this);
        EventNotificationService.register((Object)this, ActiveSafetyChecksumListener.class, (Object)new SpeedLimitMaxUpdater());
        EventNotificationService.register((Object)this, SafetyOperationalModeService.OperationalModeListener.class, (Object)this);
    }

    public void enableSpeedSlider(boolean enable) {
        this.manualHighspeedButton.setEnabled(enable);
        if (this.manualHighSpeedApproved) {
            this.manualHighspeedDragger.setEnabled(enable);
        }
        if (this.manualHighSpeedApproved && !enable) {
            this.manualHighspeedDragger.abortDrag();
        }
    }

    public MenuExtension.MenuContribution create() {
        return MenuExtension.MenuContribution.locateAfter((int)1000, (MenuExtension.MenuContribution)new MenuExtension.ComponentMenuContribution((JComponent)this, "RIGHT", MenuExtension.MenuContribution.Restrictions.NO_RESTRICTION));
    }

    private String createSpeedLimitLabelText(int speed) {
        return speed + Units.getText().unitMmS();
    }

    private void initComponents() {
        this.initManualHighspeedButton();
        this.initManualHighspeedDragger();
        this.add(this.manualHighspeedButton);
        this.setMinimumSize(PANEL_SIZE);
        this.setPreferredSize(PANEL_SIZE);
        this.setMaximumSize(PANEL_SIZE);
    }

    private void initManualHighspeedButton() {
        this.manualHighspeedButton = new JButton(this.createSpeedLimitLabelText((int)this.speedDraggerUnitsConverter.convertFrom(0.25)));
        this.manualHighspeedButton.setFocusPainted(false);
        this.manualHighspeedButton.setForeground(UIManager.getColor("Footer.foreground"));
        this.manualHighspeedButton.setBackground(UIManager.getColor("Footer.background"));
        this.manualHighspeedButton.setBorder(BorderFactory.createEmptyBorder());
        this.manualHighspeedButton.setPreferredSize(new Dimension(96, 48));
        this.manualHighspeedButton.setIcon(ControlsImageResource.manualHighspeedYellow());
        this.manualHighspeedButton.setHorizontalAlignment(0);
        this.manualHighspeedButton.setHorizontalTextPosition(0);
        this.manualHighspeedButton.setVerticalTextPosition(3);
        this.manualHighspeedButton.setName(MANUAL_HIGHSPEED_BUTTON);
        this.manualHighspeedButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (ManualHighSpeedPanel.this.manualHighspeedButton.isEnabled() && ((ManualHighSpeedPanel)ManualHighSpeedPanel.this).speedParams.speedMode == SpeedMode.MANUAL_HIGH_SPEED) {
                    ManualHighSpeedPanel.this.askManualHighSpeedApproval();
                }
            }
        });
    }

    private void initManualHighspeedDragger() {
        this.manualHighspeedDragger = new DragValueChangeHook((Component)this.manualHighspeedButton, 0, (int)this.speedDraggerUnitsConverter.convertFrom(0.25), (int)this.speedDraggerUnitsConverter.convertFrom(this.getSpeedLimit()), this.oldTextResource);
        this.manualHighspeedDragger.addDragChangeListener((DragValueChangeHook.DragValueListener)new ManualHighspeedDragValueListener());
        this.manualHighspeedDragger.setTitle(this.textResource.speedLimit());
        this.manualHighspeedDragger.setValueMessageFormatString("{0}" + Units.getText().unitMmS());
        this.manualHighspeedDragger.setEnabled(false);
    }

    private ConfirmationMessage createApproveManualHighSpeedMessage() {
        return new ConfirmationMessage(this.textResource.manualHighSpeedConfirmationTitle(), "", this.oldTextResource.OK(), this.oldTextResource.Cancel());
    }

    private ManualHighspeedWarningPanel createManualHighspeedWarningPanel() {
        String topText = this.textResource.manualHighSpeedConfirmationExplanation();
        String bottomText = this.textResource.manualHighSpeedConfirmationWarning();
        Icon icon = ControlsImageResource.manualHighspeedSlide();
        return new ManualHighspeedWarningPanel(topText, bottomText, icon);
    }

    private void askManualHighSpeedApproval() {
        if (this.isManualHighSpeedUnapprovedAndConfirmationDialogNotShowing()) {
            this.isShowingManualHighSpeedConfirmationDialog = true;
            this.dialogCreator.showConfirmationDialogWithCustomMessagePanel(this.createApproveManualHighSpeedMessage(), (JPanel)this.createManualHighspeedWarningPanel(), new ConfirmationDialogListener(){

                public void onOkClicked() {
                    ManualHighSpeedPanel.this.isShowingManualHighSpeedConfirmationDialog = false;
                    ManualHighSpeedPanel.this.allowManualHighSpeed();
                }

                public void onCancelClicked() {
                    ManualHighSpeedPanel.this.isShowingManualHighSpeedConfirmationDialog = false;
                    ManualHighSpeedPanel.this.disallowManualHighSpeed();
                }
            });
        }
    }

    private void allowManualHighSpeed() {
        this.manualHighspeedButton.setIcon(ControlsImageResource.manualHighspeed());
        this.manualHighSpeedApproved = true;
        this.manualHighspeedDragger.setEnabled(true);
    }

    private void disallowManualHighSpeed() {
        this.manualHighspeedButton.setIcon(ControlsImageResource.manualHighspeedYellow());
        this.manualHighSpeedApproved = false;
        this.manualHighspeedDragger.setEnabled(false);
    }

    protected boolean isManualHighSpeedUnapprovedAndConfirmationDialogNotShowing() {
        return !this.manualHighSpeedApproved && !this.isShowingManualHighSpeedConfirmationDialog;
    }

    private double getSpeedLimit() {
        return this.safetyLimitsProvider.getMaxToolSpeed();
    }

    public void updateRobotState(RobotState robotState) {
        SpeedParams newSpeedParams = new SpeedParams(robotState.speedFraction, robotState.speedScaling, robotState.speedFractionLimit, robotState.programPaused, robotState.programRunning, robotState.masterSafetyState, robotState.speedMode);
        if (this.hasSpeedParametersChanged(newSpeedParams)) {
            this.speedParams = newSpeedParams;
            SwingUtilities.invokeLater(() -> this.showManualHighspeed(this.speedParams.speedMode));
        }
    }

    private boolean hasSpeedParametersChanged(SpeedParams newSpeedParams) {
        return this.speedParams == null || !this.speedParams.epsilonEquals(newSpeedParams);
    }

    protected void showManualHighspeed(SpeedMode speedMode) {
        if (OperationalMode.MANUAL.equals((Object)this.userAccessControl.getCurrentOperationalMode()) && SpeedMode.MANUAL_HIGH_SPEED.equals((Object)speedMode)) {
            this.manualHighspeedButton.setVisible(true);
            return;
        }
        this.manualHighspeedButton.setVisible(false);
    }

    public void modeChanged(SafetyOperationalMode oldValue, SafetyOperationalMode newValue) {
        if (newValue != oldValue) {
            this.manualHighspeedDragger.abortDrag();
        }
    }

    private class SpeedLimitMaxUpdater
    implements ActiveSafetyChecksumListener {
        private SpeedLimitMaxUpdater() {
        }

        public void activeSafetyChecksumChanged(ActiveSafetyChecksumEvent activeSafetyChecksumEvent) {
            ManualHighSpeedPanel.this.manualHighspeedDragger.setMax((int)ManualHighSpeedPanel.this.speedDraggerUnitsConverter.convertFrom(ManualHighSpeedPanel.this.getSpeedLimit()));
        }
    }

    private class ManualHighSpeedIso10218Compliance
    implements RobotStateListener {
        private Timer timer;
        private SafetyMode lastHandledState = SafetyMode.UNDEFINED_SAFETY_MODE;

        ManualHighSpeedIso10218Compliance() {
            int fiveMinutesInMs = 300000;
            this.timer = new Timer(fiveMinutesInMs, e -> ManualHighSpeedPanel.this.disallowManualHighSpeed());
            this.timer.setRepeats(false);
        }

        public void updateRobotState(RobotState robotState) {
            if (this.lastHandledState != robotState.masterSafetyState) {
                if (this.threePositionEnablementDevicePressed()) {
                    this.timer.stop();
                } else if (this.threePositionEnablementDeviceReleased(robotState.masterSafetyState)) {
                    this.timer.restart();
                }
                this.lastHandledState = robotState.masterSafetyState;
            }
        }

        private boolean threePositionEnablementDevicePressed() {
            return SafetyModes.isSafetyStop((SafetyMode)this.lastHandledState);
        }

        private boolean threePositionEnablementDeviceReleased(SafetyMode newSafetyMode) {
            return SafetyModes.isSafetyStop((SafetyMode)newSafetyMode);
        }
    }

    private class ManualHighspeedDragValueListener
    extends DragValueChangeHook.DragValueAdapter
    implements ActionListener {
        private Timer timer;
        private DragValueChangeHook speedLimitDragger;

        public void dragStarted(ChangeEvent event) {
            this.speedLimitDragger = (DragValueChangeHook)event.getSource();
            this.startTimer();
        }

        public void dragEnded(ChangeEvent event) {
            this.stopTimer();
            this.resetSpeed();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int speed = this.speedLimitDragger.getValue();
            this.updateSpeed(speed);
        }

        private void resetSpeed() {
            int speed = (int)ManualHighSpeedPanel.this.speedDraggerUnitsConverter.convertFrom(0.25);
            this.updateSpeed(speed);
        }

        private void updateSpeed(int speed) {
            ControllerSocketSender.sendSetSpeedLimit((double)ManualHighSpeedPanel.this.speedDraggerUnitsConverter.convertTo((double)speed));
            ManualHighSpeedPanel.this.manualHighspeedButton.setText(ManualHighSpeedPanel.this.createSpeedLimitLabelText(speed));
        }

        private void startTimer() {
            this.stopTimer();
            this.timer = new Timer(100, this);
            this.timer.setRepeats(true);
            this.timer.start();
        }

        private void stopTimer() {
            if (this.timer != null) {
                this.timer.stop();
                this.timer = null;
            }
        }
    }
}

