/*
 * Decompiled with CFR 0.152.
 */
package com.ur.g5.polyscope;

import com.ur.g5.ControlsImageResource;
import com.ur.polyscope.program.control.ShowingToolTipListener;
import com.ur.program.control.PlayFromSelectionToolTip;
import com.ur.program.control.ProgramControlsListener;
import com.ur.program.control.ShowPlayToolTipFilter;
import com.ur.program.control.ToolTipAnchor;
import com.ur.swing.WidgetFactory;
import com.ur.swing.extensible.Extension;
import com.ur.swing.extensible.MenuExtension;
import com.ur.util.event.EventNotificationService;
import gui.polyscope.DashBoard;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

@Extension(value="Footer")
@Singleton
public class ProgramControlsPanelBuilder
implements MenuExtension,
ToolTipAnchor {
    public static final String PLAY_BUTTON_NAME = "program_run";
    public static final String STOP_BUTTON_DASHBOARD = "stopButton.Dashboard";
    public static final String PROGRAM_STEP = "program_step.DashBoard";
    private static final Dimension PANEL_SIZE = new Dimension(200, 65);
    private final JPanel buttonPanel;
    private final ShowPlayToolTipFilter showPlayToolTipFilter;
    private final PlayFromSelectionToolTip playFromSelectionToolTip;
    private final WidgetFactory widgetFactory;
    private final ProgramControlsListener programControlsListener;
    private final JButton playButton;
    private final JButton stepButton;
    private final JButton stopButton;

    @Inject
    public ProgramControlsPanelBuilder(WidgetFactory widgetFactory, ProgramControlsListener programControlsListener, ShowPlayToolTipFilter showPlayToolTipFilter, PlayFromSelectionToolTip playFromSelectionToolTip) {
        this.widgetFactory = widgetFactory;
        this.programControlsListener = programControlsListener;
        this.showPlayToolTipFilter = showPlayToolTipFilter;
        this.playFromSelectionToolTip = playFromSelectionToolTip;
        this.playButton = this.createPlayButton();
        this.stepButton = this.createProgramControlButton(PROGRAM_STEP, this.stepIcon(), () -> ((ProgramControlsListener)programControlsListener).stepButtonPushed());
        this.stopButton = this.createProgramControlButton(STOP_BUTTON_DASHBOARD, this.stopIcon(), () -> ((ProgramControlsListener)programControlsListener).stopButtonPushed());
        this.buttonPanel = new JPanel();
        this.buttonPanel.add(this.decorate(this.playButton));
        this.buttonPanel.add(new JLabel());
        this.buttonPanel.add(this.decorate(this.stepButton));
        this.buttonPanel.add(new JLabel());
        this.buttonPanel.add(this.decorate(this.stopButton));
        this.buttonPanel.setMinimumSize(PANEL_SIZE);
        this.buttonPanel.setMaximumSize(PANEL_SIZE);
        this.buttonPanel.setPreferredSize(PANEL_SIZE);
    }

    private Icon playIcon() {
        return ControlsImageResource.play();
    }

    private Icon pauseIcon() {
        return ControlsImageResource.pause();
    }

    private Icon stopIcon() {
        return ControlsImageResource.stop();
    }

    private Icon stepIcon() {
        return ControlsImageResource.advance();
    }

    private Icon resumeIcon() {
        return ControlsImageResource.resume();
    }

    private Component decorate(JButton button) {
        button.setBackground(UIManager.getColor("footer.background.color"));
        button.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return button;
    }

    public MenuExtension.MenuContribution create() {
        return MenuExtension.MenuContribution.locateMiddle((MenuExtension.MenuContribution)new MenuExtension.ComponentMenuContribution((JComponent)this.buttonPanel, "RIGHT", MenuExtension.MenuContribution.Restrictions.NO_RESTRICTION));
    }

    private JButton createPlayButton() {
        return this.createProgramControlButton(PLAY_BUTTON_NAME, this.playIcon(), () -> {
            if (this.showPlayToolTipFilter.shouldShow()) {
                this.playFromSelectionToolTip.showToolTip();
            } else {
                this.notifyNotShowingToolTip();
                this.programControlsListener.playButtonPushed();
            }
        });
    }

    public void setStatePrePlay() {
        this.playButton.setEnabled(false);
        this.stepButton.setEnabled(false);
    }

    protected void setStateBlocked() {
        this.playButton.setEnabled(false);
        this.stepButton.setEnabled(false);
        this.stopButton.setEnabled(false);
    }

    public void setStateStopped() {
        this.playButton.setEnabled(DashBoard.canRunProgram());
        this.stepButton.setEnabled(DashBoard.canStepProgram());
        this.stopButton.setEnabled(false);
    }

    public void setStatePausePlaying() {
        this.playButton.setEnabled(true);
        this.stepButton.setEnabled(DashBoard.canStepProgram());
        this.stopButton.setEnabled(true);
    }

    public void setStateStopOnly() {
        this.playButton.setEnabled(false);
        this.stepButton.setEnabled(false);
        this.stopButton.setEnabled(true);
    }

    public void setViewStopped() {
        this.playButton.setIcon(this.playIcon());
    }

    public void setViewPlaying() {
        this.playButton.setIcon(this.pauseIcon());
    }

    public void setViewPaused() {
        this.playButton.setIcon(this.resumeIcon());
    }

    public boolean isButtonEnabled(String buttonName) {
        switch (buttonName) {
            case "program_run": {
                return this.playButton.isEnabled();
            }
            case "stopButton.Dashboard": {
                return this.stopButton.isEnabled();
            }
            case "program_step.DashBoard": {
                return this.stepButton.isEnabled();
            }
        }
        return false;
    }

    private JButton createProgramControlButton(String internalName, Icon icon, final Runnable action) {
        AbstractAction abstractActionResult = new AbstractAction("", icon){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                action.run();
            }
        };
        if (internalName != null) {
            abstractActionResult.putValue("InternalName", internalName);
        }
        JButton result = this.widgetFactory.createButton((Action)abstractActionResult);
        result.setMargin(new Insets(2, 2, 2, 2));
        return result;
    }

    public JComponent getToolTipAnchorPoint() {
        return this.playButton;
    }

    private void notifyNotShowingToolTip() {
        EventNotificationService.notify(ShowingToolTipListener.class, ShowingToolTipListener::toolTipSkipped);
    }

    public void setVisible(boolean visible) {
        this.playButton.setVisible(visible);
        this.stepButton.setVisible(visible);
        this.stopButton.setVisible(visible);
    }
}

