/*
 * Decompiled with CFR 0.152.
 */
package com.ur.g5.polyscope;

import com.ur.polyscope.program.ProgramModeHolder;
import com.ur.polyscope.security.AccessControlStateListener;
import com.ur.polyscope.security.UserAccessControl;
import com.ur.polyscope.security.UserAccessState;
import com.ur.swing.flippable.FlippablePanel;
import com.ur.util.event.EventManager;
import com.ur.util.logging.Log;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ProgramModeUpdater {
    private final ProgramModeHolder programModeService;
    private ProgramModeHolder.ProgramMode modeBasedOnActiveProfile = ProgramModeHolder.ProgramMode.Unknown;

    @Inject
    public ProgramModeUpdater(EventManager eventManager, ProgramModeHolder programModeService, UserAccessControl userAccessControl) {
        this.programModeService = programModeService;
        this.processCurrentState(userAccessControl.getCurrentState());
        this.update();
        eventManager.addStrongListener(AccessControlStateListener.class, (oldState, currentState) -> {
            this.processCurrentState(currentState);
            this.update();
        });
    }

    public void setMainPanel(FlippablePanel mainPanel) {
        mainPanel.addCardChangedListener(panel -> this.update());
        this.update();
    }

    private void processCurrentState(UserAccessState currentState) {
        Log.info((String)("Changed " + currentState));
        switch (currentState.getOperationalMode()) {
            case AUTOMATIC: {
                this.modeBasedOnActiveProfile = ProgramModeHolder.ProgramMode.ReadOnly;
                break;
            }
            case MANUAL: {
                this.modeBasedOnActiveProfile = ProgramModeHolder.ProgramMode.Editable;
                break;
            }
            default: {
                this.modeBasedOnActiveProfile = ProgramModeHolder.ProgramMode.Unknown;
            }
        }
    }

    private void update() {
        if (this.programModeService.getMode() != ProgramModeHolder.ProgramMode.Calibration) {
            if (this.modeBasedOnActiveProfile == ProgramModeHolder.ProgramMode.ReadOnly) {
                Log.debug((String)("if {modeBasedOnActiveProfile: " + this.modeBasedOnActiveProfile + "}"));
                this.setMode(ProgramModeHolder.ProgramMode.ReadOnly);
            } else {
                Log.debug((String)("else {modeBasedOnActiveProfile: " + this.modeBasedOnActiveProfile + "}"));
                this.setMode(this.modeBasedOnActiveProfile);
            }
        }
    }

    private void setMode(ProgramModeHolder.ProgramMode programMode) {
        Log.debug((String)("{programMode: " + programMode + "}"));
        if (this.programModeService.getMode() != programMode) {
            Log.debug((String)("Applying { programMode: " + programMode + "}"));
            this.programModeService.setMode(programMode);
        }
    }
}

