/*
 * Decompiled with CFR 0.152.
 */
package com.ur.g5.polyscope;

import com.ur.polyscope.security.AccessControlStateListener;
import com.ur.polyscope.security.UserAccessState;
import com.ur.polyscope.security.accessmode.AccessMode;
import com.ur.polyscope.security.accessmode.AccessModeChangedListener;
import com.ur.polyscope.simulation.RobotDeviceService;
import com.ur.util.event.EventManager;
import com.ur.view.constants.dev.OperationalMode;
import javax.inject.Inject;

public class SimulationLockController {
    private final EventManager eventManager;
    private final RobotDeviceService robotDeviceService;

    @Inject
    public SimulationLockController(EventManager eventManager, RobotDeviceService robotDeviceService) {
        this.eventManager = eventManager;
        this.robotDeviceService = robotDeviceService;
        this.addListeners();
    }

    private void addListeners() {
        this.eventManager.addStrongListener(AccessControlStateListener.class, (Object)new UpdateOperationalModeOnAccess());
        this.eventManager.addStrongListener(AccessModeChangedListener.class, (Object)new UpdateVetosToRobotDevice());
    }

    private class UpdateVetosToRobotDevice
    implements AccessModeChangedListener {
        private UpdateVetosToRobotDevice() {
        }

        public void accessModeChanged(AccessMode accessMode) {
            if (AccessMode.isRemote((AccessMode)accessMode)) {
                SimulationLockController.this.robotDeviceService.addSimulatedDeviceVeto(AccessModeChangedListener.class);
            } else {
                SimulationLockController.this.robotDeviceService.removeSimulatedDeviceVeto(AccessModeChangedListener.class);
            }
        }
    }

    private class UpdateOperationalModeOnAccess
    implements AccessControlStateListener {
        private UpdateOperationalModeOnAccess() {
        }

        public void accessControlStateChanged(UserAccessState oldState, UserAccessState currentState) {
            if (oldState.getOperationalMode() == OperationalMode.MANUAL && currentState.getOperationalMode() == OperationalMode.AUTOMATIC) {
                SimulationLockController.this.robotDeviceService.addSimulatedDeviceVeto(AccessControlStateListener.class);
            } else if (oldState.getOperationalMode() == OperationalMode.AUTOMATIC && currentState.getOperationalMode() == OperationalMode.MANUAL) {
                SimulationLockController.this.robotDeviceService.removeSimulatedDeviceVeto(AccessControlStateListener.class);
            }
        }
    }
}

