/*
 * Decompiled with CFR 0.152.
 */
package com.ur.g5.polyscope;

import com.ur.g5.TextResource;
import com.ur.lang.EqualsUtil;
import com.ur.monitor.RobotState;
import com.ur.monitor.RobotStateListener;
import com.ur.swing.ViewContext;
import com.ur.swing.extensible.Extension;
import com.ur.swing.extensible.MenuExtension;
import com.ur.swing.g5.DualValueSlider;
import com.ur.util.event.EventNotificationService;
import com.ur.view.hmc.ControllerSocketSender;
import gui.polyscope.DragValueChangeHook;
import gui.polyscope.SpeedParams;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.EventListener;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.plaf.basic.BasicSliderUI;

@Extension(value="Footer")
@Singleton
public class SpeedPanel
extends JPanel
implements MenuExtension,
RobotStateListener {
    public static final String G5_SPEED_PANEL = "SpeedPanel." + SpeedPanel.class.getSimpleName();
    public static final String G5_SPEED_SLIDER = "speedSlider." + SpeedPanel.class.getSimpleName();
    private static final int SEND_MILLIS = 90;
    private static final String FOOTER_FOREGROUND = "Footer.foreground";
    private static final String FOOTER_BACKGROUND = "Footer.background";
    private final com.ur.i18n.TextResource oldTextResource;
    private final TextResource textResource;
    protected DualValueSlider speedSlider;
    protected DragValueChangeHook speedDragger;
    protected JLabel speedPercentLabel;
    private long speedChangeTime;
    private SpeedParams speedParams = new SpeedParams();

    @Inject
    public SpeedPanel(ViewContext viewContext) {
        this.oldTextResource = (com.ur.i18n.TextResource)viewContext.getTextResource(com.ur.i18n.TextResource.class);
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.initComponents();
        this.setComponentNames();
        EventNotificationService.register((Object)this, RobotStateListener.class, (Object)this);
    }

    public void enableSpeedSlider(boolean enable) {
        this.speedSlider.setEnabled(enable);
        this.speedDragger.setEnabled(enable);
    }

    public void setFullSpeed() {
        double speedFraction = SpeedParams.fromDisplaySpeedFraction((int)this.speedSlider.getMaximum());
        this.sendSpeedToController(speedFraction);
        this.updateSpeedChangedTime();
    }

    private void updateSpeedChangedTime() {
        this.speedChangeTime = System.currentTimeMillis();
    }

    private void sendSpeedToController(double speedFraction) {
        ControllerSocketSender.sendSetSpeed((double)speedFraction);
    }

    public MenuExtension.MenuContribution create() {
        return MenuExtension.MenuContribution.locateBefore((int)1000, (MenuExtension.MenuContribution)new MenuExtension.ComponentMenuContribution((JComponent)this, "RIGHT", MenuExtension.MenuContribution.Restrictions.NO_RESTRICTION));
    }

    private void initComponents() {
        JPanel textPanel = this.initTextPanel();
        JPanel sliderPanel = this.initSpeedsliderPanel();
        this.setLayout(new GridLayout(2, 1));
        this.add(sliderPanel);
        this.add(textPanel);
        this.setMinimumSize(new Dimension(250, 65));
        this.setPreferredSize(new Dimension(250, 65));
        this.setMaximumSize(new Dimension(250, 65));
    }

    private JPanel initSpeedsliderPanel() {
        this.initSpeedSlider();
        this.initSpeedDragger();
        JPanel sliderPanel = new JPanel(new FlowLayout(1));
        sliderPanel.setBorder(new EmptyBorder(5, 0, 0, 0));
        sliderPanel.add((Component)this.speedSlider);
        return sliderPanel;
    }

    private JPanel initTextPanel() {
        this.initSpeedPercentLabel();
        JLabel speedLabel = this.initSpeedLabel();
        if (this.isLongText(speedLabel)) {
            return this.getTextPanelForLongText(speedLabel);
        }
        return this.getTextPanel(speedLabel);
    }

    private boolean isLongText(JLabel speedLabel) {
        return SwingUtilities.computeStringWidth(speedLabel.getFontMetrics(speedLabel.getFont()), speedLabel.getText()) > 120;
    }

    private JPanel getTextPanel(JLabel speedLabel) {
        speedLabel.setVerticalAlignment(0);
        speedLabel.setHorizontalAlignment(4);
        this.speedPercentLabel.setVerticalAlignment(0);
        this.speedPercentLabel.setHorizontalAlignment(2);
        JPanel textPanel = new JPanel(new GridLayout(1, 2, 5, 0));
        textPanel.setBorder(new EmptyBorder(5, 0, 0, 0));
        textPanel.add(speedLabel);
        textPanel.add(this.speedPercentLabel);
        return textPanel;
    }

    private JPanel getTextPanelForLongText(JLabel speedLabel) {
        JPanel textPanel = new JPanel(new FlowLayout(0, 5, 0));
        textPanel.setBorder(new EmptyBorder(5, 10, 0, 0));
        textPanel.add(speedLabel);
        textPanel.add(this.speedPercentLabel);
        return textPanel;
    }

    private JLabel initSpeedLabel() {
        JLabel speedLabel = new JLabel(this.oldTextResource.Speed());
        speedLabel.setForeground(UIManager.getColor(FOOTER_FOREGROUND));
        speedLabel.setBackground(UIManager.getColor(FOOTER_BACKGROUND));
        return speedLabel;
    }

    private void initSpeedPercentLabel() {
        this.speedPercentLabel = new JLabel();
        this.speedPercentLabel.setForeground(UIManager.getColor(FOOTER_FOREGROUND));
        this.speedPercentLabel.setBackground(UIManager.getColor(FOOTER_BACKGROUND));
    }

    private void initSpeedSlider() {
        this.speedSlider = new DualValueSlider();
        this.speedSlider.setMinimum(2);
        this.speedSlider.setMaximum(100);
        this.speedSlider.setBackground(UIManager.getColor(FOOTER_FOREGROUND));
        this.speedSlider.setName(G5_SPEED_SLIDER);
        this.speedSlider.setAlignmentY(1.0f);
        this.speedSlider.setAlignmentX(0.5f);
        this.speedSlider.setMinimumSize(new Dimension(230, 24));
        this.speedSlider.setPreferredSize(new Dimension(230, 24));
        this.speedSlider.setMaximumSize(new Dimension(230, 24));
        this.removeLnFMouseListeners((JSlider)this.speedSlider);
    }

    private void removeLnFMouseListeners(JSlider slider) {
        for (MouseListener mouseListener : slider.getMouseListeners()) {
            if (!(mouseListener instanceof BasicSliderUI.TrackListener)) continue;
            slider.removeMouseListener(mouseListener);
            break;
        }
        for (EventListener eventListener : slider.getMouseMotionListeners()) {
            if (!(eventListener instanceof BasicSliderUI.TrackListener)) continue;
            slider.removeMouseMotionListener((MouseMotionListener)eventListener);
            break;
        }
    }

    private void initSpeedDragger() {
        this.speedDragger = new DragValueChangeHook((Component)this.speedSlider, 0, this.speedSlider.getMinimum(), this.speedSlider.getMaximum(), () -> this.speedSlider.getValue(), this.oldTextResource);
        this.speedDragger.addDragChangeListener(new DragValueChangeHook.DragValueListener(){

            public void dragStarted(ChangeEvent event) {
                this.performDragEvent();
            }

            public void dragEnded(ChangeEvent event) {
                this.performDragEvent();
            }

            public void dragChange(ChangeEvent changeEvent) {
                this.performDragEvent();
            }

            private void performDragEvent() {
                double newSpeedFraction;
                int newSpeed = SpeedPanel.this.speedDragger.getValue();
                if (newSpeed > 0 && this.speedFractionChanged(newSpeedFraction = SpeedParams.fromDisplaySpeedFraction((int)newSpeed)) && this.notifyController()) {
                    SpeedPanel.this.sendSpeedToController(newSpeedFraction);
                    SpeedPanel.this.updateSpeedChangedTime();
                }
            }

            private boolean notifyController() {
                return System.currentTimeMillis() - SpeedPanel.this.speedChangeTime > 90L;
            }

            private boolean speedFractionChanged(double newSpeedFraction) {
                return !EqualsUtil.equals((double)newSpeedFraction, (double)((SpeedPanel)SpeedPanel.this).speedParams.speedFraction, (double)0.01);
            }
        });
        this.speedDragger.setTitle(this.textResource.speedScale());
        this.speedDragger.setValueMessageFormatString("{0}%");
    }

    private void setComponentNames() {
        this.setName(G5_SPEED_PANEL);
    }

    public void updateRobotState(RobotState robotState) {
        SpeedParams newSpeedParams = new SpeedParams(robotState.speedFraction, robotState.speedScaling, robotState.speedFractionLimit, robotState.programPaused, robotState.programRunning, robotState.masterSafetyState, robotState.speedMode);
        if (this.speedParams == null || !this.speedParams.epsilonEquals(newSpeedParams)) {
            this.speedParams = newSpeedParams;
            SwingUtilities.invokeLater(() -> this.updateFromParams(this.speedParams));
        }
    }

    void updateFromParams(SpeedParams speedParams) {
        this.speedSlider.setValue(SpeedParams.toDisplaySpeedFraction((double)speedParams.speedFraction));
        this.speedSlider.setIndicatorValue(speedParams.getActualSpeedPercent());
        String actualAndDesiredSpeedText = speedParams.getActualAndDesiredSpeedText();
        this.speedPercentLabel.setText(actualAndDesiredSpeedText);
        this.speedDragger.setAmountText(actualAndDesiredSpeedText);
    }
}

