/*
 * Decompiled with CFR 0.152.
 */
package com.ur.g5.polyscope;

import com.ur.g5.SplashScreenResource;
import com.ur.i18n.TextResource;
import com.ur.lang.persist.WriteableModuleSettings;
import com.ur.swing.aspects.UIInvokeAndWait;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.util.Waiting;
import com.ur.util.swing.HTML;
import gui.main.URGUI;
import gui.tools.LanguagePack;
import gui.tools.LegacyURDialogCreator;
import gui.tools.dialogs.NoDialogShowing;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class SplashScreen
extends JPanel {
    private static final String FONT_TYPE_DEJAVU = "DejaVu";
    private static final WriteableModuleSettings settings = new WriteableModuleSettings("platform.properties");
    private static JFrame frame;
    private JProgressBar loadingProgress;
    private JLabel percentage;
    private TextResource textResource = LanguagePack.getTextResource();

    public SplashScreen() {
        this.initComponents();
        frame = new JFrame();
        frame.setName("SPLASH_SCREEN_NAME");
        frame.setDefaultCloseOperation(3);
        frame.add(this);
        frame.setResizable(false);
        frame.setUndecorated(true);
        frame.pack();
        frame.setLocationRelativeTo(null);
        this.loadingProgress.setValue(0);
        this.showSplash();
    }

    private void showSplash() {
        new Thread(){

            @Override
            public void run() {
                frame.setVisible(true);
                this.trackProgress();
                frame.setVisible(false);
                frame.dispose();
            }

            private void trackProgress() {
                long startTime = System.currentTimeMillis();
                while (!URGUI.isRequestingFocus()) {
                    if (LegacyURDialogCreator.isShowingADialog()) {
                        long startWait = System.currentTimeMillis();
                        Waiting.until((Waiting.ItHappens)new NoDialogShowing(), (int)2, (TimeUnit)TimeUnit.DAYS);
                        long waitedFor = System.currentTimeMillis() - startWait;
                        startTime += waitedFor;
                        continue;
                    }
                    Waiting.pause((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
                    SplashScreen.this.updateProgress((float)(System.currentTimeMillis() - startTime) / (float)SplashScreen.this.getSplashScreenTimer() * 100.0f);
                }
                SplashScreen.this.setSplashScreenTimer(System.currentTimeMillis() - startTime);
                SplashScreen.this.updateProgress(100.0f);
                do {
                    Waiting.pause((long)1L, (TimeUnit)TimeUnit.SECONDS);
                } while (LegacyURDialogCreator.isShowingADialog());
                URGUI.setVisibleAndRequestFocus();
            }
        }.start();
    }

    private long getSplashScreenTimer() {
        return settings.properties().getLong("splashScreenTimer", 21000L);
    }

    private void setSplashScreenTimer(long time) {
        settings.properties().setProperty("splashScreenTimer", time + "");
        try {
            settings.write();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @UIInvokeAndWait
    protected void updateProgress(float tick) {
        this.loadingProgress.setValue((int)tick);
        if (tick > 100.0f) {
            tick = 100.0f;
        }
        this.percentage.setText(HTML.html((String)HTML.h2((String)((int)tick + "%"))));
    }

    private void initComponents() {
        Dimension size = new Dimension(SplashScreenResource.splash().getIconWidth(), SplashScreenResource.splash().getIconHeight());
        this.setPreferredSize(size);
        this.setMinimumSize(size);
        this.setMaximumSize(size);
        this.setLayout(new BorderLayout());
        JLabel loadingMessage = new JLabel();
        loadingMessage.setForeground(G5LookAndFeel.UNIVERSAL_ROBOTS_BLUE);
        loadingMessage.setFont(new Font(FONT_TYPE_DEJAVU, 0, 12));
        loadingMessage.setHorizontalAlignment(0);
        loadingMessage.setText(this.textResource.splashScreenLoading());
        this.percentage = new JLabel();
        this.percentage.setFont(new Font(FONT_TYPE_DEJAVU, 1, 18));
        this.percentage.setHorizontalAlignment(0);
        this.percentage.setForeground(G5LookAndFeel.UNIVERSAL_ROBOTS_BLUE);
        this.loadingProgress = new JProgressBar();
        this.loadingProgress.setOpaque(false);
        this.loadingProgress.setBorder(BorderFactory.createEmptyBorder());
        this.loadingProgress.setForeground(G5LookAndFeel.UNIVERSAL_ROBOTS_BLUE);
        this.loadingProgress.setUI(new BasicProgressBarUI(){

            @Override
            protected Color getSelectionForeground() {
                return Color.black;
            }

            @Override
            protected Color getSelectionBackground() {
                return Color.black;
            }
        });
        this.loadingProgress.setFont(new Font(FONT_TYPE_DEJAVU, 0, 10));
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.setOpaque(false);
        bottomPanel.add((Component)loadingMessage, "North");
        bottomPanel.add((Component)this.percentage, "Center");
        bottomPanel.add((Component)this.loadingProgress, "South");
        this.add((Component)bottomPanel, "South");
    }

    @Override
    public void paintComponent(Graphics g) {
        Icon icon = SplashScreenResource.splash();
        icon.paintIcon(this, g, 0, 0);
    }

    public static void main(String[] args) {
        new SplashScreen();
    }
}

