/*
 * Decompiled with CFR 0.152.
 */
package com.ur.g5.polyscope;

import com.ur.g5.TextResource;
import com.ur.polyscope.security.GoToEnterPassword;
import com.ur.polyscope.security.OperationalModeSource;
import com.ur.polyscope.security.PasswordLoginListener;
import com.ur.polyscope.security.PasswordManager;
import com.ur.polyscope.security.UserAccessControl;
import com.ur.swing.dialog.ErrorMessage;
import com.ur.view.constants.dev.OperationalMode;
import gui.tools.DialogCreator;
import java.awt.event.ActionEvent;
import javax.inject.Inject;
import javax.swing.AbstractAction;

public abstract class SwitchToOperationalModeAction
extends AbstractAction {
    protected final OperationalMode operationalMode;
    protected final UserAccessControl userAccessControl;
    protected final TextResource textResource;
    protected DialogCreator dialogCreator;
    private final PasswordManager passwordManager;
    private final GoToEnterPassword goToEnterPassword;

    @Inject
    protected SwitchToOperationalModeAction(OperationalMode operationalMode, UserAccessControl userAccessControl, TextResource textResource, DialogCreator dialogCreator, PasswordManager passwordManager, GoToEnterPassword goToEnterPassword) {
        this.operationalMode = operationalMode;
        this.userAccessControl = userAccessControl;
        this.textResource = textResource;
        this.dialogCreator = dialogCreator;
        this.passwordManager = passwordManager;
        this.goToEnterPassword = goToEnterPassword;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.userAccessControl.canSetOperationalMode(OperationalModeSource.UI) || this.userAccessControl.canSetOperationalMode(OperationalModeSource.SAFETY_UI)) {
            this.requestLogin(new SetOperationalModeOnLoginSuccess());
        } else {
            OperationalModeSource profileSource = this.userAccessControl.getCurrentOperationalModeSource();
            String description = this.getOperationalModeSourceDescription(profileSource);
            String message = this.textResource.UnableToChangeOperationalMode(description);
            this.dialogCreator.showErrorDialog(new ErrorMessage(this.textResource.operationalMode((Enum<OperationalMode>)this.operationalMode), message), null);
        }
    }

    private void requestLogin(PasswordLoginListener passwordLoginListener) {
        if (this.passwordManager.isPasswordDefined(PasswordManager.Lock.GENERAL)) {
            this.goToEnterPassword.requestPassword(PasswordManager.Lock.GENERAL, passwordLoginListener);
        } else {
            passwordLoginListener.onLoginSuccess();
        }
    }

    protected String getOperationalModeSourceDescription(OperationalModeSource source) {
        switch (source) {
            case NONE: {
                return this.textResource.OperationalModeSourceNone();
            }
            case UI: {
                return this.textResource.OperationalModeSourceUI();
            }
            case SAFETY_UI: {
                return this.textResource.OperationalModeSourceSafetyUI();
            }
            case DASHBOARD_SERVER: {
                return this.textResource.OperationalModeSourceDashboardServer();
            }
            case SAFETY_IO: {
                return this.textResource.OperationalModeSourceSafetyIO();
            }
            case SAFETY_PROFISAFE: {
                return this.textResource.OperationalModeSourceSafetyProfiSafe();
            }
        }
        return this.textResource.OperationalModeSourceUnknown();
    }

    OperationalMode getOperationalMode() {
        return this.operationalMode;
    }

    private final class SetOperationalModeOnLoginSuccess
    implements PasswordLoginListener {
        private SetOperationalModeOnLoginSuccess() {
        }

        public void onLoginSuccess() {
            SwitchToOperationalModeAction.this.userAccessControl.setOperationalMode(OperationalModeSource.UI, SwitchToOperationalModeAction.this.operationalMode);
            SwitchToOperationalModeAction.this.userAccessControl.setOperationalMode(OperationalModeSource.SAFETY_UI, SwitchToOperationalModeAction.this.operationalMode);
        }

        public void onLoginFailure() {
        }
    }
}

