/*
 * Decompiled with CFR 0.152.
 */
package com.ur.g5.polyscope;

import com.ur.g5.TextResource;
import com.ur.g5.polyscope.SwitchToAutomaticProfileAction;
import com.ur.g5.polyscope.SwitchToManualProfileAction;
import com.ur.g5.polyscope.SwitchToOperationalModeAction;
import com.ur.g5.util.MenuContributionActionDecorator;
import com.ur.polyscope.program.ProgramModeHolder;
import com.ur.polyscope.safety.remotecontrol.impl.ui.OperationalModeTooltip;
import com.ur.polyscope.safety.remotecontrol.impl.ui.RemoteControlProfileButtonManager;
import com.ur.polyscope.safety.remotecontrol.impl.ui.SetupRemoteControlListener;
import com.ur.polyscope.security.AccessControlStateListener;
import com.ur.polyscope.security.OperationalModeSource;
import com.ur.polyscope.security.PasswordManager;
import com.ur.polyscope.security.PasswordUpdateListener;
import com.ur.polyscope.security.PrivilegeRestriction;
import com.ur.polyscope.security.UserAccessControl;
import com.ur.polyscope.security.UserAccessState;
import com.ur.polyscope.security.accessmode.AccessMode;
import com.ur.polyscope.security.accessmode.AccessModeChangedListener;
import com.ur.polyscope.security.accessmode.AccessModeService;
import com.ur.swing.ActionDefinition;
import com.ur.swing.BindingRegistration;
import com.ur.swing.SwingUtil;
import com.ur.swing.TooltipFactory;
import com.ur.swing.WidgetFactory;
import com.ur.swing.extensible.Extension;
import com.ur.swing.extensible.MenuExtension;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.util.event.EventManager;
import com.ur.view.constants.dev.OperationalMode;
import com.ur.view.help.HelpLoader;
import gui.main.MainPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EnumMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuListener;

@Singleton
@Extension(value="HeaderMenu")
public class SwitchUserButtonFactory
implements MenuExtension,
PrivilegeRestriction {
    private final Provider<SwitchUserAction> switchUserActionProvider;
    private final WidgetFactory widgetFactory;
    private final MenuContributionActionDecorator menuContributionActionDecorator;
    private final MainPanel mainPanel;

    @Inject
    SwitchUserButtonFactory(Provider<SwitchUserAction> switchUserActionProvider, WidgetFactory factory, MenuContributionActionDecorator menuContributionActionDecorator, MainPanel mainPanel) {
        this.switchUserActionProvider = switchUserActionProvider;
        this.widgetFactory = factory;
        this.menuContributionActionDecorator = menuContributionActionDecorator;
        this.mainPanel = mainPanel;
    }

    public MenuExtension.MenuContribution create() {
        final SwitchUserAction switchUserAction = (SwitchUserAction)((Object)this.switchUserActionProvider.get());
        this.menuContributionActionDecorator.addFamilyMember((MenuExtension.OverlayAction)switchUserAction);
        return new MenuExtension.MenuContribution((MenuExtension.OverlayAction)switchUserAction){

            public JComponent createComponent(Action action) {
                Action decoratedAction = SwitchUserButtonFactory.this.menuContributionActionDecorator.applyRestrictions(action, SwitchUserButtonFactory.this);
                JButton button = SwitchUserButtonFactory.this.widgetFactory.createButton(decoratedAction);
                button.setPreferredSize(new Dimension(64, 64));
                switchUserAction.setPopupMenuComponent(button);
                return button;
            }
        };
    }

    public boolean isRestrictedIn(UserAccessState userAccessState) {
        return !this.mainPanel.getSwitchSupport().isAllCardStacksEmpty();
    }

    public static class SwitchUserAction
    extends MenuExtension.AbstractOverlayAction
    implements OperationalModeTooltip {
        private final Map<OperationalMode, SwitchToOperationalModeAction> operationalModeMap = new EnumMap<OperationalMode, SwitchToOperationalModeAction>(OperationalMode.class);
        private final TextResource textResource;
        private final EventManager eventManager;
        private final UserAccessControl userAccessControl;
        private final AccessModeService accessModeService;
        private final PasswordManager passwordManager;
        private final RemoteControlProfileButtonManager remoteControlProfileButtonManager;
        private final TooltipFactory tooltipFactory;
        private final JMenuItem automaticProfileItem;
        private final JMenuItem manualProfileItem;
        private JButton component;
        private BindingRegistration messageRegistration = BindingRegistration.NULL_REGISTRATION;

        @Inject
        SwitchUserAction(WidgetFactory widgetFactory, TextResource textResource, EventManager eventManager, UserAccessControl userAccessControl, AccessModeService accessModeService, SwitchToAutomaticProfileAction automaticProfileAction, SwitchToManualProfileAction manualProfileAction, PasswordManager passwordManager, RemoteControlProfileButtonManager remoteControlProfileButtonManager, TooltipFactory tooltipFactory) {
            this.textResource = textResource;
            this.eventManager = eventManager;
            this.userAccessControl = userAccessControl;
            this.accessModeService = accessModeService;
            this.passwordManager = passwordManager;
            this.remoteControlProfileButtonManager = remoteControlProfileButtonManager;
            this.tooltipFactory = tooltipFactory;
            this.operationalModeMap.put(OperationalMode.AUTOMATIC, automaticProfileAction);
            this.operationalModeMap.put(OperationalMode.MANUAL, manualProfileAction);
            this.automaticProfileItem = widgetFactory.createMenuButton((Action)automaticProfileAction);
            this.manualProfileItem = widgetFactory.createMenuButton((Action)manualProfileAction);
            manualProfileAction.addPropertyChangeListener(new UpdateIconPropertyChangeListener());
            automaticProfileAction.addPropertyChangeListener(new UpdateIconPropertyChangeListener());
            this.putValue("InternalName", "operationalMode.HeaderMenu");
            this.putValue("Function", ActionDefinition.Function.APPLICATION_HEADER);
        }

        void setPopupMenuComponent(JButton component) {
            this.component = component;
            final JPopupMenu popupMenu = new JPopupMenu();
            popupMenu.setName("operationalMode.HeaderMenu.popup");
            popupMenu.add(this.automaticProfileItem);
            popupMenu.add(this.manualProfileItem);
            popupMenu.addPopupMenuListener((PopupMenuListener)((Object)this));
            this.remoteControlProfileButtonManager.populate(popupMenu);
            popupMenu.pack();
            component.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (!this.isEnabled()) {
                        return;
                    }
                    if (popupMenu.isVisible()) {
                        popupMenu.setVisible(false);
                        return;
                    }
                    SwingUtil.invokeLater(() -> {
                        Component invoker = e.getComponent();
                        popupMenu.show(invoker, invoker.getWidth() - popupMenu2.getPreferredSize().width, invoker.getHeight());
                    });
                }
            });
            this.eventManager.addStrongListener(ProgramModeHolder.ProgramModeListener.class, (Object)new ProgramModeHolder.ProgramModeListener(){

                public void changedMode(ProgramModeHolder.ProgramMode newMode) {
                    if (newMode == ProgramModeHolder.ProgramMode.Calibration) {
                        this.setColor(G5LookAndFeel.HEADER_BACKGROUND);
                    } else {
                        this.setColor(G5LookAndFeel.SELECTED_HEADER_BACKGROUND);
                    }
                }

                private void setColor(Color color) {
                    for (Component component : popupMenu.getComponents()) {
                        if (!(component instanceof JMenuItem)) continue;
                        component.setBackground(color);
                    }
                    popupMenu.setBorder(BorderFactory.createLineBorder(color, 2));
                }
            });
            this.eventManager.addStrongListener(AccessControlStateListener.class, (Object)new HeaderAccessControlStateListener());
            this.eventManager.addStrongListener(PasswordUpdateListener.class, (Object)new PasswordChangedListener(this.passwordManager));
            this.eventManager.addStrongListener(AccessModeChangedListener.class, (Object)new HeaderControlModeChangedListener());
            this.eventManager.addStrongListener(SetupRemoteControlListener.class, (Object)new HeaderSetupRemoteControlListener());
            this.update(this.userAccessControl.getCurrentState(), this.accessModeService.getAccessMode());
        }

        public void actionPerformed(ActionEvent e) {
        }

        private void update(UserAccessState currentState, AccessMode accessMode) {
            this.updateComponent(currentState, accessMode);
            boolean hasOperationalModeSource = currentState.getOperationalModeSource() != OperationalModeSource.NONE;
            this.automaticProfileItem.setVisible(hasOperationalModeSource && AccessMode.isLocal((AccessMode)accessMode) && currentState.getOperationalMode() == OperationalMode.MANUAL);
            this.manualProfileItem.setVisible(hasOperationalModeSource && AccessMode.isLocal((AccessMode)accessMode) && currentState.getOperationalMode() == OperationalMode.AUTOMATIC);
            this.remoteControlProfileButtonManager.updateButtonsVisibility(accessMode);
        }

        private void updateComponent(UserAccessState currentState, AccessMode controlMode) {
            boolean hasOperationalModeSource = currentState.getOperationalModeSource() != OperationalModeSource.NONE;
            this.component.setVisible(this.shouldShowButton(hasOperationalModeSource, controlMode));
            if (hasOperationalModeSource && AccessMode.isLocal((AccessMode)controlMode)) {
                OperationalMode operationalMode = currentState.getOperationalMode();
                SwitchToOperationalModeAction action = this.operationalModeMap.get(operationalMode);
                Icon icon = (Icon)action.getValue("SwingLargeIconKey");
                String title = (String)action.getValue("Name");
                this.component.setIcon(icon);
                this.component.setText(title);
                this.putValue("HelpId", "gui:operational_modes");
                HelpLoader.updatePairInHelpMap((JComponent)this.component, (JComponent)this.component, (String)"gui:operational_modes");
            } else {
                this.remoteControlProfileButtonManager.update(this.component, controlMode);
                this.putValue("HelpId", "gui:enableremotecontrol.setuppanel");
                HelpLoader.updatePairInHelpMap((JComponent)this.component, (JComponent)this.component, (String)"gui:enableremotecontrol.setuppanel");
            }
        }

        private boolean shouldShowButton(boolean hasOperationalModeSource, AccessMode controlMode) {
            return hasOperationalModeSource || this.accessModeService.isRemoteControlFeatureEnabled() || AccessMode.isRemote((AccessMode)controlMode);
        }

        public void showTooltip(String message) {
            boolean componentEnabled = this.component.isEnabled();
            this.component.setEnabled(true);
            this.messageRegistration.removeRegistration();
            this.messageRegistration = this.tooltipFactory.showInformationTooltipCloseAnyClick((JComponent)this.component, message);
            this.component.setEnabled(componentEnabled);
        }

        private class UpdateIconPropertyChangeListener
        implements PropertyChangeListener {
            private UpdateIconPropertyChangeListener() {
            }

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String name = propertyChangeEvent.getPropertyName();
                if (name.equals("SwingLargeIconKey")) {
                    SwingUtil.invokeLater(() -> SwitchUserAction.this.update(SwitchUserAction.this.userAccessControl.getCurrentState(), SwitchUserAction.this.accessModeService.getAccessMode()));
                }
            }
        }

        private class HeaderSetupRemoteControlListener
        implements SetupRemoteControlListener {
            private HeaderSetupRemoteControlListener() {
            }

            public void remoteControlSetupChanged(boolean isFeatureEnabled) {
                SwingUtil.invokeLater(() -> SwitchUserAction.this.update(SwitchUserAction.this.userAccessControl.getCurrentState(), SwitchUserAction.this.accessModeService.getAccessMode()));
            }
        }

        private class HeaderControlModeChangedListener
        implements AccessModeChangedListener {
            private HeaderControlModeChangedListener() {
            }

            public void accessModeChanged(AccessMode accessMode) {
                SwingUtil.invokeLater(() -> SwitchUserAction.this.update(SwitchUserAction.this.userAccessControl.getCurrentState(), accessMode));
            }
        }

        private class PasswordChangedListener
        implements PasswordUpdateListener {
            private final PasswordManager passwordManager;

            PasswordChangedListener(PasswordManager passwordManager) {
                this.passwordManager = passwordManager;
            }

            public void onPasswordUpdate(PasswordManager.Lock lock) {
                if (lock == PasswordManager.Lock.GENERAL && this.passwordManager.isLocked(lock)) {
                    SwingUtil.invokeLater(() -> {
                        boolean componentEnabled = SwitchUserAction.this.component.isEnabled();
                        SwitchUserAction.this.component.setEnabled(true);
                        SwitchUserAction.this.component.setVisible(true);
                        SwitchUserAction.this.tooltipFactory.showTitledInformationTooltipCloseOnlyOnClick((JComponent)SwitchUserAction.this.component, SwitchUserAction.this.textResource.operationalModePasswordSet(), SwitchUserAction.this.textResource.howToSwitchProfileMode());
                        SwitchUserAction.this.component.setEnabled(componentEnabled);
                    });
                }
            }
        }

        private class HeaderAccessControlStateListener
        implements AccessControlStateListener {
            private HeaderAccessControlStateListener() {
            }

            public void accessControlStateChanged(UserAccessState oldState, UserAccessState currentState) {
                SwingUtil.invokeLater(() -> SwitchUserAction.this.update(currentState, SwitchUserAction.this.accessModeService.getAccessMode()));
            }
        }
    }
}

