/*
 * Decompiled with CFR 0.152.
 */
package com.ur.g5.polyscope;

import com.ur.program.edit.infrastructure.SidePanels;
import com.ur.swing.extensible.Extension;
import com.ur.swing.extensible.Layer;
import com.ur.swing.extensible.LayerExtension;
import gui.polyscope.program.ProgramPanel;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.JComponent;
import javax.swing.JLayer;
import javax.swing.plaf.LayerUI;

@Singleton
@Extension(value="ProgramPanel")
public class ToggleOverlay
extends LayerUI<JComponent>
implements LayerExtension {
    private final SidePanels sidePanels;

    @Inject
    public ToggleOverlay(ProgramPanel programPanel) {
        this.sidePanels = (SidePanels)programPanel.getSidePlaceholders();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        ((JLayer)c).setLayerEventMask(16L);
    }

    @Override
    public void uninstallUI(JComponent c) {
        ((JLayer)c).setLayerEventMask(0L);
        super.uninstallUI(c);
    }

    @Override
    protected void processMouseEvent(MouseEvent evt, JLayer layer) {
        if (evt.getID() == 500) {
            this.sidePanels.mouseClicked(evt);
        }
        if (evt.getID() == 501) {
            this.sidePanels.mousePressed(evt);
        }
        if (evt.getID() == 502) {
            this.sidePanels.mouseReleased(evt);
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        this.sidePanels.getLeftToggle().paintToggleIcon((Component)c, g);
        this.sidePanels.getRightToggle().paintToggleIcon((Component)c, g);
    }

    public Layer createLayer() {
        return component -> new JLayer<JComponent>(component, this);
    }
}

