/*
 * Decompiled with CFR 0.152.
 */
package com.ur.g5.polyscope;

import com.ur.g5.TextResource;
import com.ur.g5.polyscope.HeaderActionFactory;
import com.ur.g5.polyscope.WelcomeScreenExtension;
import com.ur.lang.persist.WriteableModuleSettings;
import com.ur.polyscope.initializerobot.veto.VetoListener;
import com.ur.polyscope.security.LockablePrivilegeLevel;
import com.ur.polyscope.security.LockableRestrictedPoint;
import com.ur.polyscope.security.Privileges;
import com.ur.polyscope.security.RestrictedPoint;
import com.ur.resources.ViewImageResource;
import com.ur.swing.AbstractActionDefinition;
import com.ur.swing.CardPanel;
import com.ur.swing.URFontFactory;
import com.ur.swing.ViewContext;
import com.ur.swing.extensible.MenuExtension;
import com.ur.swing.g5.DialogBorder;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.util.event.EventManager;
import com.ur.util.event.Subscription;
import com.ur.util.swing.HTML;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class WelcomeScreen
extends CardPanel {
    public static final String RUN_BUTTON = "run." + WelcomeScreen.class.getSimpleName();
    public static final String PROGRAM_BUTTON = "program." + WelcomeScreen.class.getSimpleName();
    public static final String WELCOME_SCREEN = "welcomeScreen." + WelcomeScreen.class.getSimpleName();
    private static final WriteableModuleSettings settings = new WriteableModuleSettings("welcome.properties");
    private final Set<WelcomeScreenExtension> options;
    private final ViewContext viewContext;
    private final EventManager eventManager;
    private final HeaderActionFactory factory;
    private final Privileges privileges;
    private final EnumMap<LockableRestrictedPoint, LockablePrivilegeLevel> privilegeRestrictionsMap = new EnumMap(LockableRestrictedPoint.class);
    private final ArrayList<Subscription> privilegeSubscriptions = new ArrayList();
    private final List<MenuExtension.MenuContribution> menuContributions = new ArrayList<MenuExtension.MenuContribution>();

    @Inject
    WelcomeScreen(Set<WelcomeScreenExtension> options, ViewContext viewContext, EventManager eventManager, HeaderActionFactory factory, Privileges privileges) {
        this.options = options;
        this.viewContext = viewContext;
        this.eventManager = eventManager;
        this.factory = factory;
        this.privileges = privileges;
    }

    public static boolean isShowWelcomeScreen() {
        return settings.properties().getBoolean("showWelcomeScreen", true);
    }

    public static void setShowWelcomeScreen(boolean value, boolean doSave) {
        settings.properties().setProperty("showWelcomeScreen", "" + value);
        if (doSave) {
            try {
                settings.write();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void enter(Object o) {
        super.enter(o);
        this.eventManager.fireEvent(VetoListener.class, listener -> listener.veto(WelcomeScreen.class, VetoListener.VetoType.ROBOTMODE_CHANGE_MESSAGES));
        for (WelcomeScreenExtension each : this.options) {
            this.menuContributions.add(each.create());
        }
        this.menuContributions.sort(Comparator.comparingInt(MenuExtension.MenuContribution::getPriority));
        this.addPrivilegeListeners();
        this.initComponents();
    }

    public Object exit() {
        this.eventManager.fireEvent(VetoListener.class, listener -> listener.cancelVeto(WelcomeScreen.class, VetoListener.VetoType.ROBOTMODE_CHANGE_MESSAGES));
        this.removePrivilegeListeners();
        return super.exit();
    }

    private void addPrivilegeListeners() {
        this.privilegeRestrictionsMap.put(LockableRestrictedPoint.INSTALLATION, LockablePrivilegeLevel.ALLOWED);
        this.privilegeSubscriptions.add(this.privileges.getPrivilege((RestrictedPoint)LockableRestrictedPoint.INSTALLATION).addLevelChangeListener((lockablePrivilegeLevel, newLockablePrivilegeLevel) -> {
            this.privilegeRestrictionsMap.put(LockableRestrictedPoint.INSTALLATION, (LockablePrivilegeLevel)newLockablePrivilegeLevel);
            this.skipWelcomeScreen();
        }));
        this.privilegeRestrictionsMap.put(LockableRestrictedPoint.EDIT_PROGRAM, LockablePrivilegeLevel.ALLOWED);
        this.privilegeSubscriptions.add(this.privileges.getPrivilege((RestrictedPoint)LockableRestrictedPoint.EDIT_PROGRAM).addLevelChangeListener((lockablePrivilegeLevel, newLockablePrivilegeLevel) -> {
            this.privilegeRestrictionsMap.put(LockableRestrictedPoint.EDIT_PROGRAM, (LockablePrivilegeLevel)newLockablePrivilegeLevel);
            this.skipWelcomeScreen();
        }));
    }

    private void removePrivilegeListeners() {
        this.privilegeSubscriptions.forEach(Subscription::dispose);
        this.privilegeSubscriptions.clear();
    }

    private void skipWelcomeScreen() {
        if (this.isWelcomeScreenSkippable()) {
            this.factory.createShowRunScreenAction().actionPerformed(null);
        }
    }

    private boolean isWelcomeScreenSkippable() {
        for (LockablePrivilegeLevel level : this.privilegeRestrictionsMap.values()) {
            if (level != LockablePrivilegeLevel.ALLOWED) continue;
            return false;
        }
        return true;
    }

    private void initComponents() {
        TextResource text = (TextResource)this.viewContext.getTextResource(TextResource.class);
        Font headerAndBold = this.viewContext.getFontFactory().getRelativeFont(URFontFactory.Style.BOLD, URFontFactory.Size.MAIN_HEADING_SIZE);
        JPanel buttonsPanel = new JPanel();
        JPanel runProgramButton = this.createPanelButton(text.runProgramAction(), ViewImageResource.welcomeIcon01(), this.factory.createShowRunScreenAction());
        JPanel programRobotButton = this.createPanelButton(text.programRobotAction(), ViewImageResource.welcomeIcon02(), this.factory.createShowProgramScreenAction());
        JLabel questionLabel = new JLabel(text.whatDoFirst());
        JCheckBox dontShowCheckbox = new JCheckBox((Action)((Object)new DontShowWelcomeScreen(text)));
        runProgramButton.getComponent(0).setName(RUN_BUTTON);
        programRobotButton.getComponent(0).setName(PROGRAM_BUTTON);
        questionLabel.setHorizontalAlignment(0);
        questionLabel.setFont(headerAndBold);
        questionLabel.setBorder(new EmptyBorder(70, 30, 0, 30));
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 2));
        buttonsPanel.add(Box.createHorizontalGlue());
        buttonsPanel.add(runProgramButton);
        buttonsPanel.add(Box.createRigidArea(new Dimension(40, 0)));
        buttonsPanel.add(programRobotButton);
        buttonsPanel.add(Box.createRigidArea(new Dimension(40, 0)));
        for (MenuExtension.MenuContribution each : this.menuContributions) {
            buttonsPanel.add(this.createPanelButton(each.contribution));
        }
        buttonsPanel.add(Box.createHorizontalGlue());
        dontShowCheckbox.setHorizontalAlignment(2);
        dontShowCheckbox.setBorder(new EmptyBorder(0, 25, 25, 0));
        this.setLayout(new BorderLayout());
        this.setBorder((Border)new DialogBorder(text.gettingStarted(), G5LookAndFeel.SELECTED_HEADER_BACKGROUND));
        this.add(questionLabel, "North");
        this.add(buttonsPanel, "Center");
        this.add(dontShowCheckbox, "South");
        this.setName(WELCOME_SCREEN);
    }

    private JPanel createPanelButton(Action showRunScreenAction) {
        return this.createPanelButton((String)showRunScreenAction.getValue("Name"), (Icon)showRunScreenAction.getValue("SmallIcon"), showRunScreenAction);
    }

    private JPanel createPanelButton(String text, Icon icon, final Action showRunScreenAction) {
        Font largeAndBold = this.viewContext.getFontFactory().getRelativeFont(URFontFactory.Style.BOLD, URFontFactory.Size.LARGE);
        JPanel result = new JPanel();
        JLabel iconLabel = new JLabel(icon);
        JLabel textLabel = new JLabel(HTML.html((String)HTML.center((String)text)));
        result.setLayout(new BoxLayout(result, 1));
        textLabel.setFont(largeAndBold);
        textLabel.setHorizontalAlignment(0);
        textLabel.setVerticalAlignment(1);
        textLabel.setHorizontalTextPosition(0);
        textLabel.setVerticalTextPosition(1);
        result.add(iconLabel);
        result.add(textLabel);
        MouseAdapter listener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (showRunScreenAction.isEnabled()) {
                    showRunScreenAction.actionPerformed(null);
                }
            }
        };
        result.addMouseListener(listener);
        iconLabel.addMouseListener(listener);
        textLabel.addMouseListener(listener);
        result.setBorder(new LineBorder(G5LookAndFeel.SELECTED_HEADER_BACKGROUND, 5));
        this.setDimensions(result, 350, 200);
        this.setDimensions(iconLabel, 340, 100);
        this.setDimensions(textLabel, 340, 100);
        return result;
    }

    private void setDimensions(JComponent result, int width, int height) {
        result.setPreferredSize(new Dimension(width, height));
        result.setMinimumSize(new Dimension(width, height));
        result.setMaximumSize(new Dimension(width, height));
    }

    private static class DontShowWelcomeScreen
    extends AbstractActionDefinition {
        public DontShowWelcomeScreen(TextResource text) {
            this.putValue("Name", text.dontShowThisDialogAgain());
        }

        public void actionPerformed(ActionEvent e) {
            WelcomeScreen.setShowWelcomeScreen(!((JCheckBox)e.getSource()).isSelected(), true);
        }
    }
}

