/*
 * Decompiled with CFR 0.152.
 */
package com.ur.g5.polyscope.programandinstallation.externalapi;

import com.ur.g5.polyscope.programandinstallation.externalapi.ProgramAndInstallation;
import com.ur.i18n.TextResource;
import com.ur.polyscope.installation.Installation;
import com.ur.polyscope.installation.InstallationStateListener;
import com.ur.polyscope.installation.PersistanceMetaData;
import com.ur.util.event.EventManager;
import gui.installation.RobotInstallationLookupService;
import gui.polyscope.DashBoard;
import gui.polyscope.SaveProgramService;
import javax.inject.Inject;

public class DisplayStrategy
implements ProgramAndInstallation {
    private static final String TRUNCATE_SUFFIX = "...";
    private static final String MODIFIED_SUFFIX = "*";
    private ProgramAndInstallation.UpdatableLabel activeProgram;
    private ProgramAndInstallation.UpdatableLabel activeInstallation;
    private final TextResource textResource;

    @Inject
    protected DisplayStrategy(EventManager eventManager, final RobotInstallationLookupService installationLookupService, SaveProgramService saveProgramService, TextResource textResource) {
        this.textResource = textResource;
        eventManager.addStrongListener(InstallationStateListener.class, (Object)new InstallationStateListener.Template(){

            public void installationModified() {
                DisplayStrategy.this.updateInstallation((PersistanceMetaData)installationLookupService.getInstallation().getMetaData(PersistanceMetaData.class), true);
            }

            public void installationSaved() {
                DisplayStrategy.this.updateInstallation((PersistanceMetaData)installationLookupService.getInstallation().getMetaData(PersistanceMetaData.class), false);
            }

            public void installationLoaded(Installation installation) {
                DisplayStrategy.this.updateInstallation((PersistanceMetaData)installationLookupService.getInstallation().getMetaData(PersistanceMetaData.class), false);
            }
        });
        saveProgramService.addChangeListener(e -> this.updateProgram(saveProgramService.hasChanges()));
    }

    private void updateInstallation(PersistanceMetaData fileName, boolean showModified) {
        if (this.activeInstallation == null) {
            return;
        }
        this.activeInstallation.update(this.truncate(fileName.fileName(), this.activeInstallation, showModified));
    }

    private void updateProgram(boolean showModified) {
        if (this.activeProgram == null) {
            return;
        }
        String name = DashBoard.getProgram() == null ? this.textResource.placeholderUnnamed() : DashBoard.getProgram().getName();
        this.activeProgram.update(this.truncate(name, this.activeProgram, showModified));
    }

    protected String truncate(String s, ProgramAndInstallation.UpdatableLabel updatableLabel, boolean isModified) {
        String truncateSuffix = TRUNCATE_SUFFIX + (isModified ? MODIFIED_SUFFIX : "");
        if (isModified && !s.endsWith(MODIFIED_SUFFIX)) {
            s = s + MODIFIED_SUFFIX;
        }
        while (updatableLabel.stringWidth(s) > updatableLabel.maxWidth()) {
            int symbolsToCut = s.endsWith(truncateSuffix) ? truncateSuffix.length() + 1 : truncateSuffix.length();
            String truncated = s.substring(0, s.length() - symbolsToCut) + truncateSuffix;
            if (truncated.length() < updatableLabel.minLength()) {
                return s;
            }
            s = truncated;
        }
        return s;
    }

    @Override
    public void bindProgram(ProgramAndInstallation.UpdatableLabel activeProgram) {
        this.activeProgram = activeProgram;
    }

    @Override
    public void bindInstallation(ProgramAndInstallation.UpdatableLabel activeInstallation) {
        this.activeInstallation = activeInstallation;
    }
}

