/*
 * Decompiled with CFR 0.152.
 */
package com.ur.g5.polyscope.programandinstallation.infrastructure;

import com.ur.g5.TextResource;
import com.ur.g5.filemanager.FileManagerButtonFactory;
import com.ur.g5.polyscope.programandinstallation.externalapi.ProgramAndInstallation;
import com.ur.polyscope.installation.PersistanceMetaData;
import com.ur.polyscope.program.ProgramModeHolder;
import com.ur.polyscope.viewfacade.security.PrivilegeChangeNotifier;
import com.ur.swing.SwingWidgetFactory;
import com.ur.swing.URFontFactory;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.swing.help.HelpIdAssigner;
import com.ur.util.event.EventManager;
import com.ur.util.swing.HTML;
import gui.installation.RobotInstallationLookupService;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.util.Enumeration;
import javax.inject.Inject;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ButtonUI;

public class ActiveProgramAndInstallationDisplay
extends JPanel
implements ProgramModeHolder.ProgramModeListener {
    public static final String PROGRAM_AND_INSTALLATION_DISPLAY = "programAndInstallationDisplay." + ActiveProgramAndInstallationDisplay.class;
    public static final String ACTIVE_PROGRAM_AND_INSTALLATION_TITLES = "activeProgramAndInstallationTitles." + ActiveProgramAndInstallationDisplay.class;
    public static final String ACTIVE_PROGRAM_AND_INSTALLATION_VALUES = "activeProgramAndInstallationValues." + ActiveProgramAndInstallationDisplay.class;
    public static final String ACTIVE_PROGRAM_AND_INSTALLATION_PANEL = "activeProgramAndInstallationPanel." + ActiveProgramAndInstallationDisplay.class;
    public static final String ACTIVE_PROGRAM_HEADER_LABEL = "activeProgramHeaderLabel." + ActiveProgramAndInstallationDisplay.class.getSimpleName();
    public static final String ACTIVE_INSTALLATION_HEADER_LABEL = "activeInstallationHeaderLabel." + ActiveProgramAndInstallationDisplay.class.getSimpleName();
    private static final Dimension MAXIMUM_SIZE = new Dimension(640, 64);
    private static final int MIN_NAME_LENGTH = 24;
    private static final int MAX_NAME_WIDTH = 292;
    private final WidgetFactory widgetFactory;
    private final PrivilegeChangeNotifier privilegeChangeNotifier;
    private final ButtonGroup buttonGroup = new NoneSelectedButtonGroup();
    private final JPanel titlesPanel;
    private final JPanel valuesPanel;
    private final JPanel titlesAndValuesPanel;
    private final JPanel buttonsPanel;

    @Inject
    public ActiveProgramAndInstallationDisplay(ProgramAndInstallation programAndInstallation, RobotInstallationLookupService installationLookupService, FileManagerButtonFactory fileManagerButtonFactory, ViewContext viewContext, TextResource textResource, EventManager eventManager, PrivilegeChangeNotifier privilegeChangeNotifier, HelpIdAssigner helpIdAssigner) {
        this.widgetFactory = viewContext.createWidgetFactory();
        this.privilegeChangeNotifier = privilegeChangeNotifier;
        this.setLayout(new BoxLayout(this, 0));
        this.setBackground(G5LookAndFeel.HEADER_BACKGROUND);
        this.setMaximumSize(MAXIMUM_SIZE);
        URFontFactory fontFactory = viewContext.getFontFactory();
        Font font = fontFactory.getRelativeFont(URFontFactory.Style.DEFAULT, URFontFactory.Size.SMALL);
        this.titlesPanel = new JPanel();
        this.titlesPanel.setBackground(G5LookAndFeel.HEADER_BACKGROUND);
        this.titlesPanel.setLayout(new BoxLayout(this.titlesPanel, 1));
        this.titlesPanel.setBorder(new EmptyBorder(10, 20, 10, 10));
        JLabel programLabel = this.widgetFactory.createLabel(textResource.PROGRAM());
        programLabel.setFont(font);
        programLabel.setForeground(Color.GRAY);
        programLabel.setAlignmentX(1.0f);
        programLabel.setHorizontalAlignment(4);
        JLabel installationLabel = this.widgetFactory.createLabel(textResource.INSTALLATION());
        installationLabel.setFont(font);
        installationLabel.setForeground(Color.GRAY);
        installationLabel.setAlignmentX(1.0f);
        installationLabel.setHorizontalAlignment(4);
        this.titlesPanel.add(Box.createVerticalGlue());
        this.titlesPanel.add(programLabel);
        this.titlesPanel.add(Box.createVerticalGlue());
        this.titlesPanel.add(installationLabel);
        this.titlesPanel.add(Box.createVerticalGlue());
        this.valuesPanel = new JPanel();
        this.valuesPanel.setBackground(G5LookAndFeel.HEADER_BACKGROUND);
        this.valuesPanel.setLayout(new BoxLayout(this.valuesPanel, 1));
        this.valuesPanel.setBorder(new EmptyBorder(10, 0, 10, 10));
        JLabel activeProgram = this.widgetFactory.createLabel(HTML.convertToHtml((String)((com.ur.i18n.TextResource)viewContext.getTextResource(com.ur.i18n.TextResource.class)).placeholderUnnamed()));
        activeProgram.setFont(font);
        activeProgram.setForeground(Color.WHITE);
        activeProgram.setAlignmentX(0.0f);
        activeProgram.setHorizontalAlignment(2);
        activeProgram.setName(ACTIVE_PROGRAM_HEADER_LABEL);
        JLabel activeInstallation = this.widgetFactory.createLabel(((PersistanceMetaData)installationLookupService.getInstallation().getMetaData(PersistanceMetaData.class)).fileName());
        activeInstallation.setFont(font);
        activeInstallation.setForeground(Color.WHITE);
        activeInstallation.setAlignmentX(0.0f);
        activeInstallation.setHorizontalAlignment(2);
        activeInstallation.setName(ACTIVE_INSTALLATION_HEADER_LABEL);
        this.valuesPanel.add(Box.createVerticalGlue());
        this.valuesPanel.add(activeProgram);
        this.valuesPanel.add(Box.createVerticalGlue());
        this.valuesPanel.add(activeInstallation);
        this.valuesPanel.add(Box.createVerticalGlue());
        programAndInstallation.bindProgram(new ProgramAndInstallation.UpdatableLabel.Template(activeProgram, 24, 292));
        programAndInstallation.bindInstallation(new ProgramAndInstallation.UpdatableLabel.Template(activeInstallation, 24, 292));
        this.titlesAndValuesPanel = new JPanel();
        this.titlesAndValuesPanel.setBackground(G5LookAndFeel.HEADER_BACKGROUND);
        this.titlesAndValuesPanel.setLayout(new BoxLayout(this.titlesAndValuesPanel, 0));
        this.titlesAndValuesPanel.add(this.titlesPanel);
        this.titlesAndValuesPanel.add(this.valuesPanel);
        this.add(this.titlesAndValuesPanel);
        this.buttonsPanel = new JPanel(new FlowLayout(0, 0, 0));
        this.buttonsPanel.setBackground(G5LookAndFeel.HEADER_BACKGROUND);
        this.buttonsPanel.setBorder(new EmptyBorder(0, 0, 0, 20));
        this.buttonsPanel.add(this.createButtonFunction(fileManagerButtonFactory.createNewButton()));
        this.buttonsPanel.add(this.createButtonFunction(fileManagerButtonFactory.createOpenButton()));
        this.buttonsPanel.add(this.createButtonFunction(fileManagerButtonFactory.createSaveButton()));
        this.add(this.buttonsPanel);
        this.setComponentNames();
        helpIdAssigner.assignHelpId((JComponent)this.valuesPanel, "gui:file_manager");
        eventManager.addStrongListener(ProgramModeHolder.ProgramModeListener.class, (Object)this);
    }

    public void setLayout(Color background, Color selected) {
        this.setBackground(background);
        this.titlesPanel.setBackground(background);
        this.valuesPanel.setBackground(background);
        this.titlesAndValuesPanel.setBackground(background);
        this.buttonsPanel.setBackground(background);
        this.setButtonsLayout(background, selected);
        this.revalidate();
    }

    private void setButtonsLayout(Color background, Color selected) {
        Enumeration<AbstractButton> buttonEnumeration = this.buttonGroup.getElements();
        while (buttonEnumeration.hasMoreElements()) {
            JToggleButton button = (JToggleButton)buttonEnumeration.nextElement();
            button.setBackground(background);
            button.setUI((ButtonUI)new SwingWidgetFactory.ToggleButtonLookAndFeelUI(button.getAction(), selected));
        }
    }

    private void setComponentNames() {
        this.setName(PROGRAM_AND_INSTALLATION_DISPLAY);
        this.titlesPanel.setName(ACTIVE_PROGRAM_AND_INSTALLATION_TITLES);
        this.valuesPanel.setName(ACTIVE_PROGRAM_AND_INSTALLATION_VALUES);
        this.titlesAndValuesPanel.setName(ACTIVE_PROGRAM_AND_INSTALLATION_PANEL);
    }

    private AbstractButton createButtonFunction(AbstractButton button) {
        AbstractButton buttonFunction = this.widgetFactory.createButtonFunction(button);
        buttonFunction.setPreferredSize(new Dimension(64, 64));
        this.buttonGroup.add(buttonFunction);
        return button;
    }

    public void changedMode(ProgramModeHolder.ProgramMode newMode) {
        if (newMode == ProgramModeHolder.ProgramMode.Calibration) {
            this.setLayout(G5LookAndFeel.SELECTED_HEADER_BACKGROUND, G5LookAndFeel.HEADER_BACKGROUND);
        } else {
            this.setLayout(G5LookAndFeel.HEADER_BACKGROUND, G5LookAndFeel.SELECTED_HEADER_BACKGROUND);
        }
        this.privilegeChangeNotifier.notifyPrivilegeChanged();
    }

    private class NoneSelectedButtonGroup
    extends ButtonGroup {
        private NoneSelectedButtonGroup() {
        }

        @Override
        public void setSelected(ButtonModel model, boolean selected) {
            if (selected) {
                super.setSelected(model, true);
            } else {
                this.clearSelection();
            }
        }
    }
}

