/*
 * Decompiled with CFR 0.152.
 */
package com.ur.g5.polyscope.programandinstallation.infrastructure;

import com.ur.g5.polyscope.programandinstallation.externalapi.SelectProgramAndInstallationPresenter;
import com.ur.g5.polyscope.programandinstallation.externalapi.SelectProgramAndInstallationView;
import com.ur.g5.polyscope.programandinstallation.externalapi.UIInstallation;
import com.ur.swing.CardPanel;
import com.ur.swing.baseview.BaseAccordionView;
import com.ur.view.Settings;
import java.awt.BorderLayout;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class SelectProgramAndInstallationPanel
extends CardPanel
implements SelectProgramAndInstallationView {
    private final SelectProgramAndInstallationPresenter presenter;
    private final Provider<ProgramNavigation> programNavigationProvider;
    private ProgramNavigation programNavigation;

    @Inject
    private SelectProgramAndInstallationPanel(SelectProgramAndInstallationPresenter presenter, Provider<ProgramNavigation> programNavigationProvider) {
        this.presenter = presenter;
        this.programNavigationProvider = programNavigationProvider;
        presenter.setView(this);
    }

    public void enter(Object o) {
        if (Settings.isRunningInDevelopmentMode()) {
            this.removeAll();
            this.initComponents();
        }
        this.presenter.enter();
    }

    private void initComponents() {
        this.programNavigation = (ProgramNavigation)this.programNavigationProvider.get();
        this.setLayout(new BorderLayout(5, 5));
    }

    @Override
    public void setInstallations(List<UIInstallation> installations) {
        this.programNavigation.setInstallations(installations);
    }

    private static class ProgramNavigation {
        final BaseAccordionView accordionView;

        @Inject
        private ProgramNavigation(BaseAccordionView baseAccordionView) {
            this.accordionView = baseAccordionView;
            this.accordionView.setLanguage(Settings.getLanguage());
        }

        public void setInstallations(Iterable<UIInstallation> installations) {
            for (UIInstallation each : installations) {
                this.accordionView.addSection(each.getName(), (JComponent)new JPanel());
            }
        }
    }
}

