/*
 * Decompiled with CFR 0.152.
 */
package com.ur.g5.runscreen;

import com.ur.g5.ControlsImageResource;
import com.ur.g5.TextResource;
import com.ur.g5.runscreen.OvalButton;
import com.ur.program.control.ProgramControlsListener;
import com.ur.swing.ViewContext;
import com.ur.swing.g5.CardBorder;
import gui.polyscope.DashBoard;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.LayoutManager;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.jdesktop.swingx.JXButton;
import org.jdesktop.swingx.JXPanel;

@Singleton
public class ControlButtonsPanel
extends JXPanel {
    private static final int ICON_SIZE = 120;
    private static final String PLAY_PAUSE_BUTTON_NAME = "bigPlayPauseButton";
    private static final String STOP_BUTTON_NAME = "bigStopButton";
    private final JXButton stopButton;
    private final JXButton playPauseButton;
    private final ImageIcon bigPlay = this.resizeIcon(ControlsImageResource.bigPlay());
    private final ImageIcon bigResume = this.resizeIcon(ControlsImageResource.bigResume());
    private final ImageIcon bigPause = this.resizeIcon(ControlsImageResource.bigPause());
    private final transient ProgramControlsListener programControlsListener;

    @Inject
    public ControlButtonsPanel(ViewContext viewContext, ProgramControlsListener programControlsListener) {
        this.programControlsListener = programControlsListener;
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.setBorder((Border)new CardBorder(((TextResource)viewContext.getTextResource(TextResource.class)).Control()));
        this.add(Box.createRigidArea(new Dimension(400, 50)));
        JXPanel buttonsPanel = new JXPanel();
        buttonsPanel.setLayout((LayoutManager)new BoxLayout((Container)buttonsPanel, 0));
        buttonsPanel.setAlignmentX(0.5f);
        this.playPauseButton = new OvalButton(this.bigPlay);
        this.playPauseButton.setName(PLAY_PAUSE_BUTTON_NAME);
        this.playPauseButton.setBorder((Border)new EmptyBorder(0, 0, 0, 0));
        this.playPauseButton.setFocusPainted(false);
        this.playPauseButton.addActionListener(e -> this.playProgram());
        ImageIcon bigStop = this.resizeIcon(ControlsImageResource.bigStop());
        this.stopButton = new OvalButton(bigStop);
        this.stopButton.setName(STOP_BUTTON_NAME);
        this.stopButton.setBorder((Border)new EmptyBorder(0, 0, 0, 0));
        this.stopButton.setFocusPainted(false);
        this.stopButton.addActionListener(e -> this.stopProgram());
        buttonsPanel.add((Component)this.playPauseButton);
        buttonsPanel.add(Box.createRigidArea(new Dimension(50, 1)));
        buttonsPanel.add((Component)this.stopButton);
        this.add((Component)buttonsPanel);
    }

    private ImageIcon resizeIcon(Icon icon) {
        Image imageIcon = ((ImageIcon)icon).getImage();
        Image newImage = imageIcon.getScaledInstance(120, 120, 4);
        return new ImageIcon(newImage);
    }

    protected void playProgram() {
        this.playPauseButton.setBackground(Color.WHITE);
        this.programControlsListener.playButtonPushed();
    }

    protected void stopProgram() {
        this.stopButton.setBackground(Color.WHITE);
        this.programControlsListener.stopButtonPushed();
    }

    public void setStateBlocked() {
        this.playPauseButton.setEnabled(false);
        this.stopButton.setEnabled(false);
    }

    public void setStatePrePlay() {
        this.playPauseButton.setEnabled(false);
    }

    public void setStateStopOnly() {
        this.playPauseButton.setEnabled(false);
        this.stopButton.setEnabled(true);
    }

    public void setStateStopped() {
        this.playPauseButton.setEnabled(DashBoard.canRunProgram());
        this.stopButton.setEnabled(false);
    }

    public void setStatePausePlaying() {
        this.playPauseButton.setEnabled(true);
        this.stopButton.setEnabled(true);
    }

    public void setViewStopped() {
        this.playPauseButton.setIcon((Icon)this.bigPlay);
    }

    public void setViewPaused() {
        this.playPauseButton.setIcon((Icon)this.bigResume);
    }

    public void setViewPlaying() {
        this.playPauseButton.setIcon((Icon)this.bigPause);
    }

    public JComponent getToolTipAnchorPoint() {
        return this.playPauseButton;
    }
}

