/*
 * Decompiled with CFR 0.152.
 */
package com.ur.g5.runscreen;

import com.ur.g5.polyscope.programandinstallation.externalapi.ProgramAndInstallation;
import com.ur.g5.runscreen.ControlButtonsPanel;
import com.ur.i18n.TextResource;
import com.ur.polyscope.program.ProgramStateListener;
import com.ur.polyscope.program.monitor.ProgramState;
import com.ur.program.edit.infrastructure.ProgramFilePersistence;
import com.ur.resources.ViewImageResource;
import com.ur.swing.ActionDefinition;
import com.ur.swing.CardPanel;
import com.ur.swing.ComponentView;
import com.ur.swing.URFontFactory;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.extensible.AddToView;
import com.ur.swing.extensible.ExtensionPoint;
import com.ur.swing.g5.CardBorder;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.swing.help.HelpIdAssigner;
import com.ur.util.event.EventNotificationService;
import com.ur.util.logging.Log;
import com.ur.util.swing.HTML;
import com.ur.view.variables.RunScreenVariablesView;
import gui.polyscope.DashBoard;
import gui.polyscope.RunPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

@Singleton
@ExtensionPoint(value="RunScreen")
public class RunPanelImpl
extends CardPanel
implements RunPanel,
ProgramStateListener,
AddToView,
ComponentView {
    public static final String LOAD_PROGRAM = "loadProgram.G5RunPanel";
    public static final String PROGRAM_LOADED = "programLoaded.G5RunPanel";
    private static final String PROGRAM_RUNNING = "programRunning.G5RunPanel";
    private static final String PROGRAM_PAUSED = "programPaused.G5RunPanel";
    private static final String PROGRAM_STOPPED = "programStopped.G5RunPanel";
    public static final String TIME_COUNTER_SECONDS = "timeCounterSeconds.G5RunPanel";
    public static final int MIN_PROGRAM_NAME_LENGTH = 18;
    private final ProgramFilePersistence programFilePersistence;
    private final ProgramAndInstallation programAndInstallation;
    private final ViewContext viewContext;
    private final HelpIdAssigner helpIdAssigner;
    private JPanel programBox;
    private JLabel programNameLabel;
    private JLabel statusLabel;
    private final JPanel controlPanel = new JPanel(new BorderLayout(5, 5));
    private JComponent footer = new JPanel(new FlowLayout(1, 0, 0));
    private JPanel statusBox;
    private final ControlButtonsPanel controlButtonsPanel;
    private final RunScreenVariablesView runScreenVariablesView;
    private final TextResource textResource;
    private final WidgetFactory widgetFactory;

    @Inject
    RunPanelImpl(ProgramFilePersistence programFilePersistence, ProgramAndInstallation programAndInstallation, ViewContext viewContext, ControlButtonsPanel controlButtonsPanel, RunScreenVariablesView runScreenVariablesView) {
        this.programFilePersistence = programFilePersistence;
        this.programAndInstallation = programAndInstallation;
        this.viewContext = viewContext;
        this.helpIdAssigner = viewContext.getHelpIdAssigner();
        this.controlButtonsPanel = controlButtonsPanel;
        this.runScreenVariablesView = runScreenVariablesView;
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.widgetFactory = viewContext.createWidgetFactory();
        this.initComponents();
        this.assignHelpIds();
    }

    private void assignHelpIds() {
        this.helpIdAssigner.assignHelpId((JComponent)this.programBox, "gui:runtab");
    }

    public void addComponent(JComponent component) {
        Log.debug((String)("Adding component " + component != null ? component.getName() : "NULL?"));
        this.statusBox.add(component);
    }

    public void setHeader(JComponent headerComponent) {
        Log.debug((String)("Setting header " + headerComponent.getName()));
        this.add(headerComponent, "North");
    }

    public void setFooter(JComponent footer) {
    }

    public void enter(Object o) {
        this.programAndInstallation.bindProgram(new ProgramAndInstallation.UpdatableLabel.Template(this.programNameLabel, 18, 380){

            @Override
            public void update(String value) {
                super.update(this.toHtml(value));
            }

            private String toHtml(String s) {
                return HTML.html((String)HTML.convertToHtml((String)s));
            }
        });
        this.footer.setVisible(true);
        EventNotificationService.register((Object)((Object)this), ProgramStateListener.class, (Object)((Object)this));
        this.runScreenVariablesView.enter(o);
        this.programStateWrite(DashBoard.getProgramState());
    }

    public Object exit() {
        this.runScreenVariablesView.exit();
        this.footer.setVisible(false);
        EventNotificationService.unregister((Object)((Object)this), ProgramStateListener.class);
        return null;
    }

    private void programStateWrite(ProgramState newState) {
        if (newState == ProgramState.PLAYING) {
            this.statusLabel.setText(HTML.html((String)HTML.h1((String)this.textResource.Running())));
            this.statusLabel.setForeground(G5LookAndFeel.RUN_GREEN_FOREGROUND);
            this.statusLabel.setName(PROGRAM_RUNNING);
        } else if (newState == ProgramState.PAUSED) {
            this.statusLabel.setText(HTML.html((String)HTML.h1((String)this.textResource.Paused())));
            this.statusLabel.setForeground(Color.BLACK);
            this.statusLabel.setName(PROGRAM_PAUSED);
        } else {
            this.statusLabel.setText(HTML.html((String)HTML.h1((String)this.textResource.Stopped())));
            this.statusLabel.setForeground(Color.BLACK);
            this.statusLabel.setName(PROGRAM_STOPPED);
        }
    }

    public void programStateChanged(ProgramState oldState, ProgramState newState) {
        this.programStateWrite(newState);
    }

    private void initComponents() {
        Log.debug((String)"Initialising components");
        URFontFactory fontFactory = this.viewContext.getFontFactory();
        Action action = this.programFilePersistence.createLoadProgramAction();
        action.putValue("Name", this.textResource.loadProgram());
        action.putValue("SmallIcon", ViewImageResource.gtkOpen());
        action.putValue("InternalName", LOAD_PROGRAM);
        action.putValue("Function", ActionDefinition.Function.PRIMARY);
        JPanel loadProgramPanel = new JPanel();
        loadProgramPanel.setLayout(new BoxLayout(loadProgramPanel, 0));
        JButton loadProgramButton = this.widgetFactory.createButton(action);
        loadProgramPanel.add(Box.createHorizontalGlue());
        loadProgramPanel.add(loadProgramButton);
        loadProgramPanel.add(Box.createHorizontalGlue());
        loadProgramPanel.setAlignmentX(0.0f);
        this.programNameLabel = this.widgetFactory.createLabel(HTML.convertToHtml((String)this.textResource.placeholderUnnamed()));
        this.programNameLabel.setFont(fontFactory.getRelativeFont(URFontFactory.Style.BOLD, URFontFactory.Size.LARGE));
        this.programNameLabel.setForeground(Color.BLACK);
        this.programNameLabel.setName(PROGRAM_LOADED);
        this.programNameLabel.setHorizontalAlignment(0);
        this.statusLabel = this.widgetFactory.createLabel("");
        this.programBox = new JPanel();
        this.programBox.setLayout(new BoxLayout(this.programBox, 1));
        this.programBox.setBorder((Border)new CardBorder(this.textResource.Program()));
        this.programBox.setPreferredSize(new Dimension(400, 350));
        this.programBox.setMinimumSize(new Dimension(400, 350));
        this.programBox.add(Box.createVerticalGlue());
        this.programBox.add(this.programNameLabel);
        this.programBox.add(Box.createVerticalGlue());
        this.programBox.add(loadProgramPanel);
        this.programBox.add(Box.createVerticalStrut(50));
        this.statusBox = new JPanel();
        this.statusBox.add(this.widgetFactory.createTitleValuePair(this.textResource.Status(), this.statusLabel));
        this.statusBox.setAlignmentX(0.0f);
        this.programBox.add(this.statusBox);
        this.programBox.add(Box.createVerticalGlue());
        this.footer.add((Component)((Object)this.controlButtonsPanel));
        this.footer.setPreferredSize(new Dimension(400, 250));
        this.footer.setMinimumSize(new Dimension(400, 250));
        this.controlPanel.setBackground(G5LookAndFeel.BETWEEN_CARD_COLOR);
        this.controlPanel.add((Component)this.programBox, "Center");
        this.controlPanel.add((Component)this.footer, "South");
        this.programStateWrite(ProgramState.STOPPED);
        this.setLayout(new BorderLayout(5, 5));
        this.setBorder(BorderFactory.createMatteBorder(5, 5, 5, 5, G5LookAndFeel.BETWEEN_CARD_COLOR));
        this.setBackground(G5LookAndFeel.BETWEEN_CARD_COLOR);
        JPanel filterPanel = this.createFilterPanel();
        JPanel variablesPanel = new JPanel();
        variablesPanel.setLayout(new BorderLayout());
        variablesPanel.add((Component)this.runScreenVariablesView, "Center");
        variablesPanel.add((Component)filterPanel, "South");
        this.add(this.controlPanel, "West");
        this.add(variablesPanel, "Center");
    }

    public JComponent getFooter() {
        return this.footer;
    }

    private JPanel createFilterPanel() {
        JPanel filterPanel = new JPanel();
        filterPanel.setLayout(new BorderLayout());
        filterPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        JCheckBox showWaypointVariables = this.widgetFactory.createCheckBox(this.textResource.ShowWaypoints());
        showWaypointVariables.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 5));
        JCheckBox showFavoriteVariables = this.widgetFactory.createCheckBox(this.textResource.ShowFavorite());
        showFavoriteVariables.addActionListener(actionEvent -> this.runScreenVariablesView.setShowOnlyFavorite(showFavoriteVariables.isSelected()));
        showFavoriteVariables.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 5));
        filterPanel.add((Component)showFavoriteVariables, "West");
        return filterPanel;
    }
}

