/*
 * Decompiled with CFR 0.152.
 */
package com.ur.g5.runscreen;

import com.ur.g5.TextResource;
import com.ur.g5.runscreen.RunScreenSettings;
import com.ur.swing.CardPanel;
import com.ur.swing.FormBuilder;
import com.ur.swing.ViewContext;
import com.ur.swing.g5.CardBorder;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.util.swing.HTML;
import java.awt.BorderLayout;
import javax.inject.Inject;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class SetupRunScreenTab
extends CardPanel {
    private final ViewContext viewContext;
    private final TextResource textResource;
    private final RunScreenSettings settings;
    private JCheckBox speedSliderCheckBox;

    @Inject
    SetupRunScreenTab(ViewContext viewContext, RunScreenSettings settings) {
        this.viewContext = viewContext;
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.settings = settings;
        this.initComponents();
    }

    public void enter(Object o) {
        super.enter(o);
        this.speedSliderCheckBox.setSelected(this.settings.isShowSpeedSliderOnRunscreenEnabled());
    }

    private void initComponents() {
        this.setBorder((Border)new CardBorder(this.textResource.speedSliderCardTitle()));
        this.setBackground(G5LookAndFeel.BETWEEN_CARD_COLOR);
        this.setLayout(new BorderLayout(5, 5));
        this.speedSliderCheckBox = new JCheckBox(HTML.html((String)this.textResource.speedSliderCheckBoxTitle()));
        this.speedSliderCheckBox.addActionListener(evt -> this.changeSpeedSliderEnablement(this.speedSliderCheckBox.isSelected()));
        this.add(this.viewContext.createFormBuilder().description(this.textResource.speedSliderDescription(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_ROWS, FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).end(3).component((JComponent)this.speedSliderCheckBox, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS, FormBuilder.PanelConstraints.INDENT}).end().getPanel(), "Center");
    }

    private void changeSpeedSliderEnablement(boolean enabled) {
        if (enabled != this.settings.isShowSpeedSliderOnRunscreenEnabled()) {
            this.settings.setShowSpeedSliderOnRunscreenEnabled(enabled);
        }
    }
}

