/*
 * Decompiled with CFR 0.152.
 */
package com.ur.g5.security;

import com.ur.move.freedrive.FreedriveModeAvailability;
import com.ur.move.speedslider.SpeedSliderMode;
import com.ur.polyscope.safety.remotecontrol.impl.ControlModePrivilegeRestriction;
import com.ur.polyscope.security.CompositePrivilegeRestriction;
import com.ur.polyscope.security.LockablePrivilegeLevel;
import com.ur.polyscope.security.LockableRestrictedPoint;
import com.ur.polyscope.security.PrivilegeRestriction;
import com.ur.polyscope.security.Privileges;
import com.ur.polyscope.security.RestrictedPoint;
import com.ur.security.Privilege;
import com.ur.security.PrivilegeImpl;
import javax.inject.Inject;

public class PrivilegesConfiguration {
    @Inject
    private PrivilegesConfiguration(Privileges privileges, ControlModePrivilegeRestriction controlModePrivilegeRestriction) {
        privileges.setPrivilege((RestrictedPoint)LockableRestrictedPoint.RUN_PROGRAM, this.createLockablePrivilege(new PrivilegeRestriction[]{controlModePrivilegeRestriction}));
        privileges.setPrivilege((RestrictedPoint)LockableRestrictedPoint.EDIT_PROGRAM, this.createLockablePrivilege(new PrivilegeRestriction[]{PrivilegeRestriction.RESTRICT_FOR_AUTOMATIC, controlModePrivilegeRestriction}));
        privileges.setPrivilege((RestrictedPoint)LockableRestrictedPoint.INSTALLATION, this.createLockablePrivilege(new PrivilegeRestriction[]{PrivilegeRestriction.RESTRICT_FOR_AUTOMATIC, controlModePrivilegeRestriction}));
        privileges.setPrivilege((RestrictedPoint)LockableRestrictedPoint.MOVE, this.createLockablePrivilege(new PrivilegeRestriction[]{PrivilegeRestriction.RESTRICT_FOR_AUTOMATIC_WHEN_STRICT, controlModePrivilegeRestriction}));
        privileges.setPrivilege((RestrictedPoint)LockableRestrictedPoint.EXPERT, this.createLockablePrivilege(new PrivilegeRestriction[]{PrivilegeRestriction.RESTRICT_FOR_AUTOMATIC, controlModePrivilegeRestriction}));
        privileges.setPrivilege((RestrictedPoint)LockableRestrictedPoint.SHUTDOWN, this.createLockablePrivilege(PrivilegeRestriction.NO_RESTRICTION));
        privileges.setPrivilege((RestrictedPoint)LockableRestrictedPoint.PASSWORD, this.createLockablePrivilege(PrivilegeRestriction.NO_RESTRICTION));
        privileges.setPrivilege((RestrictedPoint)LockableRestrictedPoint.TIME, this.createLockablePrivilege(PrivilegeRestriction.RESTRICT_FOR_AUTOMATIC));
        privileges.setPrivilege((RestrictedPoint)LockableRestrictedPoint.SOFTWARE_UPDATE, this.createLockablePrivilege(PrivilegeRestriction.RESTRICT_FOR_AUTOMATIC));
        privileges.setPrivilege((RestrictedPoint)LockableRestrictedPoint.NETWORK, this.createLockablePrivilege(PrivilegeRestriction.RESTRICT_FOR_AUTOMATIC));
        privileges.setPrivilege((RestrictedPoint)LockableRestrictedPoint.SETTINGS_EXTENSIONS, this.createLockablePrivilege(new PrivilegeRestriction[]{PrivilegeRestriction.RESTRICT_FOR_AUTOMATIC, controlModePrivilegeRestriction}));
        privileges.setPrivilege((RestrictedPoint)LockableRestrictedPoint.REPORT_EXPORT, this.createLockablePrivilege(PrivilegeRestriction.RESTRICT_FOR_AUTOMATIC));
        privileges.setPrivilege(FreedriveModeAvailability.POINT, this.createPrivilege(FreedriveModeAvailability.class, new PrivilegeRestriction[]{PrivilegeRestriction.RESTRICT_FOR_AUTOMATIC_WHEN_STRICT, controlModePrivilegeRestriction}));
        privileges.setPrivilege(SpeedSliderMode.POINT, this.createPrivilege(SpeedSliderMode.class, new PrivilegeRestriction[]{PrivilegeRestriction.RESTRICT_FOR_MANUAL_WHEN_STRICT, controlModePrivilegeRestriction}));
    }

    private Privilege<LockablePrivilegeLevel> createLockablePrivilege(PrivilegeRestriction ... restrictions) {
        return this.createPrivilege(LockablePrivilegeLevel.class, restrictions);
    }

    private <L extends Enum<L>> PrivilegeImpl<L> createPrivilege(Class<L> levelType, final PrivilegeRestriction ... restrictions) {
        return new PrivilegeImpl<L>(levelType){
            {
                super(x0);
                this.set(PrivilegeRestriction.class, new CompositePrivilegeRestriction(restrictions));
            }
        };
    }
}

