/*
 * Decompiled with CFR 0.152.
 */
package com.ur.g5.settingstab;

import com.ur.polyscope.security.LockablePrivilegeLevel;
import com.ur.polyscope.security.Privileges;
import com.ur.polyscope.security.RestrictedPoint;
import com.ur.resources.ViewImageResource;
import com.ur.swing.AbstractActionDefinition;
import com.ur.swing.extensible.Layer;
import com.ur.util.swing.EmptyIcon;
import com.ur.util.swing.LayeredIcon;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;

class SectionAction
extends AbstractActionDefinition {
    private final Privileges privileges;
    private final List<Layer> layers = new ArrayList<Layer>();
    private final Icon collapsedIcon = new LayeredIcon(ViewImageResource.menuCollapse(), new Icon[0]);
    private final LinkedHashMap<Action, RestrictedPoint<LockablePrivilegeLevel>> subActionRestrictedPoints = new LinkedHashMap();

    SectionAction(Privileges privileges, String title, String name) {
        this.privileges = privileges;
        this.init(title, name);
    }

    private void init(String title, String name) {
        this.putValue("Name", title);
        this.putValue("InternalName", name);
    }

    public void putValue(String key, Object newValue) {
        if ("SmallIcon".equals(key) && ViewImageResource.menuCollapse().equals(newValue)) {
            newValue = this.collapsedIcon;
        }
        super.putValue(key, newValue);
    }

    void decorateIcon(Layer layer) {
        this.decorateExpandIcon(layer);
        this.layers.add(layer);
    }

    private void decorateExpandIcon(Layer layer) {
        JLabel expandLabel = new JLabel(this.collapsedIcon);
        expandLabel.putClientProperty("InternalName", this.getValue("InternalName"));
        layer.decorate((JComponent)expandLabel);
    }

    public void actionPerformed(ActionEvent e) {
        for (Map.Entry<Action, RestrictedPoint<LockablePrivilegeLevel>> entry : this.subActionRestrictedPoints.entrySet()) {
            LockablePrivilegeLevel lockablePrivilegeLevel = LockablePrivilegeLevel.ALLOWED;
            RestrictedPoint<LockablePrivilegeLevel> restrictedPoint = entry.getValue();
            if (restrictedPoint != null) {
                lockablePrivilegeLevel = (LockablePrivilegeLevel)this.privileges.getPrivilege(restrictedPoint).getLevel();
            }
            if (lockablePrivilegeLevel != LockablePrivilegeLevel.ALLOWED) continue;
            entry.getKey().actionPerformed(e);
            return;
        }
    }

    void addSubAction(Action action, RestrictedPoint<LockablePrivilegeLevel> restrictedPoint) {
        this.subActionRestrictedPoints.put(action, restrictedPoint);
        this.applySubActionLayers(action);
    }

    private void applySubActionLayers(Action action) {
        Icon icon = (Icon)action.getValue("SmallIcon");
        if (icon == null) {
            icon = new EmptyIcon(16, 16);
        }
        JLabel label = new JLabel((Icon)new LayeredIcon(icon, new Icon[0]));
        label.putClientProperty("InternalName", action.getValue("InternalName"));
        for (Layer layer : this.layers) {
            layer.decorate((JComponent)label);
        }
        action.putValue("SmallIcon", label.getIcon());
    }

    Action[] getSubActions() {
        return this.subActionRestrictedPoints.keySet().toArray(new Action[0]);
    }
}

