/*
 * Decompiled with CFR 0.152.
 */
package com.ur.g5.settingstab;

import com.ur.g5.TextResource;
import com.ur.g5.runscreen.SetupRunScreenTab;
import com.ur.g5.settingstab.CardPanelLocator;
import com.ur.g5.settingstab.ExitSettingsTab;
import com.ur.g5.settingstab.SectionAction;
import com.ur.g5.setup.SetupActionFactoryImpl;
import com.ur.injection.Builder;
import com.ur.lang.react.Recipe;
import com.ur.monitor.Source;
import com.ur.polyscope.security.LockablePrivilegeLevel;
import com.ur.polyscope.security.LockableRestrictedPoint;
import com.ur.polyscope.security.Privileges;
import com.ur.polyscope.security.RestrictedPoint;
import com.ur.polyscope.security.UserAccessState;
import com.ur.polyscope.settings.SettingsPanel;
import com.ur.polyscope.settings.SettingsSectionName;
import com.ur.polyscope.settings.contribution.SetupContributionsProvider;
import com.ur.polyscope.settings.contribution.SetupView;
import com.ur.resources.ViewImageResource;
import com.ur.security.Privilege;
import com.ur.swing.ActionDefinition;
import com.ur.swing.CardPanel;
import com.ur.swing.CardPanelMappedContribution;
import com.ur.swing.FlipManager;
import com.ur.swing.ShowScreenAction;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.baseview.BaseAccordionView;
import com.ur.swing.extensible.AddLayer;
import com.ur.swing.extensible.ExtensionPoint;
import com.ur.swing.extensible.Layer;
import com.ur.swing.flippable.FlippablePanel;
import com.ur.swing.g5.DialogBorder;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.swing.help.HelpIdAssignerExt;
import com.ur.swing.platform.ActionPanelDefinition;
import com.ur.swing.platform.SetupSite;
import com.ur.util.event.Subscription;
import com.ur.view.Settings;
import com.ur.view.constants.dev.OperationalMode;
import com.ur.view.gui.ExtensionPointUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

@Singleton
@ExtensionPoint(value="Settings")
public class SettingsTab
extends SettingsPanel
implements SetupSite,
SetupView,
AddLayer {
    public static final String PREFERENCES_TAB_NAME = "PreferencesTab.G5SettingsTab";
    public static final String PASSWORD_TAB_NAME = "PassswordTab.G5SettingsTab";
    public static final String SYSTEM_TAB_NAME = "SystemTab.G5SettingsTab";
    public static final String SECURITY_TAB_NAME = "SecurityTab.G5SettingsTab";
    public static final String EXIT_BUTTON_G5_SETTINGS_TAB = "ExitButton.G5SettingsTab";
    private static final int THICK_LINE = UIManager.getInt("CardPanel.space");
    private final Builder builder;
    private final WidgetFactory widgetFactory;
    private final SetupActionFactoryImpl actionFactory;
    private final BaseAccordionView navigation;
    private final Privileges privileges;
    private final Set<CardPanelMappedContribution> contributionSet;
    private final SetupContributionsProvider contributionsProvider;
    private final FlippablePanel flipPanel;
    private final TextResource text;
    private final HelpIdAssignerExt helpIdAssigner;
    private final Recipe<UserAccessState> recipe;
    private SectionAction preferencesSectionAction;
    private AbstractButton preferencesSection;
    private SectionAction passwordSectionAction;
    private AbstractButton passwordSection;
    private SectionAction systemSectionAction;
    private AbstractButton systemSection;
    private SectionAction securitySectionAction;
    private AbstractButton securitySection;
    private Class<? extends CardPanel> unrestrictedCardPanel;
    private Subscription subscription;

    @Inject
    SettingsTab(Builder builder, ViewContext viewContext, Set<CardPanelMappedContribution> contributionSet, SetupContributionsProvider contributionsProvider, SetupActionFactoryImpl actionFactory, BaseAccordionView navigation, Privileges privileges, @Source(value=UserAccessState.class) Recipe<UserAccessState> recipe) {
        this.builder = builder;
        this.contributionSet = ExtensionPointUtil.reduce((String)"Settings", contributionSet);
        this.contributionsProvider = contributionsProvider;
        this.widgetFactory = viewContext.createWidgetFactory();
        this.text = (TextResource)viewContext.getTextResource(TextResource.class);
        this.actionFactory = actionFactory;
        this.navigation = navigation;
        this.privileges = privileges;
        this.helpIdAssigner = viewContext.getHelpIdAssigner();
        this.recipe = recipe;
        this.flipPanel = new FlippablePanel();
        this.flipPanel.setCardParent((CardPanel)this);
        navigation.setLanguage(Settings.getLanguage());
        this.initView();
        this.addCardPanels();
    }

    private void assignHelpId(AbstractButton button, String helpId) {
        if (helpId != null) {
            this.helpIdAssigner.assignHelpId((JComponent)button, helpId);
            this.helpIdAssigner.updateHelpId((JComponent)button, (JComponent)button, helpId);
        }
    }

    private void initView() {
        this.setLayout(new BorderLayout(THICK_LINE, THICK_LINE));
        this.setBackground(G5LookAndFeel.BETWEEN_CARD_COLOR);
        this.setBorder(new CompoundBorder((Border)new DialogBorder(this.text.installationTabSettings(), G5LookAndFeel.UNIVERSAL_ROBOTS_DARK_BLUE), BorderFactory.createMatteBorder(THICK_LINE, THICK_LINE, THICK_LINE, THICK_LINE, G5LookAndFeel.BETWEEN_CARD_COLOR)));
        this.add((Component)this.flipPanel, "Center");
    }

    public void setFlipManager(FlipManager flipManager) {
        super.setFlipManager(flipManager);
        this.actionFactory.setFlipManagers((FlipManager)this.flipPanel, flipManager);
        this.addNavigationSidebar();
    }

    private void addCardPanels() {
        this.flipPanel.addCardPanel((CardPanel)this.builder.get(SetupRunScreenTab.class));
        for (CardPanelMappedContribution each : this.contributionSet) {
            Map mappedContribution = each.mappedContribution();
            mappedContribution.keySet().forEach(eachPanel -> this.flipPanel.addCardPanel(eachPanel, (CardPanel)this.builder.get((Class)mappedContribution.get(eachPanel))));
        }
        this.flipPanel.getSwitchSupport().setCurrentCard((CardPanel)this.flipPanel.getComponent(0));
    }

    private void addNavigationSidebar() {
        this.preferencesSectionAction = new SectionAction(this.privileges, this.text.preferencesHeader(), PREFERENCES_TAB_NAME);
        this.preferencesSection = this.navigation.addSection((Action)((Object)this.preferencesSectionAction), this.preferencesSectionAction.getSubActions());
        this.passwordSectionAction = new SectionAction(this.privileges, this.text.passwordHeader(), PASSWORD_TAB_NAME);
        this.passwordSection = this.navigation.addSection((Action)((Object)this.passwordSectionAction), this.passwordSectionAction.getSubActions());
        this.systemSectionAction = new SectionAction(this.privileges, this.text.systemHeader(), SYSTEM_TAB_NAME);
        this.systemSection = this.navigation.addSection((Action)((Object)this.systemSectionAction), this.systemSectionAction.getSubActions());
        this.securitySectionAction = new SectionAction(this.privileges, this.text.securityHeader(), SECURITY_TAB_NAME);
        this.securitySection = this.navigation.addSection((Action)((Object)this.securitySectionAction), this.securitySectionAction.getSubActions());
        this.navigation.setBorder(BorderFactory.createEmptyBorder(THICK_LINE, THICK_LINE, THICK_LINE, THICK_LINE));
        JButton exitButton = this.widgetFactory.createButton(this.createExitAction());
        JPanel footer = new JPanel(new BorderLayout());
        footer.setBorder(BorderFactory.createEmptyBorder(THICK_LINE, THICK_LINE, THICK_LINE, THICK_LINE));
        footer.add((Component)exitButton, "Center");
        JPanel navigationContainer = new JPanel(new BorderLayout());
        navigationContainer.add((Component)this.navigation, "Center");
        navigationContainer.add((Component)footer, "South");
        this.add(navigationContainer, "West");
    }

    private Action createExitAction() {
        ExitSettingsTab exitAction = new ExitSettingsTab((FlipManager)this.flipPanel);
        exitAction.putValue("Name", this.text.Exit());
        exitAction.putValue("Function", ActionDefinition.Function.PRIMARY);
        exitAction.putValue("SmallIcon", ViewImageResource.blank1x24());
        return exitAction;
    }

    public void enter(Object o) {
        super.enter(o);
        this.contributionsProvider.registerPanelsOnce((SetupView)this);
        this.flipPanel.enterActiveChild(o);
        this.disposeSubscription();
        this.subscription = this.recipe.distinctUntilChanged().map(UserAccessState::getOperationalMode).executeOnUIThread().subscribe(operationalMode -> {
            if (operationalMode == OperationalMode.AUTOMATIC) {
                this.flipPanel.switchTo(this.flipPanel.getCurrentCard().getClass());
                this.navigation.resetNavigation();
            }
        });
    }

    public Object exit() {
        this.disposeSubscription();
        this.flipPanel.exitActiveChild();
        return super.exit();
    }

    private void disposeSubscription() {
        if (this.subscription != null) {
            this.subscription.dispose();
        }
        this.subscription = null;
    }

    public void addPanel(CardPanel cardPanel) {
        this.flipPanel.addCardPanel(cardPanel);
    }

    public void addActionForPanel(ActionPanelDefinition actionPanelDefinition) {
        this.contributionsProvider.registerPanelDefinition(actionPanelDefinition);
    }

    public void internalSwitchTo(Class<? extends CardPanel> settingsTabClass) {
        Privilege privilege = this.privileges.getPrivilege((RestrictedPoint)LockableRestrictedPoint.SETTINGS_EXTENSIONS);
        if (privilege.getLevel() != LockablePrivilegeLevel.ALLOWED && this.unrestrictedCardPanel != null) {
            settingsTabClass = this.unrestrictedCardPanel;
        }
        this.navigation.selectSection((FlipManager)this.flipPanel, (BaseAccordionView.ComponentRelation)new CardPanelLocator(settingsTabClass));
    }

    public void addPanelToView(ActionPanelDefinition definition) {
        CardPanel cardPanel = definition.getCardPanel();
        this.addPanel(cardPanel);
        SettingsSectionName sectionName = SettingsTab.getSettingsSectionName(cardPanel);
        LockableRestrictedPoint restrictedPoint = this.getRestrictedPoint(cardPanel);
        ShowScreenAction contributedAction = this.actionFactory.createContributedAction(definition);
        this.contributeSectionSubAction(sectionName, contributedAction, restrictedPoint);
        if (sectionName.equals((Object)SettingsSectionName.PREFERENCES) && restrictedPoint == LockableRestrictedPoint.NONE && this.unrestrictedCardPanel == null) {
            this.unrestrictedCardPanel = cardPanel.getClass();
            this.contributeSectionSubAction(SettingsSectionName.PREFERENCES, this.actionFactory.createSetupRunScreenAction(), LockableRestrictedPoint.EDIT_PROGRAM);
            this.navigation.selectSection((FlipManager)this.flipPanel, (BaseAccordionView.ComponentRelation)new CardPanelLocator(this.unrestrictedCardPanel));
        }
    }

    private LockableRestrictedPoint getRestrictedPoint(CardPanel cardPanel) {
        LockableRestrictedPoint result = (LockableRestrictedPoint)cardPanel.getClientProperty((Object)"securityId");
        return result == null ? LockableRestrictedPoint.SETTINGS_EXTENSIONS : result;
    }

    private static SettingsSectionName getSettingsSectionName(CardPanel cardPanel) {
        SettingsSectionName sectionName = (SettingsSectionName)cardPanel.getClientProperty((Object)"SettingsSectionName");
        return sectionName == null ? SettingsSectionName.SYSTEM : sectionName;
    }

    private void contributeSectionSubAction(SettingsSectionName sectionName, ShowScreenAction action, LockableRestrictedPoint restrictedPoint) {
        AbstractButton element = null;
        switch (sectionName) {
            case PREFERENCES: {
                element = this.navigation.addElementToSection(this.preferencesSection, (Action)action);
                this.preferencesSectionAction.addSubAction((Action)action, (RestrictedPoint<LockablePrivilegeLevel>)restrictedPoint);
                break;
            }
            case PASSWORD: {
                element = this.navigation.addElementToSection(this.passwordSection, (Action)action);
                this.passwordSectionAction.addSubAction((Action)action, (RestrictedPoint<LockablePrivilegeLevel>)restrictedPoint);
                break;
            }
            case SYSTEM: {
                element = this.navigation.addElementToSection(this.systemSection, (Action)action);
                this.systemSectionAction.addSubAction((Action)action, (RestrictedPoint<LockablePrivilegeLevel>)restrictedPoint);
                break;
            }
            case SECURITY: {
                element = this.navigation.addElementToSection(this.securitySection, (Action)action);
                this.securitySectionAction.addSubAction((Action)action, (RestrictedPoint<LockablePrivilegeLevel>)restrictedPoint);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown settings section name: " + sectionName);
            }
        }
        if (element != null) {
            this.assignHelpId(element, (String)action.getValue("HelpId"));
        }
    }

    public void addLayer(Layer layer) {
        this.preferencesSectionAction.decorateIcon(layer);
        this.passwordSectionAction.decorateIcon(layer);
        this.systemSectionAction.decorateIcon(layer);
        this.securitySectionAction.decorateIcon(layer);
    }
}

