/*
 * Decompiled with CFR 0.152.
 */
package com.ur.g5.setup;

import com.ur.g5.TextResource;
import com.ur.g5.settingstab.action.SetupRunScreenAction;
import com.ur.g5.setup.SetupActionFactory;
import com.ur.polyscope.security.LockActionCreator;
import com.ur.polyscope.security.LockableRestrictedPoint;
import com.ur.polyscope.security.Privileges;
import com.ur.polyscope.security.RestrictedPoint;
import com.ur.swing.FlipManager;
import com.ur.swing.InterceptableAction;
import com.ur.swing.ShowScreenAction;
import com.ur.swing.ShowScreenActionImpl;
import com.ur.swing.platform.ActionPanelDefinition;
import java.util.Locale;
import javax.inject.Inject;

public class SetupActionFactoryImpl
implements SetupActionFactory {
    private final TextResource textResource;
    private final Privileges privilegeSite;
    private final LockActionCreator actionForPrivilegeDecorator;
    protected FlipManager internal;
    private FlipManager external;

    @Inject
    public SetupActionFactoryImpl(Privileges privileges, LockActionCreator decorator, TextResource textResource) {
        this.textResource = textResource;
        this.privilegeSite = privileges;
        this.actionForPrivilegeDecorator = decorator;
    }

    @Override
    public void setFlipManagers(FlipManager internal, FlipManager external) {
        this.internal = internal;
        this.external = external;
    }

    @Override
    public ShowScreenAction createContributedAction(ActionPanelDefinition actionPanelDefinition) {
        Class<?> cardPanelClass = actionPanelDefinition.getCardPanel().getClass();
        boolean isExternal = Boolean.TRUE.equals(actionPanelDefinition.getCardPanel().getClientProperty((Object)"fullScreen"));
        ShowScreenActionImpl buttonAction = new ShowScreenActionImpl(cardPanelClass, isExternal ? this.external : this.internal, isExternal);
        buttonAction.putValue("Name", (Object)actionPanelDefinition.getTitle());
        buttonAction.putValue("InternalName", (Object)actionPanelDefinition.getActionName());
        buttonAction.putValue("HelpId", (Object)this.getHelpId(actionPanelDefinition));
        return (ShowScreenAction)this.actionForPrivilegeDecorator.lockWithPrivilege((InterceptableAction)buttonAction, this.privilegeSite.getPrivilege((RestrictedPoint)this.getRestrictionPoint(actionPanelDefinition)));
    }

    private LockableRestrictedPoint getRestrictionPoint(ActionPanelDefinition actionPanelDefinition) {
        Object securityIdValue = actionPanelDefinition.getCardPanel().getClientProperty((Object)"securityId");
        if (securityIdValue instanceof LockableRestrictedPoint) {
            return (LockableRestrictedPoint)securityIdValue;
        }
        return LockableRestrictedPoint.SETTINGS_EXTENSIONS;
    }

    private String getHelpId(ActionPanelDefinition actionPanelDefinition) {
        if (actionPanelDefinition.getCardPanel().getClientProperty((Object)"helpId") instanceof String) {
            return (String)actionPanelDefinition.getCardPanel().getClientProperty((Object)"helpId");
        }
        return "gui:" + actionPanelDefinition.getActionName().toLowerCase(Locale.ENGLISH);
    }

    public ShowScreenAction createSetupRunScreenAction() {
        SetupRunScreenAction action = new SetupRunScreenAction(this.internal, this.textResource);
        return (ShowScreenAction)this.actionForPrivilegeDecorator.lockWithPrivilege((InterceptableAction)action, this.privilegeSite.getPrivilege((RestrictedPoint)LockableRestrictedPoint.EDIT_PROGRAM));
    }
}

