/*
 * Decompiled with CFR 0.152.
 */
package com.ur.g5.util;

import com.ur.g5.util.KeyEventsSuppressor;
import com.ur.injection.Builder;
import com.ur.polyscope.security.CompositePrivilegeRestriction;
import com.ur.polyscope.security.LockActionCreator;
import com.ur.polyscope.security.LockablePrivilegeLevel;
import com.ur.polyscope.security.PrivilegeRestriction;
import com.ur.polyscope.security.Privileges;
import com.ur.polyscope.security.RestrictedPoint;
import com.ur.polyscope.security.UserAccessState;
import com.ur.polyscope.viewfacade.security.PrivilegeChangeNotifier;
import com.ur.security.Privilege;
import com.ur.security.PrivilegeImpl;
import com.ur.swing.FlipManager;
import com.ur.swing.InterceptableAction;
import com.ur.swing.extensible.MenuExtension;
import gui.main.MainPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;

@Singleton
public class MenuContributionActionDecorator {
    private final Set<MenuExtension.OverlayAction> interceptedActions = new HashSet<MenuExtension.OverlayAction>();
    private final List<MenuExtension.OverlayAction> familyActionList = new ArrayList<MenuExtension.OverlayAction>();
    private final Privileges privileges;
    private final LockActionCreator actionForPrivilegeDecorator;
    private final Builder builder;
    private final PrivilegeChangeNotifier privilegeChangeNotifier;

    @Inject
    public MenuContributionActionDecorator(Privileges privileges, LockActionCreator actionForPrivilegeDecorator, Builder builder, PrivilegeChangeNotifier privilegeChangeNotifier) {
        this.privileges = privileges;
        this.actionForPrivilegeDecorator = actionForPrivilegeDecorator;
        this.builder = builder;
        this.privilegeChangeNotifier = privilegeChangeNotifier;
    }

    public void addToGrid(JPanel menuPanel, Collection<MenuExtension.MenuContribution> menuContributions) {
        this.addToGrid(menuPanel, menuContributions, userAccessState -> false);
    }

    private void addToGrid(JPanel menuPanel, Collection<MenuExtension.MenuContribution> menuContributions, PrivilegeRestriction restriction) {
        for (MenuExtension.MenuContribution menuContribution : menuContributions) {
            this.addToGrid(menuPanel, menuContribution, restriction);
        }
    }

    public void addToGrid(JPanel menuPanel, MenuExtension.MenuContribution menuContribution, PrivilegeRestriction restriction) {
        if (!(menuPanel.getLayout() instanceof GridBagLayout)) {
            throw new IllegalArgumentException("Menu buttons holder should have grid bag layout");
        }
        JComponent decoratedComponent = this.createMenuComponent(menuContribution, restriction);
        this.addToGrid(menuPanel, menuContribution.getPriority(), decoratedComponent);
    }

    public JComponent createMenuComponent(MenuExtension.MenuContribution menuContribution, PrivilegeRestriction restriction) {
        Action action = this.createActionWithRestrictions(menuContribution, restriction);
        JComponent menuComponent = menuContribution.createComponent(action);
        menuComponent.addKeyListener(new KeyEventsSuppressor());
        return menuComponent;
    }

    private void addToGrid(JPanel menuPanel, int priority, JComponent decoratedComponent) {
        GridBagConstraints constraints = new GridBagConstraints(priority, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0);
        menuPanel.add((Component)decoratedComponent, constraints);
    }

    private Action createActionWithRestrictions(MenuExtension.MenuContribution menuContribution, PrivilegeRestriction restriction) {
        Action menuAction = menuContribution.contribution;
        return this.applyRestrictions(menuAction, restriction);
    }

    public Action applyRestrictions(Action menuAction, PrivilegeRestriction restriction) {
        if (menuAction instanceof MenuExtension.OverlayAction) {
            return this.applyOverlayRestrictions((MenuExtension.OverlayAction)menuAction, restriction);
        }
        if (menuAction instanceof InterceptableAction) {
            WrappedAction wrappedAction = new WrappedAction((InterceptableAction)menuAction);
            this.applyInterceptableRestrictions((InterceptableAction)wrappedAction, new PrivilegeRestriction[]{restriction});
        }
        return menuAction;
    }

    private Action applyOverlayRestrictions(MenuExtension.OverlayAction action, PrivilegeRestriction restriction) {
        InterceptedOverlayAction interceptedOverlayAction = this.wrapOverlayAction(action);
        OverlayPrivilegeRestriction overlayRestriction = new OverlayPrivilegeRestriction(interceptedOverlayAction);
        PrivilegeRestriction[] restrictions = new PrivilegeRestriction[]{restriction, overlayRestriction};
        return this.applyInterceptableRestrictions((InterceptableAction)interceptedOverlayAction, restrictions);
    }

    private Action applyInterceptableRestrictions(final InterceptableAction action, PrivilegeRestriction[] restrictions) {
        if (restrictions.length == 0) {
            return action;
        }
        CompositePrivilegeRestriction compositeRestriction = new CompositePrivilegeRestriction(restrictions);
        Privilege<LockablePrivilegeLevel> privilege = MenuContributionActionDecorator.createLockablePrivilege((PrivilegeRestriction)compositeRestriction);
        this.privileges.setPrivilege((RestrictedPoint)new RestrictedPoint<LockablePrivilegeLevel>(){

            public String name() {
                return MenuContributionActionDecorator.this.getActionName((Action)action);
            }

            public Class<LockablePrivilegeLevel> getLevelType() {
                return LockablePrivilegeLevel.class;
            }
        }, privilege);
        return this.actionForPrivilegeDecorator.lockWithPrivilege(action, privilege);
    }

    String getActionName(Action action) {
        while (action instanceof WrappedAction) {
            action = ((WrappedAction)((Object)action)).originalAction;
        }
        if (action instanceof InterceptedOverlayAction) {
            action = ((InterceptedOverlayAction)((Object)action)).overlayAction;
        }
        return action.getClass().getName() + "@" + Integer.toHexString(action.hashCode());
    }

    private InterceptedOverlayAction wrapOverlayAction(MenuExtension.OverlayAction action) {
        FlipManager flipManager = (FlipManager)this.builder.get(MainPanel.class);
        return new InterceptedOverlayAction(action, flipManager);
    }

    private static Privilege<LockablePrivilegeLevel> createLockablePrivilege(PrivilegeRestriction restriction) {
        return new LockablePrivilegeRestriction(restriction);
    }

    public void addFamilyMember(MenuExtension.OverlayAction action) {
        this.familyActionList.add(action);
    }

    private class InterceptedOverlayAction
    extends InterceptableAction.Default
    implements PropertyChangeListener {
        private final MenuExtension.OverlayAction overlayAction;
        private final FlipManager flipManager;

        InterceptedOverlayAction(MenuExtension.OverlayAction overlayAction, FlipManager flipManager) {
            this.overlayAction = overlayAction;
            this.flipManager = flipManager;
            this.copyPropertiesFrom(overlayAction);
            overlayAction.addPropertyChangeListener(e -> this.putValue(e.getPropertyName(), e.getNewValue()));
            overlayAction.addPropertyChangeListener((PropertyChangeListener)this);
        }

        private void copyPropertiesFrom(MenuExtension.OverlayAction action) {
            Object[] keys = action.getKeys();
            if (keys != null) {
                for (Object o : keys) {
                    String key = (String)o;
                    this.putValue(key, action.getValue(key));
                }
            }
        }

        public void doActionPerformed(ActionEvent e) {
            this.overlayAction.actionPerformed(e);
        }

        public void doSetEnabled(boolean enabled) {
            super.doSetEnabled(enabled);
            this.overlayAction.setEnabled(enabled);
        }

        public FlipManager getFlipManager() {
            return this.flipManager;
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if ("overlayEnabled".equals(e.getPropertyName())) {
                MenuContributionActionDecorator.this.privilegeChangeNotifier.notifyPrivilegeChanged();
            }
        }
    }

    private class WrappedAction
    extends InterceptableAction.Default {
        private final InterceptableAction.Default originalAction;

        WrappedAction(InterceptableAction originalAction) {
            if (!(originalAction instanceof InterceptableAction.Default)) {
                throw new IllegalStateException(originalAction.getClass().getName() + " must extend " + InterceptableAction.Default.class.getName());
            }
            this.originalAction = (InterceptableAction.Default)originalAction;
            this.copyPropertiesFrom(this.originalAction);
            originalAction.addPropertyChangeListener(e -> this.putValue(e.getPropertyName(), e.getNewValue()));
        }

        private void copyPropertiesFrom(InterceptableAction.Default action) {
            Object[] keys = action.getKeys();
            if (keys != null) {
                for (Object o : keys) {
                    String key = (String)o;
                    this.putValue(key, action.getValue(key));
                }
            }
        }

        public void doActionPerformed(ActionEvent e) {
            this.originalAction.actionPerformed(e);
        }

        public void doSetEnabled(boolean enabled) {
            this.originalAction.setEnabled(enabled);
        }

        public FlipManager getFlipManager() {
            return this.originalAction.getFlipManager();
        }
    }

    private class OverlayPrivilegeRestriction
    implements PrivilegeRestriction {
        private MenuExtension.OverlayAction currentAction;

        OverlayPrivilegeRestriction(InterceptedOverlayAction interceptedOverlayAction) {
            this.currentAction = interceptedOverlayAction.overlayAction;
            MenuContributionActionDecorator.this.interceptedActions.add(this.currentAction);
        }

        public boolean isRestrictedIn(UserAccessState userAccessState) {
            for (MenuExtension.OverlayAction action : MenuContributionActionDecorator.this.interceptedActions) {
                if (action == this.currentAction || !this.isRestricted(action)) continue;
                return true;
            }
            return false;
        }

        private boolean isRestricted(MenuExtension.OverlayAction overlayAction) {
            if (MenuContributionActionDecorator.this.familyActionList.contains(this.currentAction)) {
                for (MenuExtension.OverlayAction familyAction : MenuContributionActionDecorator.this.familyActionList) {
                    if (!familyAction.isOverlayEnabled()) continue;
                    return false;
                }
            }
            return overlayAction.isOverlayEnabled() && overlayAction.isRestrictive();
        }
    }

    static class LockablePrivilegeRestriction
    extends PrivilegeImpl<LockablePrivilegeLevel> {
        LockablePrivilegeRestriction(PrivilegeRestriction restriction) {
            super(LockablePrivilegeLevel.class);
            this.initRestriction(restriction);
        }

        private void initRestriction(PrivilegeRestriction restriction) {
            this.set(PrivilegeRestriction.class, restriction);
        }
    }
}

