/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.version.internal;

import com.ur.dashboardserver.DashBoardAction;
import com.ur.dashboardserver.ReadOnlyDashboardAction;
import com.ur.polyscope.version.urversion.URVersion;
import com.ur.polyscope.version.urversion.URVersionProvider;
import java.text.SimpleDateFormat;
import javax.inject.Inject;

@ReadOnlyDashboardAction
public class QueryPolyscopeVersion
extends DashBoardAction.Base {
    private final URVersionProvider urVersionProvider;

    @Inject
    public QueryPolyscopeVersion(URVersionProvider urVersionProvider) {
        super("polyscopeversion");
        this.urVersionProvider = urVersionProvider;
    }

    public String execute(String input) {
        return "URSoftware " + this.getMarketingVersionWithoutTags() + "." + this.getBuildNumber() + " (" + this.getBuildDate() + ")";
    }

    private String getBuildNumber() {
        URVersion version = this.urVersionProvider.getBaselineVersion();
        return String.valueOf(version.getMajorVersion()) + version.getMinorVersion() + version.getPatchVersion();
    }

    private String getBuildDate() {
        if (null != this.urVersionProvider.getBuildDate()) {
            return new SimpleDateFormat("MMM dd yyyy").format(this.urVersionProvider.getBuildDate());
        }
        return "No Info";
    }

    private String getMarketingVersionWithoutTags() {
        URVersion marketingVersion = this.urVersionProvider.getMarketingVersion();
        return marketingVersion.getMajorVersion() + "." + marketingVersion.getMinorVersion() + "." + marketingVersion.getPatchVersion();
    }
}

