/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.version.internal;

import com.ur.polyscope.version.urversion.URVersion;
import com.ur.polyscope.version.urversion.URVersionProvider;
import com.ur.util.logging.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class URVersionProviderMetadata
implements URVersionProvider {
    private static final Pattern BUILD_DATE_VERSION_PATTERN = Pattern.compile(".*#buildDate> \"([^\"]*)\"");
    private static final Pattern MARKETING_VERSION_PATTERN = Pattern.compile(".*#marketingVersion> \"([^\"]*)\"");
    private static final Pattern BUILD_NUMBER_PATTERN = Pattern.compile(".*#buildNumber> \"([^\"]*)\"");
    private static final Pattern FIRMWARE_VERSION_PATTERN = Pattern.compile(".*firmware = ([^\"].*)");
    private static final Pattern POLYSCOPE_VERSION_PATTERN = Pattern.compile(".*ur-polyscope-platform-g5 = ([^\"].*)");
    private static final Pattern CONTROLLER_VERSION_PATTERN = Pattern.compile(".*urcontrol-g5 = ([^\"].*)");
    private final StringBuilder contents = new StringBuilder();

    URVersionProviderMetadata() {
        File metadataFile = new File(this.getHomeDirectory(), "metadata.n3");
        try {
            if (metadataFile.exists()) {
                this.loadData(new FileReader(metadataFile));
            }
        }
        catch (IOException e) {
            Log.error((String)"Cannot load data from metadata.n3 file", (Throwable)e);
        }
    }

    protected File getHomeDirectory() {
        return new File(System.getProperty("user.home"));
    }

    private void loadData(Reader source) throws IOException {
        BufferedReader reader = new BufferedReader(source);
        while (reader.ready()) {
            this.contents.append(reader.readLine());
            this.contents.append('\n');
        }
        reader.close();
    }

    public URVersion getMarketingVersion() {
        return this.getVersionForPattern(MARKETING_VERSION_PATTERN);
    }

    public Date getBuildDate() {
        Matcher matcher = BUILD_DATE_VERSION_PATTERN.matcher(this.contents);
        if (matcher.find()) {
            String iso8601Date = matcher.group(1);
            try {
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
                return formatter.parse(iso8601Date);
            }
            catch (ParseException e) {
                Log.warning((String)("Cannot parse build date: " + iso8601Date), (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public String getMarketingVersionName() {
        return "";
    }

    public URVersion getPolyscopeVersion() {
        return this.getVersionForPattern(POLYSCOPE_VERSION_PATTERN);
    }

    public URVersion getControllerVersion() {
        return this.getVersionForPattern(CONTROLLER_VERSION_PATTERN);
    }

    public URVersion getFirmwareVersion() {
        return this.getVersionForPattern(FIRMWARE_VERSION_PATTERN);
    }

    public URVersion getPlatformVersion() {
        return new URVersion(0, 1, 1);
    }

    public URVersion getBaselineVersion() {
        return this.getVersionForPattern(BUILD_NUMBER_PATTERN);
    }

    private URVersion getVersionForPattern(Pattern pattern) {
        try {
            Matcher marketingMatcher = pattern.matcher(this.contents);
            if (marketingMatcher.find()) {
                String marketingVersion = marketingMatcher.group(1);
                String[] split = marketingVersion.split("\\.");
                if (split.length > 3 && this.isNotANumber(split[3])) {
                    return new URVersion(Integer.parseInt(split[0]), Integer.parseInt(split[1]), Integer.parseInt(split[2]), split[3]);
                }
                return new URVersion(Integer.parseInt(split[0]), Integer.parseInt(split[1]), Integer.parseInt(split[2]));
            }
        }
        catch (Exception e) {
            Log.error((String)"Unable to extract version from file", (Throwable)e);
        }
        return URVersion.NULL_VERSION;
    }

    private boolean isNotANumber(String potentialNumber) {
        return !potentialNumber.matches("-?(0|[1-9]\\d*)");
    }
}

