/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.version.internal.view;

import com.ur.polyscope.version.internal.i18n.TextResource;
import com.ur.polyscope.version.urversion.URVersionProvider;
import com.ur.swing.SwingUtil;
import com.ur.swing.adapters.AncestorListenerAdapter;
import com.ur.swing.extensible.Extension;
import com.ur.swing.extensible.VerticalPlacementExtension;
import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.inject.Inject;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.jdesktop.swingx.JXLabel;

@Extension(value="AboutInfo")
public class URMarketingBuildDatePanel
implements VerticalPlacementExtension {
    private JXLabel versionInfo = new JXLabel();

    @Inject
    public URMarketingBuildDatePanel(TextResource textResource, final URVersionProvider urVersionProvider) {
        this.versionInfo.setLineWrap(true);
        this.versionInfo.putClientProperty((Object)"title", (Object)textResource.urMarketingbuilddate());
        this.versionInfo.addAncestorListener((AncestorListener)new AncestorListenerAdapter(){

            public void ancestorAdded(AncestorEvent event) {
                SwingUtil.invokeLater(() -> {
                    URMarketingBuildDatePanel.this.versionInfo.setText(URMarketingBuildDatePanel.this.decideTextToDisplay(urVersionProvider));
                    URMarketingBuildDatePanel.this.versionInfo.repaint();
                    URMarketingBuildDatePanel.this.versionInfo.revalidate();
                });
            }
        });
    }

    private String decideTextToDisplay(URVersionProvider urVersionProvider) {
        if (!urVersionProvider.getMarketingVersionName().equals("No info available") && null != urVersionProvider.getBuildDate()) {
            return this.formatDateToString(urVersionProvider.getBuildDate()) + " " + urVersionProvider.getMarketingVersionName();
        }
        return urVersionProvider.getMarketingVersionName();
    }

    public VerticalPlacementExtension.PlacementContribution create() {
        return VerticalPlacementExtension.PlacementContribution.locateAfter((int)2, (VerticalPlacementExtension.PlacementContribution)new VerticalPlacementExtension.PlacementContribution((Component)this.versionInfo));
    }

    private String formatDateToString(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMMMM dd yyyy");
        return dateFormat.format(date);
    }
}

