/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.version.internal.view;

import com.ur.polyscope.version.internal.i18n.TextResource;
import com.ur.polyscope.version.urversion.URVersionProvider;
import com.ur.swing.SwingUtil;
import com.ur.swing.adapters.AncestorListenerAdapter;
import com.ur.swing.extensible.Extension;
import com.ur.swing.extensible.VerticalPlacementExtension;
import java.awt.Component;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.inject.Inject;
import javax.swing.JLabel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

@Extension(value="AboutInfo")
public class URSoftwareVersionPanel
implements VerticalPlacementExtension {
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private final URVersionProvider urVersionProvider;
    private Future<?> versionUpdaterTask;
    protected JLabel versionInfo;

    @Inject
    public URSoftwareVersionPanel(TextResource textResource, URVersionProvider urVersionProvider) {
        this.urVersionProvider = urVersionProvider;
        this.versionInfo = new JLabel();
        this.versionInfo.putClientProperty("title", textResource.urSoftwareversion());
        this.versionInfo.addAncestorListener((AncestorListener)new AncestorListenerAdapter(){

            public void ancestorAdded(AncestorEvent event) {
                URSoftwareVersionPanel.this.updateMarketingVersionText();
            }
        });
        this.updateMarketingVersionText();
    }

    public VerticalPlacementExtension.PlacementContribution create() {
        return VerticalPlacementExtension.PlacementContribution.locateBefore((int)-1, (VerticalPlacementExtension.PlacementContribution)new VerticalPlacementExtension.PlacementContribution((Component)this.versionInfo));
    }

    private void updateMarketingVersionText() {
        if (this.versionUpdaterTask == null || this.versionUpdaterTask.isDone()) {
            this.versionUpdaterTask = this.executorService.submit(new VersionRunnable());
        }
    }

    private class VersionRunnable
    implements Runnable {
        private VersionRunnable() {
        }

        @Override
        public void run() {
            String marketingVersion = URSoftwareVersionPanel.this.urVersionProvider.getMarketingVersion().toString();
            SwingUtil.invokeLater(() -> URSoftwareVersionPanel.this.versionInfo.setText(marketingVersion));
        }
    }
}

