/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.version.urversion;

import com.ur.lang.EqualsBuilder;
import com.ur.lang.HashCodeBuilder;
import com.ur.polyscope.version.urversion.InvalidSemanticVersionException;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class URVersion
implements Comparable<URVersion> {
    public static final URVersion NULL_VERSION = new URVersion(0, 0, 0);
    public static final URVersion POLYSCOPE_VERSION_3_0 = new URVersion(3, 0, 0);
    public static final URVersion POLYSCOPE_VERSION_3_1 = new URVersion(3, 1, 0);
    public static final URVersion POLYSCOPE_VERSION_3_2 = new URVersion(3, 2, 0);
    public static final URVersion POLYSCOPE_VERSION_PRE_3_0 = new URVersion(0, 0, 0);
    private static final String SUFFIX_REGROUP = "(?:[\\dA-Za-z\\-]+(?:\\.[\\dA-Za-z\\-]+)*)";
    private static final Pattern semanticMatchingRegex = Pattern.compile("^(\\d+)\\.(\\d+)\\.(\\d+)((?:\\-(?:[\\dA-Za-z\\-]+(?:\\.[\\dA-Za-z\\-]+)*))?)((?:\\+(?:[\\dA-Za-z\\-]+(?:\\.[\\dA-Za-z\\-]+)*))?)$");
    private static final Comparator<String> nullSafeStringComparator = Comparator.nullsFirst(String::compareToIgnoreCase);
    private static final Comparator<Integer> nullSafeIntComparator = Comparator.nullsFirst(Integer::compareTo);
    private static final Comparator<URVersion> urVersionComparator = Comparator.comparing(URVersion::getMajorVersion, nullSafeIntComparator).thenComparing(URVersion::getMinorVersion, nullSafeIntComparator).thenComparing(URVersion::getPatchVersion, nullSafeIntComparator).thenComparing(URVersion::getPreRelease, nullSafeStringComparator).thenComparing(URVersion::getBuildMetadata, nullSafeStringComparator);
    private final int majorVersion;
    private final int minorVersion;
    private final int patchVersion;
    private final String preRelease;
    private final String buildMetadata;

    public URVersion(int majorVersion, int minorVersion, int patchVersion) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.patchVersion = patchVersion;
        this.preRelease = "";
        this.buildMetadata = "";
    }

    public URVersion(int majorVersion, int minorVersion, int patchVersion, String preRelease) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.patchVersion = patchVersion;
        this.preRelease = preRelease;
        this.buildMetadata = "";
    }

    public URVersion(int majorVersion, int minorVersion, int patchVersion, String preRelease, String buildMetadata) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.patchVersion = patchVersion;
        this.preRelease = preRelease;
        this.buildMetadata = buildMetadata;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getPatchVersion() {
        return this.patchVersion;
    }

    public String getPreRelease() {
        return this.preRelease;
    }

    public String getBuildMetadata() {
        return this.buildMetadata;
    }

    public boolean isUndefined() {
        return this == NULL_VERSION;
    }

    private String getVersionString() {
        if (this.isUndefined()) {
            return "<version info not available>";
        }
        return this.createVersionString();
    }

    private String createVersionString() {
        return this.majorVersion + "." + this.minorVersion + "." + this.patchVersion + this.preRelease + this.buildMetadata;
    }

    @Override
    public int compareTo(URVersion version) {
        return urVersionComparator.compare(this, version);
    }

    public boolean equals(Object obj) {
        if (obj == null || URVersion.class != obj.getClass()) {
            return false;
        }
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public String toString() {
        return this.getVersionString();
    }

    public static URVersion create(String versionString) throws InvalidSemanticVersionException {
        Matcher semanticMatcher = semanticMatchingRegex.matcher(versionString);
        if (semanticMatcher.matches()) {
            return new URVersion(Integer.parseInt(semanticMatcher.group(1)), Integer.parseInt(semanticMatcher.group(2)), Integer.parseInt(semanticMatcher.group(3)), semanticMatcher.group(4), semanticMatcher.group(5));
        }
        throw new InvalidSemanticVersionException("Did not match valid semantic version");
    }

    public static boolean isLessThan(URVersion leftHandSide, URVersion rightHandSide) {
        return leftHandSide == null || leftHandSide.compareTo(rightHandSide) < 0;
    }
}

