/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.safety.impl.stream;

import com.ur.lang.react.Broadcaster;
import com.ur.math.Length;
import com.ur.monitor.RobotState;
import com.ur.monitor.model.Vector3;
import com.ur.polyscope.controllerinterface.RobotStatePackageConsumer;
import com.ur.polyscope.safety.checksum.CRCCheck;
import com.ur.polyscope.safety.impl.stream.CRCCheckModelSource;
import com.ur.polyscope.safety.impl.stream.ThreePositionDeviceSource;
import com.ur.polyscope.safety.operationalmode.SafetyOperationalMode;
import com.ur.polyscope.safety.position.ElbowPosition;
import com.ur.polyscope.safety.threepositiondevice.ThreePositionDevice;
import com.ur.view.constants.comm.RobotStatePackageType;
import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.inject.Inject;

public class SafetyStateMessageConsumer
implements RobotStatePackageConsumer {
    private final CRCCheckModelSource crcModelSource;
    private final ThreePositionDeviceSource threePositionDeviceSource;
    private final Broadcaster<ElbowPosition> elbowPositionObserver;
    private final Broadcaster<SafetyOperationalMode> safetyOperationModeObserver;

    @Inject
    private SafetyStateMessageConsumer(CRCCheckModelSource crcModelSource, ThreePositionDeviceSource threePositionDeviceSource, @ElbowPosition.Qualifier Broadcaster elbowPositionObserver, @SafetyOperationalMode.Qualifier Broadcaster safetyOperationModeObserver) {
        this.crcModelSource = crcModelSource;
        this.threePositionDeviceSource = threePositionDeviceSource;
        this.elbowPositionObserver = elbowPositionObserver;
        this.safetyOperationModeObserver = safetyOperationModeObserver;
        this.safetyOperationModeObserver.next((Object)SafetyOperationalMode.AUTOMATIC);
    }

    public RobotStatePackageType getPackageType() {
        return RobotStatePackageType.SAFETY_DATA;
    }

    public void initialize(RobotState robotStateToEditHere) {
    }

    public int consume(DataInput stream, int messageLength) throws IOException {
        int messageOffset = 0;
        long crc = ByteBuffer.allocate(8).putInt(4, stream.readInt()).getLong(0);
        CRCCheck crcCheck = new CRCCheck(crc + "");
        messageOffset += 4;
        SafetyOperationalMode operationalModeInput = SafetyOperationalMode.byId((int)stream.readUnsignedByte());
        ThreePositionDevice threePositionDevice = new ThreePositionDevice(stream.readUnsignedByte() > 0);
        messageOffset += 2;
        Vector3 elbowPosition = Vector3.fromDoubleArray((double[])this.getElbowArray(stream));
        Length elbowRadius = Length.from((double)stream.readDouble(), (Length.Unit)Length.Unit.SI);
        this.crcModelSource.emit(crcCheck);
        this.threePositionDeviceSource.emit(threePositionDevice);
        this.safetyOperationModeObserver.next((Object)operationalModeInput);
        this.elbowPositionObserver.next((Object)new RealElbowPosition(elbowPosition, elbowRadius));
        return messageOffset += 32;
    }

    private double[] getElbowArray(DataInput stream) throws IOException {
        double[] elbowPositionArray = new double[3];
        for (int i = 0; i < elbowPositionArray.length; ++i) {
            elbowPositionArray[i] = stream.readDouble();
        }
        return elbowPositionArray;
    }

    private class RealElbowPosition
    implements ElbowPosition {
        private final Vector3 elbowPosition;
        private final Length elbowRadius;

        public RealElbowPosition(Vector3 elbowPosition, Length elbowRadius) {
            this.elbowPosition = elbowPosition;
            this.elbowRadius = elbowRadius;
        }

        public Vector3 getPosition() {
            return this.elbowPosition;
        }

        public Length getRadius() {
            return this.elbowRadius;
        }
    }
}

