/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.internaltcp.domain;

import com.ur.monitor.model.Pose6d;
import javax.vecmath.Vector3d;

public final class TCPOffsetEqualHelper {
    public static final double EPSILON = 1.0E-4;

    private TCPOffsetEqualHelper() {
    }

    public static boolean equalInEpsilon(Pose6d a, Pose6d b) {
        return TCPOffsetEqualHelper.equalPosition(a.getPos(), b.getPos()) && TCPOffsetEqualHelper.equalRotation(a.getRot(), b.getRot());
    }

    private static boolean equalPosition(Vector3d a, Vector3d b) {
        if (!TCPOffsetEqualHelper.equalInEpsilon(a.getX(), b.getX())) {
            return false;
        }
        if (!TCPOffsetEqualHelper.equalInEpsilon(a.getY(), b.getY())) {
            return false;
        }
        return TCPOffsetEqualHelper.equalInEpsilon(a.getZ(), b.getZ());
    }

    private static boolean equalRotation(Vector3d a, Vector3d b) {
        if (!TCPOffsetEqualHelper.equalInEpsilon(TCPOffsetEqualHelper.normalizedAngle(a.getX()), TCPOffsetEqualHelper.normalizedAngle(b.getX()))) {
            return false;
        }
        if (!TCPOffsetEqualHelper.equalInEpsilon(TCPOffsetEqualHelper.normalizedAngle(a.getY()), TCPOffsetEqualHelper.normalizedAngle(b.getY()))) {
            return false;
        }
        return TCPOffsetEqualHelper.equalInEpsilon(TCPOffsetEqualHelper.normalizedAngle(a.getZ()), TCPOffsetEqualHelper.normalizedAngle(b.getZ()));
    }

    private static double normalizedAngle(double d) {
        if (Double.isNaN(d)) {
            return d;
        }
        double c = d;
        if (c < Math.PI * -2 || c > Math.PI * 2) {
            c = d % (Math.PI * 2);
        }
        if (c < 0.0) {
            c += Math.PI * 2;
        }
        return c;
    }

    private static boolean equalInEpsilon(double a, double b) {
        if (Double.isNaN(a) || Double.isNaN(b)) {
            return false;
        }
        return Math.abs(a - b) <= 1.0E-4;
    }
}

