/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.internaltcp.domain;

import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.polyscope.installation.domain.UnderwayInstallationProvider;
import com.ur.polyscope.internaltcp.core.TCP;
import com.ur.polyscope.internaltcp.domain.TCPObserver;
import com.ur.polyscope.internaltcp.domain.TCPPermanentReferenceOwner;
import com.ur.polyscope.internaltcp.domain.TCPReference;
import com.ur.reference.Reference;
import com.ur.reference.ReferenceHandlingStrategyImpl;
import com.ur.reference.ReferenceOwner;
import com.ur.util.event.EventNotificationService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class TCPReferenceHandlingStrategy
extends ReferenceHandlingStrategyImpl<String, com.ur.polyscope.tcp.TCP, TCPReference> {
    private final InstallationComponentLookup installationLookup;
    private final UnderwayInstallationProvider underwayInstallationProvider;

    @Inject
    public TCPReferenceHandlingStrategy(InstallationComponentLookup installationLookup, UnderwayInstallationProvider underwayInstallationProvider) {
        this.installationLookup = installationLookup;
        this.underwayInstallationProvider = underwayInstallationProvider;
        EventNotificationService.register((Object)((Object)this), TCPObserver.class, (Object)new TCPOwnerUpdater());
    }

    protected TCPReference createReference(String key) {
        return new TCPReference(key, this.installationLookup, this.underwayInstallationProvider);
    }

    protected String getKeyFor(com.ur.polyscope.tcp.TCP target) {
        return ((TCP)target).getName();
    }

    public Map<String, TCPReference> getReferences() {
        return this.references;
    }

    public void removeInvalidReferences() {
        HashMap validMap = new HashMap();
        for (String key : this.ownerMap.keySet()) {
            ArrayList<ReferenceOwner> validOwners = new ArrayList<ReferenceOwner>();
            Collection owners = (Collection)this.ownerMap.get(key);
            for (ReferenceOwner owner : owners) {
                if (owner instanceof TCPPermanentReferenceOwner && !((TCPPermanentReferenceOwner)owner).hasRealOwner()) continue;
                validOwners.add(owner);
            }
            validMap.put(key, validOwners);
        }
        this.ownerMap.clear();
        this.ownerMap.putAll(validMap);
    }

    public void clear() {
        ArrayList<TCPPermanentReferenceOwner> permanentOwners = new ArrayList<TCPPermanentReferenceOwner>();
        Collection owners = this.ownerMap.values();
        for (Collection ownersCollection : owners) {
            for (ReferenceOwner owner : ownersCollection) {
                if (!(owner instanceof TCPPermanentReferenceOwner) || !((TCPPermanentReferenceOwner)owner).hasRealOwner()) continue;
                TCPPermanentReferenceOwner refOwner = (TCPPermanentReferenceOwner)owner;
                permanentOwners.add(refOwner);
            }
        }
        super.clear();
        for (TCPPermanentReferenceOwner owner : permanentOwners) {
            TCPReference newRef = this.createReference(owner.getKey());
            ArrayList<TCPReference> list = new ArrayList<TCPReference>();
            list.add(newRef);
            this.setOwnedReferences(owner, list);
        }
    }

    private class TCPOwnerUpdater
    implements TCPObserver {
        private TCPOwnerUpdater() {
        }

        public void nameChanged(TCP entity, String oldName, String newName) {
            TCPReferenceHandlingStrategy.this.keyChange(oldName, newName);
        }

        @Override
        public void added(TCP tcp) {
            TCPReferenceHandlingStrategy.this.referenceChange((Reference)((TCPReference)TCPReferenceHandlingStrategy.this.getReferenceTo(tcp)));
        }

        @Override
        public void removed(TCP tcp) {
            TCPReferenceHandlingStrategy.this.referenceChange((Reference)((TCPReference)TCPReferenceHandlingStrategy.this.getReferenceTo(tcp)));
        }
    }
}

