/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.internaltcp.domain;

import com.ur.lang.naming.NamingService;
import com.ur.monitor.model.Pose6d;
import com.ur.polyscope.installation.Installation;
import com.ur.polyscope.installation.InstallationModifier;
import com.ur.polyscope.installation.InstallationStateListener;
import com.ur.polyscope.installation.domain.PostSetInstallation;
import com.ur.polyscope.installation.domain.UnderWayInstallation;
import com.ur.polyscope.installation.domain.UnderwayInstallationProvider;
import com.ur.polyscope.installation.urcap.contributor.ContributorInfo;
import com.ur.polyscope.internaltcp.core.TCP;
import com.ur.polyscope.internaltcp.domain.TCPContributed;
import com.ur.polyscope.internaltcp.domain.TCPReference;
import com.ur.polyscope.internaltcp.domain.TCPSettings;
import com.ur.polyscope.program.Program;
import com.ur.polyscope.tcp.FinalizableTCP;
import com.ur.polyscope.tcp.TCPCallback;
import com.ur.polyscope.tcp.TCPRef;
import com.ur.polyscope.tcp.TCPService;
import com.ur.polyscope.tcp.TcpControllerEventPublisher;
import com.ur.polyscope.valueobjects.value.ToolPosition;
import com.ur.reference.ReferenceService;
import com.ur.swing.validation.ValidationFactory;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.util.event.EventNotificationService;
import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;

@Singleton
public class TCPServiceImpl
extends InstallationStateListener.Template
implements TCPService,
TcpControllerEventPublisher,
UnderWayInstallation,
PostSetInstallation {
    private final Provider<NamingService> namingServiceProvider;
    private final ReferenceService programReferenceService;
    private UnderwayInstallationProvider underwayInstallationProvider;
    private final InstallationModifier installationModifier;
    private final ArrayList<DelayedTCP> delayedTCPs = new ArrayList();
    private boolean isTCPRemoveAndUpdateAllowed;
    private boolean delayCreation = false;

    @Inject
    public TCPServiceImpl(Provider<NamingService> namingServiceProvider, @Program ReferenceService programReferenceService, UnderwayInstallationProvider underwayInstallationProvider, InstallationModifier installationModifier) {
        this.namingServiceProvider = namingServiceProvider;
        this.programReferenceService = programReferenceService;
        this.underwayInstallationProvider = underwayInstallationProvider;
        this.installationModifier = installationModifier;
        EventNotificationService.register((Object)((Object)this), InstallationStateListener.class, (Object)((Object)this));
    }

    protected boolean isDelayed() {
        return this.delayCreation;
    }

    public void installationUnderWay(Installation robotInstallation) {
        this.delayCreation = true;
        this.startDelayCreation();
    }

    public void postLoad(Installation newInstallation) {
        this.delayCreation = false;
        this.stopDelayCreation();
    }

    public void fireUpdateIfDefaultTCP(com.ur.polyscope.tcp.TCP selectedTCP) {
        TCPSettings tcpSettings = (TCPSettings)this.underwayInstallationProvider.getUnderwayInstallation().getComponent(TCPSettings.class);
        if (selectedTCP == tcpSettings.getSelectedTCP_Old()) {
            tcpSettings.selectTCP(selectedTCP.getDisplayName());
        }
    }

    public void installationLoadFailed() {
        this.delayCreation = false;
        this.delayCreationFailed();
    }

    public boolean isValid(ToolPosition offset) {
        if (!this.isValidTCPPosition(10.0, offset.getPositionX())) {
            return false;
        }
        if (!this.isValidTCPPosition(10.0, offset.getPositionY())) {
            return false;
        }
        return this.isValidTCPPosition(10.0, offset.getPositionZ());
    }

    private boolean isValidTCPPosition(double maxTcpLength, double position) {
        ValidationStrategy lengthValidator = ValidationFactory.getRangeValidator((double)(-maxTcpLength), (double)maxTcpLength, (String)"Pose offset is outside the legal range");
        return lengthValidator.isValid(Double.toString(position));
    }

    public synchronized com.ur.polyscope.tcp.TCP createTCP(String suggestedName, ToolPosition offset, ContributorInfo contributorInfo) {
        if (!this.isDelayed()) {
            return this.addRealTCP(suggestedName, offset, contributorInfo);
        }
        DelayedTCP delayedTCP = new DelayedTCP(suggestedName, offset, contributorInfo);
        this.delayedTCPs.add(delayedTCP);
        return delayedTCP;
    }

    public com.ur.polyscope.tcp.TCP createTCP(String suggestedName, ToolPosition offset) {
        return this.createTCP(suggestedName, offset, null);
    }

    public TCPRef getTCPRef(com.ur.polyscope.tcp.TCP tcp) {
        return (TCPRef)this.programReferenceService.getReference(TCPReference.class, (Object)tcp.getDisplayName());
    }

    public TCPRef getTCPRef(String name) {
        return (TCPRef)this.programReferenceService.getReference(TCPReference.class, (Object)name);
    }

    private com.ur.polyscope.tcp.TCP addRealTCP(String suggestedName, ToolPosition offset, ContributorInfo contributorInfo) {
        String uniqueName = ((NamingService)this.namingServiceProvider.get()).makeUniqueName(TCP.class, suggestedName);
        return contributorInfo == null ? this.getTCPSettings().addNewTCP(uniqueName, new Pose6d(offset.asArray())) : this.getTCPSettings().addNewTCP(uniqueName, new Pose6d(offset.asArray()), contributorInfo);
    }

    public Collection<TCPRef> getTCPs() {
        ArrayList<TCPRef> tcpRefs = new ArrayList<TCPRef>();
        for (com.ur.polyscope.tcp.TCP tcp : this.getTCPSettings().getAllTCPs()) {
            tcpRefs.add((TCPRef)this.programReferenceService.getReferenceTo(TCPReference.class, (Object)tcp));
        }
        return tcpRefs;
    }

    public TCPRef getTCPByName(String name) {
        return (TCPRef)this.programReferenceService.getReference(TCPReference.class, (Object)name);
    }

    public TCPRef getTCPByContributionInfo(ContributorInfo contributorInfo) {
        for (TCPRef tcpRef : this.getTCPs()) {
            ContributorInfo info;
            com.ur.polyscope.tcp.TCP tcp = this.isDelayed() ? ((TCPSettings)this.underwayInstallationProvider.getUnderwayInstallation().getComponent(TCPSettings.class)).getTCPByName(tcpRef.getKey()) : tcpRef.dereferenceInUnderwayInstallation();
            if (!(tcp instanceof TCPContributed) || (info = ((TCPContributed)tcp).getContributorInfo()) == null || !info.getOwnerId().equals(contributorInfo.getOwnerId()) || !info.getId().equals(contributorInfo.getId())) continue;
            return tcpRef;
        }
        return null;
    }

    public com.ur.polyscope.tcp.TCP getDelayedTCPByContributionInfo(ContributorInfo contributorInfo) {
        for (DelayedTCP delayedTCP : this.delayedTCPs) {
            ContributorInfo info = delayedTCP.getContributorInfo();
            if (info == null || !info.getOwnerId().equals(contributorInfo.getOwnerId()) || !info.getId().equals(contributorInfo.getId())) continue;
            return delayedTCP;
        }
        return null;
    }

    public Collection<TCPRef> getContributedTCPsByOwnerId(String ownerId) {
        ArrayList<TCPRef> tcps = new ArrayList<TCPRef>();
        for (TCPRef tcpRef : this.getTCPs()) {
            com.ur.polyscope.tcp.TCP tcp = tcpRef.dereferenceInUnderwayInstallation();
            if (!this.isTCPContributedByOwner(tcp, ownerId)) continue;
            tcps.add(tcpRef);
        }
        return tcps;
    }

    private boolean isTCPContributedByOwner(com.ur.polyscope.tcp.TCP tcp, String ownerId) {
        ContributorInfo info;
        return tcp instanceof TCPContributed && (info = ((TCPContributed)tcp).getContributorInfo()) != null && ownerId != null && ownerId.equals(info.getOwnerId());
    }

    public boolean deregisterTCP(com.ur.polyscope.tcp.TCP tcp) {
        if (tcp instanceof TCPContributed) {
            this.getTCPSettings().removeTCP(tcp);
            return true;
        }
        return false;
    }

    public boolean removeDelayedTCP(com.ur.polyscope.tcp.TCP delayedTCP) {
        boolean remove = this.delayedTCPs.remove(delayedTCP);
        this.installationModifier.makeDirty();
        return remove;
    }

    private TCPSettings getTCPSettings() {
        return (TCPSettings)this.underwayInstallationProvider.getUnderwayInstallation().getComponent(TCPSettings.class);
    }

    public boolean isTCPRemoveAndUpdateAllowed() {
        return this.isTCPRemoveAndUpdateAllowed;
    }

    public void setTCPRemoveAndUpdateAllowed(boolean value) {
        this.isTCPRemoveAndUpdateAllowed = value;
    }

    private void startDelayCreation() {
        this.delayedTCPs.clear();
    }

    private void stopDelayCreation() {
        this.processDelayedTCPs();
    }

    private void delayCreationFailed() {
        this.delayedTCPs.clear();
    }

    private void processDelayedTCPs() {
        for (DelayedTCP delayedTCP : this.delayedTCPs) {
            com.ur.polyscope.tcp.TCP tcp = this.addRealTCP(delayedTCP.suggestedName, delayedTCP.offset, delayedTCP.contributorInfo);
            delayedTCP.getFinalizeCallback().onFinalize(tcp);
            this.installationModifier.makeDirty();
        }
        this.delayedTCPs.clear();
    }

    private static class DelayedTCP
    implements com.ur.polyscope.tcp.TCP,
    FinalizableTCP {
        private final String suggestedName;
        private final ContributorInfo contributorInfo;
        private ToolPosition offset;
        private TCPCallback callback;

        public DelayedTCP(String suggestedName, ToolPosition offset, ContributorInfo contributorInfo) {
            this.suggestedName = suggestedName;
            this.offset = offset;
            this.contributorInfo = contributorInfo;
        }

        public ToolPosition getOffsetPose() {
            return this.offset;
        }

        public void setOffset(ToolPosition offset) {
            this.offset = offset;
        }

        public String getDisplayName() {
            return this.suggestedName;
        }

        public TCPCallback getFinalizeCallback() {
            return this.callback;
        }

        public void setFinalizeCallback(TCPCallback callback) {
            this.callback = callback;
        }

        public ContributorInfo getContributorInfo() {
            return this.contributorInfo;
        }
    }
}

