/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.internaltcp.domain;

import com.google.common.collect.ImmutableList;
import com.ur.lang.EqualsUtil;
import com.ur.lang.naming.NamedEntity;
import com.ur.monitor.RobotState;
import com.ur.monitor.model.Pose6d;
import com.ur.polyscope.installation.InstallationChangedEvent;
import com.ur.polyscope.installation.aspect.InstallationChangeEventAspect;
import com.ur.polyscope.installation.urcap.contributor.ContributorInfo;
import com.ur.polyscope.internaltcp.core.HasUUID;
import com.ur.polyscope.internaltcp.core.TCP;
import com.ur.polyscope.internaltcp.domain.TCPContributed;
import com.ur.polyscope.internaltcp.domain.TCPFactory;
import com.ur.polyscope.internaltcp.domain.TCPObserver;
import com.ur.polyscope.internaltcp.domain.TCPOffsetEqualHelper;
import com.ur.polyscope.internaltcp.domain.TCPSettings;
import com.ur.polyscope.internaltcp.domain.TCPSettingsImpl$AjcClosure1;
import com.ur.polyscope.internaltcp.domain.TCPSettingsImpl$AjcClosure3;
import com.ur.polyscope.internaltcp.domain.TCPSettingsImpl$AjcClosure5;
import com.ur.polyscope.internaltcp.impl.ControllerSocketSender;
import com.ur.polyscope.internaltcp.impl.tcp.usecases.InstallationChangesToControllerListener;
import com.ur.polyscope.scriptwriter.ScriptGeneratorLookup;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.polyscope.valueobjects.value.ToolPosition;
import com.ur.util.event.EventNotificationService;
import com.ur.util.event.NotificationStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class TCPSettingsImpl
implements TCPSettings {
    private static TCP undefinedActiveTCP;
    private final TCPFactory tcpFactory;
    private final List<com.ur.polyscope.tcp.TCP> tcps = Collections.synchronizedList(new ArrayList());
    private String selectedTCPName = null;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    @Inject
    public TCPSettingsImpl(TCPFactory tcpFactory) {
        this.tcpFactory = tcpFactory;
    }

    public Class<?> getType() {
        return TCPSettings.class;
    }

    @Override
    public com.ur.polyscope.tcp.TCP addNewTCP() {
        TCP newTCP = this.tcpFactory.create();
        this.addTCP(newTCP);
        return newTCP;
    }

    @Override
    public com.ur.polyscope.tcp.TCP addNewTCP(Pose6d offset) {
        TCP newTCP = this.tcpFactory.create(offset);
        this.addTCP(newTCP);
        return newTCP;
    }

    @Override
    public com.ur.polyscope.tcp.TCP addNewTCP(String name, Pose6d offset) {
        TCP newTCP = this.tcpFactory.create(name, offset);
        this.addTCP(newTCP);
        return newTCP;
    }

    @Override
    public com.ur.polyscope.tcp.TCP addNewTCP(String name, Pose6d offset, ContributorInfo contributorInfo) {
        TCP newTCP = this.tcpFactory.create(name, offset, contributorInfo);
        this.addTCP(newTCP);
        return newTCP;
    }

    @Override
    @InstallationChangedEvent
    public void addTCP(com.ur.polyscope.tcp.TCP newTCP) {
        com.ur.polyscope.tcp.TCP tCP = newTCP;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)tCP);
        Object[] objectArray = new Object[]{this, tCP, joinPoint};
        TCPSettingsImpl$AjcClosure1 tCPSettingsImpl$AjcClosure1 = new TCPSettingsImpl$AjcClosure1(objectArray);
        InstallationChangeEventAspect.aspectOf().aroundAnnotatedMethod(tCPSettingsImpl$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @Override
    @InstallationChangedEvent
    public void removeTCP(com.ur.polyscope.tcp.TCP tcp) {
        com.ur.polyscope.tcp.TCP tCP = tcp;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)tCP);
        Object[] objectArray = new Object[]{this, tCP, joinPoint};
        TCPSettingsImpl$AjcClosure3 tCPSettingsImpl$AjcClosure3 = new TCPSettingsImpl$AjcClosure3(objectArray);
        InstallationChangeEventAspect.aspectOf().aroundAnnotatedMethod(tCPSettingsImpl$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    private com.ur.polyscope.tcp.TCP getFirstUserDefinedTCPBeforeThanRemovedOne(List<com.ur.polyscope.tcp.TCP> allTCPs, int lastActiveTCPIndex) {
        while (lastActiveTCPIndex-- > 0) {
            com.ur.polyscope.tcp.TCP newActiveTCP = allTCPs.get(lastActiveTCPIndex);
            if (newActiveTCP instanceof TCPContributed) continue;
            return newActiveTCP;
        }
        return null;
    }

    @Override
    public com.ur.polyscope.tcp.TCP getSelectedTCP_Old() {
        com.ur.polyscope.tcp.TCP activeTCP = this.getTCPByName(this.selectedTCPName);
        if (activeTCP == null) {
            activeTCP = this.getAllTCPs().iterator().next();
            this.selectedTCPName = ((NamedEntity)activeTCP).getName();
        }
        return activeTCP;
    }

    @Override
    @InstallationChangedEvent
    public boolean selectTCP(String name) {
        String string = name;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        TCPSettingsImpl$AjcClosure5 tCPSettingsImpl$AjcClosure5 = new TCPSettingsImpl$AjcClosure5(objectArray);
        return Conversions.booleanValue((Object)InstallationChangeEventAspect.aspectOf().aroundAnnotatedMethod(tCPSettingsImpl$AjcClosure5.linkClosureAndJoinPoint(69648)));
    }

    @Override
    public com.ur.polyscope.tcp.TCP getTCPByName(String name) {
        for (com.ur.polyscope.tcp.TCP each : this.tcps) {
            if (!EqualsUtil.equals((Object)name, (Object)((NamedEntity)each).getName())) continue;
            return each;
        }
        return null;
    }

    @Override
    public List<com.ur.polyscope.tcp.TCP> getAllTCPs() {
        if (this.tcps.isEmpty()) {
            this.addNewTCP();
        }
        Collections.sort(this.tcps, new TCPComparator());
        return ImmutableList.copyOf(this.tcps);
    }

    @Override
    public List<TCPContributed> getContributedTCPs() {
        ArrayList<TCPContributed> urCapDefinedTCPs = new ArrayList<TCPContributed>();
        List<com.ur.polyscope.tcp.TCP> allTCPs = this.getAllTCPs();
        for (com.ur.polyscope.tcp.TCP tcp : allTCPs) {
            if (!(tcp instanceof TCPContributed)) continue;
            urCapDefinedTCPs.add((TCPContributed)tcp);
        }
        return urCapDefinedTCPs;
    }

    @Override
    public List<com.ur.polyscope.tcp.TCP> getUserDefinedTCPs() {
        ArrayList<com.ur.polyscope.tcp.TCP> userDefinedTCPs = new ArrayList<com.ur.polyscope.tcp.TCP>();
        List<com.ur.polyscope.tcp.TCP> allTCPs = this.getAllTCPs();
        for (com.ur.polyscope.tcp.TCP tcp : allTCPs) {
            if (tcp instanceof TCPContributed) continue;
            userDefinedTCPs.add(tcp);
        }
        return userDefinedTCPs;
    }

    @Override
    public com.ur.polyscope.tcp.TCP getTCPByUUID(UUID id) {
        for (com.ur.polyscope.tcp.TCP each : this.tcps) {
            if (!EqualsUtil.equals((Object)((HasUUID)each).getId(), (Object)id)) continue;
            return each;
        }
        return null;
    }

    @Override
    public com.ur.polyscope.tcp.TCP getActiveTCP() {
        RobotState robotState = RobotState.getLatestRobotState();
        Pose6d activeTCP = robotState.tcpOffset;
        com.ur.polyscope.tcp.TCP result = this.getSelectedTcpIfEqualTo(activeTCP);
        if (result != null) {
            return result;
        }
        result = this.getFirstTcpEqualTo(activeTCP);
        if (result != null) {
            return result;
        }
        return TCPSettingsImpl.getUndefinedActiveTCP(activeTCP, this.tcpFactory);
    }

    private com.ur.polyscope.tcp.TCP getFirstTcpEqualTo(Pose6d activeTCP) {
        for (com.ur.polyscope.tcp.TCP tcp : this.tcps) {
            if (!TCPOffsetEqualHelper.equalInEpsilon(((TCP)tcp).getOffset(), activeTCP)) continue;
            return tcp;
        }
        return null;
    }

    private com.ur.polyscope.tcp.TCP getSelectedTcpIfEqualTo(Pose6d activeTCP) {
        com.ur.polyscope.tcp.TCP selectedTCP = this.getTCPByName(this.selectedTCPName);
        if (selectedTCP != null && TCPOffsetEqualHelper.equalInEpsilon(((TCP)selectedTCP).getOffset(), activeTCP)) {
            return selectedTCP;
        }
        return null;
    }

    private static com.ur.polyscope.tcp.TCP getUndefinedActiveTCP(Pose6d tcpOffset, TCPFactory tcpFactory) {
        if (undefinedActiveTCP == null) {
            undefinedActiveTCP = tcpFactory.createUndefinedTcp(tcpOffset);
        } else {
            undefinedActiveTCP.setOffsetSilently(tcpOffset);
        }
        return undefinedActiveTCP;
    }

    public boolean canGenerateScriptCode() {
        return true;
    }

    public void generatePreambleScript(ScriptWriter writer, ScriptGeneratorLookup scriptGeneratorLookup) {
        writer.appendLine(ControllerSocketSender.set_TCP_transform(new Pose6d(this.getSelectedTCP_Old().getOffsetPose().asArray())));
    }

    @Override
    public com.ur.polyscope.tcp.TCP getSelectedTCP() {
        final com.ur.polyscope.tcp.TCP selectedTCPOld = this.getActiveTCP();
        com.ur.polyscope.tcp.TCP tcp = new com.ur.polyscope.tcp.TCP(){

            public ToolPosition getOffsetPose() {
                return selectedTCPOld.getOffsetPose();
            }

            public void setOffset(ToolPosition offset) {
            }

            public String getDisplayName() {
                return selectedTCPOld.getDisplayName();
            }
        };
        return tcp;
    }

    static {
        TCPSettingsImpl.ajc$preClinit();
    }

    static final /* synthetic */ void addTCP_aroundBody0(TCPSettingsImpl ajc$this, final com.ur.polyscope.tcp.TCP newTCP, JoinPoint joinPoint) {
        ajc$this.tcps.add(newTCP);
        EventNotificationService.notify(TCPObserver.class, (NotificationStrategy)new NotificationStrategy<TCPObserver>(){

            public void notify(TCPObserver listener) {
                listener.added((TCP)newTCP);
            }
        });
    }

    static final /* synthetic */ void removeTCP_aroundBody2(TCPSettingsImpl ajc$this, final com.ur.polyscope.tcp.TCP tcp, JoinPoint joinPoint) {
        if (!(tcp instanceof TCPContributed) && ajc$this.getUserDefinedTCPs().size() <= 1) {
            return;
        }
        int activeTCPIndex = -1;
        if (EqualsUtil.equals((Object)((NamedEntity)tcp).getName(), (Object)ajc$this.selectedTCPName)) {
            activeTCPIndex = ajc$this.tcps.indexOf(tcp);
        }
        ajc$this.tcps.remove(tcp);
        ajc$this.tcpFactory.remove((TCP)tcp);
        if (activeTCPIndex != -1) {
            List<com.ur.polyscope.tcp.TCP> allTCPs;
            com.ur.polyscope.tcp.TCP newActiveTCP;
            if (activeTCPIndex > 0) {
                --activeTCPIndex;
            }
            if ((newActiveTCP = (allTCPs = ajc$this.getAllTCPs()).get(activeTCPIndex)) instanceof TCPContributed) {
                newActiveTCP = ajc$this.getFirstUserDefinedTCPBeforeThanRemovedOne(allTCPs, activeTCPIndex);
            }
            if (newActiveTCP != null) {
                ajc$this.selectTCP(((TCP)newActiveTCP).getName());
            }
        }
        EventNotificationService.notify(TCPObserver.class, (NotificationStrategy)new NotificationStrategy<TCPObserver>(){

            public void notify(TCPObserver listener) {
                listener.removed((TCP)tcp);
            }
        });
    }

    static final /* synthetic */ boolean selectTCP_aroundBody4(TCPSettingsImpl ajc$this, String name, JoinPoint joinPoint) {
        boolean result = false;
        if (!EqualsUtil.equals((Object)ajc$this.selectedTCPName, (Object)name)) {
            ajc$this.selectedTCPName = name;
            result = true;
        }
        EventNotificationService.notify(InstallationChangesToControllerListener.class, (NotificationStrategy)new NotificationStrategy<InstallationChangesToControllerListener>(){

            public void notify(InstallationChangesToControllerListener listener) {
                listener.tcpSettingsChanged(TCPSettingsImpl.this);
            }
        });
        return result;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TCPSettingsImpl.java", TCPSettingsImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addTCP", "com.ur.polyscope.internaltcp.domain.TCPSettingsImpl", "com.ur.polyscope.tcp.TCP", "newTCP", "", "void"), 73);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "removeTCP", "com.ur.polyscope.internaltcp.domain.TCPSettingsImpl", "com.ur.polyscope.tcp.TCP", "tcp", "", "void"), 85);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "selectTCP", "com.ur.polyscope.internaltcp.domain.TCPSettingsImpl", "java.lang.String", "name", "", "boolean"), 143);
    }

    private static class TCPComparator
    implements Comparator<Object> {
        private TCPComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            if (o1.getClass() == TCP.class && o2.getClass() == TCP.class) {
                return ((com.ur.polyscope.tcp.TCP)o1).getDisplayName().compareTo(((com.ur.polyscope.tcp.TCP)o2).getDisplayName());
            }
            if (o1.getClass() == TCPContributed.class && o2.getClass() == TCPContributed.class) {
                return ((com.ur.polyscope.tcp.TCP)o1).getDisplayName().compareTo(((com.ur.polyscope.tcp.TCP)o2).getDisplayName());
            }
            if (o1.getClass() == TCPContributed.class && o2.getClass() == TCP.class) {
                return 1;
            }
            if (o1.getClass() == TCP.class && o2.getClass() == TCPContributed.class) {
                return -1;
            }
            return 0;
        }
    }
}

