/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.internaltcp.domain;

import com.ur.monitor.model.Pose6d;
import com.ur.polyscope.visualizer.element.VisualizerElement;
import com.ur.polyscope.visualizer.element.VisualizerElementType;
import com.ur.polyscope.visualizer.utils.AxesVisualization;
import com.ur.polyscope.visualizer.utils.Pose6dTransformUtils;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Vector3d;

public class TCPVisualization
implements VisualizerElement {
    private TransformGroup positionTransformGroup;

    public Node getElementNode() {
        this.positionTransformGroup = new TransformGroup();
        this.positionTransformGroup.setCapability(18);
        this.positionTransformGroup.setCapability(17);
        this.positionTransformGroup.addChild((Node)AxesVisualization.getElementNode());
        return this.positionTransformGroup;
    }

    public void setPosition(Pose6d positionInBaseCoordinates) {
        Vector3d o;
        if (this.positionTransformGroup == null) {
            return;
        }
        Vector3d p = positionInBaseCoordinates.getPos();
        if (this.baseCoordinatesAreNaN(p, o = positionInBaseCoordinates.getRot())) {
            positionInBaseCoordinates = new Pose6d();
        }
        this.positionTransformGroup.setTransform(Pose6dTransformUtils.getTransform3D((Pose6d)positionInBaseCoordinates));
    }

    private boolean baseCoordinatesAreNaN(Vector3d p, Vector3d o) {
        if (Double.isNaN(p.x) || Double.isNaN(p.y) || Double.isNaN(p.z)) {
            return true;
        }
        return Double.isNaN(o.x) || Double.isNaN(o.y) || Double.isNaN(o.z);
    }

    public void setPosition(Transform3D positionInBaseCoordinates) {
        if (this.positionTransformGroup == null) {
            return;
        }
        this.positionTransformGroup.setTransform(positionInBaseCoordinates);
    }

    public VisualizerElementType getElementType() {
        return VisualizerElementType.TCP;
    }

    public void update() {
    }
}

