/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.internaltcp.impl;

import com.ur.monitor.RobotState;
import com.ur.monitor.model.Pose6d;
import com.ur.polyscope.controllerinterface.ControllerConnectionListener;
import com.ur.polyscope.controllerinterface.ControllerInterface;
import com.ur.util.Waiting;
import com.ur.util.event.EventNotificationService;
import com.ur.util.event.NotificationStrategy;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.vecmath.Vector3d;

public class ControllerSocketSender {
    private static final String END_PROGRAM = "end\n";
    private static List<StopRobotListener> stopRobotListeners = new ArrayList<StopRobotListener>();
    private static ControllerInterface controllerInterface;

    private ControllerSocketSender() {
    }

    @Inject
    public static void setControllerInterface(ControllerInterface controllerInterface) {
        ControllerSocketSender.controllerInterface = controllerInterface;
    }

    public static String set_TCP_transform(Pose6d pose) {
        StringBuffer b = new StringBuffer();
        b.append("set_tcp(" + pose + ")\n");
        return b.toString();
    }

    public static boolean sendStopProgram() {
        boolean didWritBytes = controllerInterface.runScript("stop program\n");
        CopyOnWriteArrayList<StopRobotListener> copyList = new CopyOnWriteArrayList<StopRobotListener>(stopRobotListeners);
        for (StopRobotListener stopRobotListener : copyList) {
            stopRobotListener.stopProgramSent();
        }
        if (didWritBytes) {
            controllerInterface.setUserProgramOnRobot(false);
        }
        return didWritBytes;
    }

    public static void sendSetToolPayload(double toolPayload, Vector3d cog) {
        StringBuilder b = new StringBuilder();
        b.append("sec setToolPayload():\n");
        b.append("  set_payload(" + toolPayload + ", [" + cog.getX() + "," + cog.getY() + "," + cog.getZ() + "])\n");
        b.append(END_PROGRAM);
        controllerInterface.runScript(b.toString());
    }

    public static void sendSetToolPayload(double toolPayload) {
        StringBuilder b = new StringBuilder();
        b.append("sec setToolPayload():\n");
        b.append("  set_payload(" + toolPayload + ", get_target_payload_cog())\n");
        b.append(END_PROGRAM);
        controllerInterface.runScript(b.toString());
    }

    public static String set_gravity(Vector3d gravity) {
        return "set_gravity([" + gravity.x + ", " + gravity.y + ", " + gravity.z + "])";
    }

    static String toControllerBoolean(boolean b) {
        return b ? "True" : "False";
    }

    public static void setRealRobotBlocking() {
        if (controllerInterface.isConnected()) {
            new Thread(new TrySetRealRobot()).start();
        }
    }

    public static interface StopRobotListener
    extends EventListener {
        public void stopProgramSent();
    }

    private static class TrySetRealRobot
    implements Runnable {
        private TrySetRealRobot() {
        }

        @Override
        public void run() {
            if (controllerInterface.runScript("set real\n")) {
                int i = 0;
                while (i < 150) {
                    if (RobotState.getLatestRobotState().real) {
                        return;
                    }
                    Waiting.pause((long)10L, (TimeUnit)TimeUnit.MILLISECONDS);
                    ++i;
                }
                this.notifyFailureOnMessage();
            }
        }

        private void notifyFailureOnMessage() {
            EventNotificationService.notify(ControllerConnectionListener.class, (NotificationStrategy)new NotificationStrategy<ControllerConnectionListener>(){

                public void notify(ControllerConnectionListener listener) {
                    listener.failedToSendMessage("set real");
                }
            });
        }
    }
}

