/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.internaltcp.impl;

import com.ur.polyscope.controllerinterface.synchroneous.HMCInterface;
import com.ur.polyscope.controllerinterface.synchroneous.HMCResponse;
import com.ur.polyscope.internaltcp.impl.tcp.usecases.TCPControllerRPC;
import com.ur.polyscope.valueobjects.Weight;
import com.ur.util.logging.Log;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import javax.inject.Inject;

public class HMC
implements TCPControllerRPC {
    private static HMCInterface hmcInterface;

    @Inject
    public static void setHmcInterface(HMCInterface hmcInterface) {
        HMC.hmcInterface = hmcInterface;
    }

    private HMCResponse sendHMCMessageAndWait(String message) {
        return hmcInterface.sendHMCMessageAndWait(message);
    }

    @Override
    public Weight getPayloadMass() {
        HMCResponse hmcResponseMessage = this.sendHMCMessageAndWait("get_payload_mass()");
        if (hmcResponseMessage != null) {
            try {
                ByteArrayInputStream stream = new ByteArrayInputStream(hmcResponseMessage.getResponseData());
                DataInputStream dataStream = new DataInputStream(stream);
                return Weight.from((double)dataStream.readDouble(), (Weight.Unit)Weight.Unit.SI);
            }
            catch (IOException e) {
                Log.error((String)("Parse error (or similar): " + e));
            }
        }
        return Weight.from((double)-1.0, (Weight.Unit)Weight.Unit.SI);
    }
}

