/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.internaltcp.impl;

import com.ur.monitor.RobotState;
import com.ur.monitor.model.Pose6d;
import com.ur.polyscope.controllerinterface.ControllerInterface;
import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.polyscope.internaltcp.core.TCP;
import com.ur.polyscope.internaltcp.domain.TCPSettings;
import com.ur.polyscope.internaltcp.impl.tcp.usecases.InstallationChangesToControllerListener;
import javax.inject.Inject;

public class InstallationChangesToControllerListenerImpl
implements InstallationChangesToControllerListener {
    private ControllerInterface controllerInterface;
    private final InstallationComponentLookup robotInstallationLookupService;

    @Inject
    public InstallationChangesToControllerListenerImpl(ControllerInterface controllerInterface, InstallationComponentLookup robotInstallationLookupService) {
        this.controllerInterface = controllerInterface;
        this.robotInstallationLookupService = robotInstallationLookupService;
    }

    @Override
    public void tcpSettingsChanged(TCPSettings tcpSettings) {
        if (this.shouldChangesBeApplied(tcpSettings)) {
            this.pauseProgramIfRunning();
            this.sendSetTCPTransform(((TCP)tcpSettings.getSelectedTCP_Old()).getOffset());
        }
    }

    @Override
    public void toolPayloadChanged(TCPSettings tcpSettings) {
        if (this.shouldChangesBeApplied(tcpSettings)) {
            this.pauseProgramIfRunning();
        }
    }

    private boolean shouldChangesBeApplied(TCPSettings tcpSettings) {
        return this.robotInstallationLookupService.hasInstallation() && this.robotInstallationLookupService.getComponent(TCPSettings.class) == tcpSettings;
    }

    private void pauseProgramIfRunning() {
        if (RobotState.getLatestRobotState().programRunning) {
            this.controllerInterface.runScript("pause program\n");
        }
    }

    private void sendSetTCPTransform(Pose6d pose) {
        String b = "sec setTCPTransform():\n  set_tcp(" + pose + ")\n" + "end\n";
        this.controllerInterface.runScript(b);
    }
}

